/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.client.jdbc42.internal.jpountz.lz4;

import com.databricks.client.jdbc42.internal.jpountz.lz4.LZ4ByteBufferUtils;
import com.databricks.client.jdbc42.internal.jpountz.lz4.LZ4Exception;
import com.databricks.client.jdbc42.internal.jpountz.lz4.LZ4SafeDecompressor;
import com.databricks.client.jdbc42.internal.jpountz.lz4.LZ4SafeUtils;
import com.databricks.client.jdbc42.internal.jpountz.lz4.LZ4Utils;
import com.databricks.client.jdbc42.internal.jpountz.util.ByteBufferUtils;
import com.databricks.client.jdbc42.internal.jpountz.util.SafeUtils;
import java.nio.ByteBuffer;

final class LZ4JavaSafeSafeDecompressor
extends LZ4SafeDecompressor {
    public static final LZ4SafeDecompressor INSTANCE = new LZ4JavaSafeSafeDecompressor();

    LZ4JavaSafeSafeDecompressor() {
    }

    @Override
    public int decompress(byte[] src, int srcOff, int srcLen, byte[] dest, int destOff, int destLen) {
        int literalCopyEnd;
        SafeUtils.checkRange(src, srcOff, srcLen);
        SafeUtils.checkRange(dest, destOff, destLen);
        if (destLen == 0) {
            if (srcLen != 1 || SafeUtils.readByte(src, srcOff) != 0) {
                throw new LZ4Exception("Output buffer too small");
            }
            return 0;
        }
        int srcEnd = srcOff + srcLen;
        int destEnd = destOff + destLen;
        int sOff = srcOff;
        int dOff = destOff;
        while (true) {
            int matchCopyEnd;
            if (sOff >= srcEnd) {
                throw new LZ4Exception("Malformed input at " + sOff);
            }
            int token = SafeUtils.readByte(src, sOff) & 0xFF;
            ++sOff;
            int literalLen = token >>> 4;
            if (literalLen == 15) {
                int len = -1;
                while (sOff < srcEnd) {
                    byte by = SafeUtils.readByte(src, sOff++);
                    len = by;
                    if (by != -1) break;
                    if ((literalLen += 255) >= 0) continue;
                    throw new LZ4Exception("Too large literalLen");
                }
                literalLen += len & 0xFF;
            }
            if ((literalCopyEnd = dOff + literalLen) < dOff) {
                throw new LZ4Exception("Too large literalLen");
            }
            if (LZ4Utils.notEnoughSpace(destEnd - literalCopyEnd, 8) || LZ4Utils.notEnoughSpace(srcEnd - sOff, 8 + literalLen)) {
                if (literalCopyEnd > destEnd) {
                    throw new LZ4Exception();
                }
                if (sOff + literalLen != srcEnd) {
                    throw new LZ4Exception("Malformed input at " + sOff);
                }
                LZ4SafeUtils.safeArraycopy(src, sOff, dest, dOff, literalLen);
                sOff += literalLen;
                break;
            }
            LZ4SafeUtils.wildArraycopy(src, sOff, dest, dOff, literalLen);
            dOff = literalCopyEnd;
            int matchDec = SafeUtils.readShortLE(src, sOff += literalLen);
            sOff += 2;
            int matchOff = dOff - matchDec;
            if (matchOff < destOff) {
                throw new LZ4Exception("Malformed input at " + sOff);
            }
            int matchLen = token & 0xF;
            if (matchLen == 15) {
                int len = -1;
                while (sOff < srcEnd) {
                    byte by = SafeUtils.readByte(src, sOff++);
                    len = by;
                    if (by != -1) break;
                    if ((matchLen += 255) >= 0) continue;
                    throw new LZ4Exception("Too large matchLen");
                }
                matchLen += len & 0xFF;
            }
            if ((matchCopyEnd = dOff + (matchLen += 4)) < dOff) {
                throw new LZ4Exception("Too large matchLen");
            }
            if (matchDec == 0) {
                if (matchCopyEnd > destEnd) {
                    throw new LZ4Exception("Malformed input at " + sOff);
                }
                assert (matchOff == dOff);
                LZ4Utils.zero(dest, dOff, matchCopyEnd);
            } else if (LZ4Utils.notEnoughSpace(destEnd - matchCopyEnd, 8)) {
                if (matchCopyEnd > destEnd) {
                    throw new LZ4Exception("Malformed input at " + sOff);
                }
                LZ4SafeUtils.safeIncrementalCopy(dest, matchOff, dOff, matchLen);
            } else {
                LZ4SafeUtils.wildIncrementalCopy(dest, matchOff, dOff, matchCopyEnd);
            }
            dOff = matchCopyEnd;
        }
        dOff = literalCopyEnd;
        return dOff - destOff;
    }

    @Override
    public int decompress(ByteBuffer src, int srcOff, int srcLen, ByteBuffer dest, int destOff, int destLen) {
        int literalCopyEnd;
        ByteBufferUtils.checkRange(src, srcOff, srcLen);
        ByteBufferUtils.checkRange(dest, destOff, destLen);
        if (src.hasArray() && dest.hasArray()) {
            return this.decompress(src.array(), srcOff + src.arrayOffset(), srcLen, dest.array(), destOff + dest.arrayOffset(), destLen);
        }
        src = ByteBufferUtils.inNativeByteOrder(src);
        dest = ByteBufferUtils.inNativeByteOrder(dest);
        if (destLen == 0) {
            if (srcLen != 1 || ByteBufferUtils.readByte(src, srcOff) != 0) {
                throw new LZ4Exception("Output buffer too small");
            }
            return 0;
        }
        int srcEnd = srcOff + srcLen;
        int destEnd = destOff + destLen;
        int sOff = srcOff;
        int dOff = destOff;
        while (true) {
            int matchCopyEnd;
            if (sOff >= srcEnd) {
                throw new LZ4Exception("Malformed input at " + sOff);
            }
            int token = ByteBufferUtils.readByte(src, sOff) & 0xFF;
            ++sOff;
            int literalLen = token >>> 4;
            if (literalLen == 15) {
                int len = -1;
                while (sOff < srcEnd) {
                    byte by = ByteBufferUtils.readByte(src, sOff++);
                    len = by;
                    if (by != -1) break;
                    if ((literalLen += 255) >= 0) continue;
                    throw new LZ4Exception("Too large literalLen");
                }
                literalLen += len & 0xFF;
            }
            if ((literalCopyEnd = dOff + literalLen) < dOff) {
                throw new LZ4Exception("Too large literalLen");
            }
            if (LZ4Utils.notEnoughSpace(destEnd - literalCopyEnd, 8) || LZ4Utils.notEnoughSpace(srcEnd - sOff, 8 + literalLen)) {
                if (literalCopyEnd > destEnd) {
                    throw new LZ4Exception();
                }
                if (sOff + literalLen != srcEnd) {
                    throw new LZ4Exception("Malformed input at " + sOff);
                }
                LZ4ByteBufferUtils.safeArraycopy(src, sOff, dest, dOff, literalLen);
                sOff += literalLen;
                break;
            }
            LZ4ByteBufferUtils.wildArraycopy(src, sOff, dest, dOff, literalLen);
            dOff = literalCopyEnd;
            int matchDec = ByteBufferUtils.readShortLE(src, sOff += literalLen);
            sOff += 2;
            int matchOff = dOff - matchDec;
            if (matchOff < destOff) {
                throw new LZ4Exception("Malformed input at " + sOff);
            }
            int matchLen = token & 0xF;
            if (matchLen == 15) {
                int len = -1;
                while (sOff < srcEnd) {
                    byte by = ByteBufferUtils.readByte(src, sOff++);
                    len = by;
                    if (by != -1) break;
                    if ((matchLen += 255) >= 0) continue;
                    throw new LZ4Exception("Too large matchLen");
                }
                matchLen += len & 0xFF;
            }
            if ((matchCopyEnd = dOff + (matchLen += 4)) < dOff) {
                throw new LZ4Exception("Too large matchLen");
            }
            if (matchDec == 0) {
                if (matchCopyEnd > destEnd) {
                    throw new LZ4Exception("Malformed input at " + sOff);
                }
                assert (matchOff == dOff);
                LZ4Utils.zero(dest, dOff, matchCopyEnd);
            } else if (LZ4Utils.notEnoughSpace(destEnd - matchCopyEnd, 8)) {
                if (matchCopyEnd > destEnd) {
                    throw new LZ4Exception("Malformed input at " + sOff);
                }
                LZ4ByteBufferUtils.safeIncrementalCopy(dest, matchOff, dOff, matchLen);
            } else {
                LZ4ByteBufferUtils.wildIncrementalCopy(dest, matchOff, dOff, matchCopyEnd);
            }
            dOff = matchCopyEnd;
        }
        dOff = literalCopyEnd;
        return dOff - destOff;
    }
}

