/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.client.jdbc42.internal.nimbusjose.jwk.source;

import com.databricks.client.jdbc42.internal.nimbusjose.KeySourceException;
import com.databricks.client.jdbc42.internal.nimbusjose.jwk.JWK;
import com.databricks.client.jdbc42.internal.nimbusjose.jwk.JWKSelector;
import com.databricks.client.jdbc42.internal.nimbusjose.jwk.JWKSet;
import com.databricks.client.jdbc42.internal.nimbusjose.jwk.source.JWKSetCacheRefreshEvaluator;
import com.databricks.client.jdbc42.internal.nimbusjose.jwk.source.JWKSetSource;
import com.databricks.client.jdbc42.internal.nimbusjose.jwk.source.JWKSource;
import com.databricks.client.jdbc42.internal.nimbusjose.proc.SecurityContext;
import com.databricks.client.jdbc42.internal.nimbusjose.shaded.jcip.ThreadSafe;
import java.io.Closeable;
import java.io.IOException;
import java.util.List;
import java.util.Objects;

@ThreadSafe
public class JWKSetBasedJWKSource<C extends SecurityContext>
implements JWKSource<C>,
Closeable {
    private final JWKSetSource<C> source;

    public JWKSetBasedJWKSource(JWKSetSource<C> source) {
        Objects.requireNonNull(source);
        this.source = source;
    }

    @Override
    public List<JWK> get(JWKSelector jwkSelector, C context) throws KeySourceException {
        long currentTime = System.currentTimeMillis();
        JWKSet jwkSet = this.source.getJWKSet(JWKSetCacheRefreshEvaluator.noRefresh(), currentTime, context);
        List<JWK> select = jwkSelector.select(jwkSet);
        if (select.isEmpty()) {
            JWKSet recentJwkSet = this.source.getJWKSet(JWKSetCacheRefreshEvaluator.referenceComparison(jwkSet), currentTime, context);
            select = jwkSelector.select(recentJwkSet);
        }
        return select;
    }

    public JWKSetSource<C> getJWKSetSource() {
        return this.source;
    }

    @Override
    public void close() throws IOException {
        this.source.close();
    }
}

