/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.client.jdbc42.internal.nimbusjose.util;

import com.databricks.client.jdbc42.internal.nimbusjose.shaded.gson.Gson;
import com.databricks.client.jdbc42.internal.nimbusjose.shaded.gson.GsonBuilder;
import com.databricks.client.jdbc42.internal.nimbusjose.shaded.gson.Strictness;
import com.databricks.client.jdbc42.internal.nimbusjose.shaded.gson.ToNumberPolicy;
import com.databricks.client.jdbc42.internal.nimbusjose.shaded.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class JSONArrayUtils {
    private static final Gson GSON = new GsonBuilder().setStrictness(Strictness.STRICT).serializeNulls().setObjectToNumberStrategy(ToNumberPolicy.LONG_OR_DOUBLE).disableHtmlEscaping().create();

    public static List<Object> parse(String s) throws ParseException {
        if (s == null) {
            throw new ParseException("The JSON array string must not be null", 0);
        }
        if (s.trim().isEmpty()) {
            throw new ParseException("Invalid JSON array", 0);
        }
        Type listType = TypeToken.getParameterized(List.class, new Type[]{Object.class}).getType();
        try {
            return (List)GSON.fromJson(s, listType);
        }
        catch (Exception e) {
            throw new ParseException("Invalid JSON array", 0);
        }
        catch (StackOverflowError e) {
            throw new ParseException("Excessive JSON object and / or array nesting", 0);
        }
    }

    public static String toJSONString(List<?> jsonArray) {
        return GSON.toJson(Objects.requireNonNull(jsonArray));
    }

    public static List<Object> newJSONArray() {
        return new ArrayList<Object>();
    }

    private JSONArrayUtils() {
    }
}

