/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.client.sqlengine.aeprocessor.aebuilder.relation;

import com.databricks.client.sqlengine.aeprocessor.AEQTableName;
import com.databricks.client.sqlengine.aeprocessor.AEUtils;
import com.databricks.client.sqlengine.aeprocessor.aebuilder.AEBuilderBase;
import com.databricks.client.sqlengine.aeprocessor.aebuilder.AEQueryScope;
import com.databricks.client.sqlengine.aeprocessor.aetree.relation.AECommonTableExpr;
import com.databricks.client.sqlengine.aeprocessor.aetree.relation.AENamedRelationalExpr;
import com.databricks.client.sqlengine.aeprocessor.aetree.relation.AETable;
import com.databricks.client.sqlengine.aeprocessor.aetree.relation.AEWithClause;
import com.databricks.client.sqlengine.dsiext.dataengine.DSIExtJResultSet;
import com.databricks.client.sqlengine.dsiext.dataengine.OpenTableType;
import com.databricks.client.sqlengine.dsiext.dataengine.SqlDataEngine;
import com.databricks.client.sqlengine.exceptions.SQLEngineException;
import com.databricks.client.sqlengine.exceptions.SQLEngineExceptionFactory;
import com.databricks.client.sqlengine.parser.parsetree.IPTNode;
import com.databricks.client.sqlengine.parser.parsetree.PTEmptyNode;
import com.databricks.client.sqlengine.parser.parsetree.PTIdentifierNode;
import com.databricks.client.sqlengine.parser.parsetree.PTNonterminalNode;
import com.databricks.client.sqlengine.parser.type.PTNonterminalType;
import com.databricks.client.sqlengine.parser.type.PTPositionalType;
import com.databricks.client.sqlengine.utilities.SQLEngineMessageKey;
import com.databricks.client.support.exceptions.DiagState;
import com.databricks.client.support.exceptions.ErrorException;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Objects;
import java.util.Set;

public final class AETableNameBuilder
extends AEBuilderBase<AENamedRelationalExpr> {
    private final Set<PTPositionalType> s_onlyTableIdent = Collections.unmodifiableSet(EnumSet.of(PTPositionalType.TABLE_IDENT));
    private final SqlDataEngine m_dataEngine;

    public AETableNameBuilder(AEQueryScope aEQueryScope) {
        super(aEQueryScope);
        this.m_dataEngine = Objects.requireNonNull(aEQueryScope.getDataEngine());
    }

    @Override
    public AENamedRelationalExpr visit(PTNonterminalNode pTNonterminalNode) throws ErrorException {
        Object object;
        AEQueryScope aEQueryScope = this.getQueryScope();
        String string = this.getAsUnqualifiedTableReference(pTNonterminalNode);
        if (string != null && (object = aEQueryScope.resolveCommonTableExpression(string, this.isCteRefCaseSensitive(pTNonterminalNode))) != null) {
            assert (aEQueryScope.getOpenTableType() != OpenTableType.READ_WRITE);
            return new AECommonTableExpr((AEWithClause.CTERef)object);
        }
        object = AEQTableName.fromPTNode(pTNonterminalNode);
        boolean bl = this.m_dataEngine.getProperty(15).getString().equalsIgnoreCase("Y");
        AEQTableName aEQTableName = AEUtils.adjustCatalogAndSchema((AEQTableName)object, this.m_dataEngine.getContext(), bl);
        DSIExtJResultSet dSIExtJResultSet = this.m_dataEngine.openTable(aEQTableName.getCatalogName(), aEQTableName.getSchemaName(), aEQTableName.getTableName(), aEQueryScope.getOpenTableType());
        if (dSIExtJResultSet == null) {
            throw new SQLEngineException(DiagState.DIAG_BASE_TABLE_OR_VIEW_MISSING, SQLEngineMessageKey.TABLE_NOT_FOUND.name(), new String[]{((AEQTableName)object).toString()});
        }
        try {
            dSIExtJResultSet.registerWarningListener(this.m_dataEngine.getContext().getWarningListener());
            return new AETable(dSIExtJResultSet);
        }
        catch (Exception exception) {
            dSIExtJResultSet.close();
            throw exception;
        }
    }

    private boolean isCteRefCaseSensitive(PTNonterminalNode pTNonterminalNode) {
        return this.getQueryScope().getDataEngine().getContext().isSqlCaseSensitive();
    }

    private String getAsUnqualifiedTableReference(PTNonterminalNode pTNonterminalNode) throws ErrorException {
        if (PTNonterminalType.TABLE_NAME != pTNonterminalNode.getNonterminalType()) {
            throw SQLEngineExceptionFactory.invalidParseTreeException();
        }
        IPTNode iPTNode = pTNonterminalNode.getChild(PTPositionalType.CATALOG_IDENT);
        IPTNode iPTNode2 = pTNonterminalNode.getChild(PTPositionalType.SCHEMA_IDENT);
        IPTNode iPTNode3 = pTNonterminalNode.getChild(PTPositionalType.TABLE_IDENT);
        if (!(iPTNode3 instanceof PTIdentifierNode)) {
            throw SQLEngineExceptionFactory.invalidParseTreeException();
        }
        if (iPTNode instanceof PTEmptyNode && iPTNode2 instanceof PTEmptyNode) {
            return Objects.requireNonNull(((PTIdentifierNode)iPTNode3).getIdentifier());
        }
        return null;
    }
}

