/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.client.sqlengine.dsiext.dataengine.metadata;

import com.databricks.client.dsi.core.impl.DSIDriver;
import com.databricks.client.dsi.dataengine.filters.IFilter;
import com.databricks.client.dsi.dataengine.utilities.DSITypeUtilities;
import com.databricks.client.dsi.dataengine.utilities.DataWrapper;
import com.databricks.client.dsi.dataengine.utilities.MetadataSourceColumnTag;
import com.databricks.client.dsi.utilities.DSIMessageKey;
import com.databricks.client.sqlengine.dsiext.dataengine.IMetadataHelper;
import com.databricks.client.sqlengine.dsiext.dataengine.Identifier;
import com.databricks.client.sqlengine.dsiext.dataengine.SqlDataEngine;
import com.databricks.client.sqlengine.dsiext.dataengine.StoredProcedure;
import com.databricks.client.sqlengine.dsiext.dataengine.metadata.DSIExtPartiallyFilteredMetadataSource;
import com.databricks.client.support.ILogger;
import com.databricks.client.support.LogUtilities;
import com.databricks.client.support.exceptions.ErrorException;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class DSIExtProceduresMetadataSource
extends DSIExtPartiallyFilteredMetadataSource {
    private ILogger m_logger;
    private Identifier m_curRow = null;
    private StoredProcedure m_curProcedure = null;
    private SqlDataEngine m_dataEngine;

    @Deprecated
    public DSIExtProceduresMetadataSource(ILogger iLogger, Map<MetadataSourceColumnTag, String> map, IMetadataHelper iMetadataHelper, SqlDataEngine sqlDataEngine) {
        super(map, iMetadataHelper, MetadataSourceColumnTag.PROCEDURE_NAME, sqlDataEngine.getIsODBC2());
        this.init(iLogger, sqlDataEngine);
    }

    public DSIExtProceduresMetadataSource(ILogger iLogger, IMetadataHelper iMetadataHelper, SqlDataEngine sqlDataEngine, List<IFilter> list) {
        super(iMetadataHelper, MetadataSourceColumnTag.PROCEDURE_NAME, sqlDataEngine.getIsODBC2(), list);
        this.init(iLogger, sqlDataEngine);
    }

    @Override
    public void close() {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
    }

    @Override
    public void closeCursor() throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        this.m_curProcedure = null;
        this.m_curRow = null;
    }

    @Override
    public boolean getMetadata(MetadataSourceColumnTag metadataSourceColumnTag, long l, long l2, DataWrapper dataWrapper) throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[]{metadataSourceColumnTag, l, l2});
        switch (metadataSourceColumnTag) {
            case CATALOG_NAME: {
                return DSITypeUtilities.outputVarCharStringData(this.m_curRow.getCatalog(), dataWrapper, l, l2);
            }
            case SCHEMA_NAME: {
                return DSITypeUtilities.outputVarCharStringData(this.m_curRow.getSchema(), dataWrapper, l, l2);
            }
            case PROCEDURE_NAME: {
                return DSITypeUtilities.outputVarCharStringData(this.m_curRow.getName(), dataWrapper, l, l2);
            }
            case NUM_INPUT_PARAMS: {
                dataWrapper.setNull(4);
                return false;
            }
            case NUM_OUTPUT_PARAMS: {
                dataWrapper.setNull(4);
                return false;
            }
            case NUM_RESULT_SETS: {
                dataWrapper.setNull(4);
                return false;
            }
            case REMARKS: {
                dataWrapper.setNull(12);
                return false;
            }
            case PROCEDURE_TYPE: {
                if (this.m_curProcedure.hasReturnValue()) {
                    dataWrapper.setSmallInt(2);
                } else {
                    dataWrapper.setSmallInt(1);
                }
                return false;
            }
            case SPECIFIC_NAME: {
                return DSITypeUtilities.outputVarCharStringData("", dataWrapper, l, l2);
            }
        }
        throw DSIDriver.s_DSIMessages.createGeneralException(DSIMessageKey.INVALID_METADATA_COLUMN_TAG.name(), metadataSourceColumnTag.name());
    }

    @Override
    public boolean hasMoreRows() throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        return this.hasNextProcedureOrTable();
    }

    @Override
    public boolean moveToNextRow() {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        this.m_curRow = this.getNextProcedureOrTable();
        if (this.m_curRow == null) {
            return false;
        }
        try {
            this.m_curProcedure = Objects.requireNonNull(this.m_dataEngine.openProcedure(this.m_curRow.getCatalog(), this.m_curRow.getSchema(), this.m_curRow.getName()), () -> String.format("%s.openProcedure(\"%s\", \"%s\", \"%s\") returned NULL, even though that Catalog/Schema/ProcedureName was returned from the metadata helper!", this.m_dataEngine.getClass().getName(), this.m_curRow.getCatalog(), this.m_curRow.getSchema(), this.m_curRow.getName()));
        }
        catch (ErrorException errorException) {
            throw new RuntimeException(errorException);
        }
        return true;
    }

    private void init(ILogger iLogger, SqlDataEngine sqlDataEngine) {
        this.m_logger = iLogger;
        this.m_dataEngine = sqlDataEngine;
    }
}

