/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.client.sqlengine.executor.etree.value.scalar;

import com.databricks.client.dsi.dataengine.interfaces.IColumn;
import com.databricks.client.sqlengine.executor.etree.ETDataRequest;
import com.databricks.client.sqlengine.executor.etree.value.ETValueExpr;
import com.databricks.client.sqlengine.executor.etree.value.scalar.ETScalarFn;
import com.databricks.client.support.conv.ConverterConstants;
import com.databricks.client.support.exceptions.ErrorException;
import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.util.List;

public class ETCurTimestampFn
extends ETScalarFn {
    private static final short NANOSECOND_PRECISION = 9;
    private LocalDateTime m_value;
    private final short m_maxPrecision;
    static final /* synthetic */ boolean $assertionsDisabled;

    public ETCurTimestampFn(IColumn iColumn, List<ETValueExpr> list, List<IColumn> list2, short s) throws ErrorException {
        super(iColumn, list, list2);
        if (iColumn.getTypeMetadata().getType() != 93) {
            throw new IllegalArgumentException("resultMeta must be of TIMESTAMP type!");
        }
        if (s < 0) {
            throw new IllegalArgumentException("maxPrecision cannot be negative!");
        }
        this.m_maxPrecision = (short)Math.min(s, 9);
    }

    @Override
    public void open() throws ErrorException {
        super.open();
        this.m_value = LocalDateTime.now();
    }

    @Override
    public void close(boolean bl) {
        this.m_value = null;
        super.close(bl);
    }

    @Override
    public String getLogString() {
        return "ETCurTimestampFn";
    }

    @Override
    public boolean retrieveData(ETDataRequest eTDataRequest) throws ErrorException {
        if (!$assertionsDisabled && !this.isOpen()) {
            throw new AssertionError();
        }
        return this.returnValue(eTDataRequest, this.m_maxPrecision);
    }

    protected final short getMaxFractionalSecondsPrecision() {
        return this.m_maxPrecision;
    }

    protected final boolean returnValue(ETDataRequest eTDataRequest, short s) throws ErrorException {
        if (!$assertionsDisabled && s < 0) {
            throw new AssertionError();
        }
        eTDataRequest.getData().setTimestamp(Timestamp.valueOf(s < 9 ? this.m_value.withNano(this.truncateToPrecision(this.m_value.getNano(), s)) : this.m_value));
        return false;
    }

    private int truncateToPrecision(int n, short s) {
        if (s < 9) {
            n -= n % ConverterConstants.FRACTIONAL_MOD[s];
        }
        return n;
    }

    static {
        boolean bl = $assertionsDisabled = !ETCurTimestampFn.class.desiredAssertionStatus();
        if (!$assertionsDisabled && ConverterConstants.FRACTIONAL_MOD.length <= 9) {
            throw new AssertionError();
        }
    }
}

