/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.client.sqlengine.executor.etree.value.scalar;

import com.databricks.client.dsi.dataengine.interfaces.IColumn;
import com.databricks.client.sqlengine.executor.datawrapper.ISqlDataWrapper;
import com.databricks.client.sqlengine.executor.etree.ETDataRequest;
import com.databricks.client.sqlengine.executor.etree.value.ETValueExpr;
import com.databricks.client.sqlengine.executor.etree.value.scalar.ETScalarFn;
import com.databricks.client.support.exceptions.ErrorException;
import java.util.List;
import java.util.Random;

public final class ETRandFn
extends ETScalarFn {
    private long m_lastUsedSeed = 0L;
    private final Random m_random = new Random(this.m_lastUsedSeed);
    private double m_lastReturnedValue = this.m_random.nextDouble();

    public ETRandFn(IColumn iColumn, List<ETValueExpr> list, List<IColumn> list2) throws ErrorException {
        super(iColumn, list, list2);
        assert (1 == list.size() && 1 == list2.size());
        assert (iColumn.getTypeMetadata().getType() == 8);
    }

    @Override
    public String getLogString() {
        return "ETRandFn";
    }

    @Override
    public boolean retrieveData(ETDataRequest eTDataRequest) throws ErrorException {
        ISqlDataWrapper iSqlDataWrapper = this.getArgumentData(0);
        ISqlDataWrapper iSqlDataWrapper2 = eTDataRequest.getData();
        if (iSqlDataWrapper.isNull()) {
            iSqlDataWrapper2.setNull();
        } else {
            iSqlDataWrapper2.setDouble(this.getValueForSeed(iSqlDataWrapper.getInteger()));
        }
        return false;
    }

    private double getValueForSeed(long l) {
        if (l != this.m_lastUsedSeed) {
            this.m_random.setSeed(l);
            this.m_lastReturnedValue = this.m_random.nextDouble();
            this.m_lastUsedSeed = l;
        }
        return this.m_lastReturnedValue;
    }
}

