/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.client.sqlengine.utilities;

import com.databricks.client.dsi.core.impl.DSIDriverSingleton;
import com.databricks.client.dsi.core.interfaces.IDriver;
import com.databricks.client.dsi.core.utilities.Variant;
import com.databricks.client.dsi.dataengine.interfaces.IColumn;
import com.databricks.client.dsi.exceptions.IncorrectTypeException;
import com.databricks.client.dsi.exceptions.NumericOverflowException;
import com.databricks.client.sqlengine.dsiext.dataengine.SqlDataEngine;
import com.databricks.client.sqlengine.dsiext.dataengine.mem.MemoryManager;
import com.databricks.client.sqlengine.exceptions.SQLEngineExceptionFactory;
import com.databricks.client.sqlengine.executor.etree.ETResourceManager;
import com.databricks.client.sqlengine.executor.etree.ETTempFolderResource;
import com.databricks.client.sqlengine.executor.etree.temptable.column.ColumnSizeCalculator;
import com.databricks.client.sqlengine.utilities.SQLEngineMessageKey;
import com.databricks.client.support.ILogger;
import com.databricks.client.support.IWarningListener;
import com.databricks.client.support.Warning;
import com.databricks.client.support.WarningCode;
import com.databricks.client.support.exceptions.ErrorException;
import java.io.File;
import java.io.IOException;
import java.util.Objects;

public class ExternalAlgorithmUtil {
    private static final String PACKAGE_NAME = ExternalAlgorithmUtil.class.getPackage().getName();
    private static final String CLASS_NAME = ExternalAlgorithmUtil.class.getSimpleName();

    public static ExternalAlgorithmProperties createProperties(SqlDataEngine sqlDataEngine, ILogger iLogger, IWarningListener iWarningListener, ETResourceManager eTResourceManager) throws ErrorException {
        int n = 0;
        long l = 0L;
        long l2 = MemoryManager.getInstance().getTotalMemory();
        int n2 = 0;
        try {
            n = sqlDataEngine.getProperty(14).getInt();
            l = sqlDataEngine.getProperty(13).getLong();
            n2 = sqlDataEngine.getProperty(16).getInt();
        }
        catch (NumericOverflowException numericOverflowException) {
            throw SQLEngineExceptionFactory.invalidConfiguration(numericOverflowException);
        }
        catch (IncorrectTypeException incorrectTypeException) {
            throw SQLEngineExceptionFactory.invalidConfiguration(incorrectTypeException);
        }
        if (l2 <= l) {
            if (null != iWarningListener) {
                iWarningListener.postWarning(new Warning(WarningCode.GENERAL_WARNING, 7, SQLEngineMessageKey.INVALID_CONFIG.name()));
            }
            if (null != iLogger) {
                iLogger.logWarning(PACKAGE_NAME, CLASS_NAME, "createProperties", "Recommended block size is larger that total available memory.");
            }
            if (0L >= (l = l2 / 5L)) {
                throw SQLEngineExceptionFactory.invalidConfiguration();
            }
        }
        if ((long)n > l) {
            if (null != iWarningListener) {
                iWarningListener.postWarning(new Warning(WarningCode.GENERAL_WARNING, 7, SQLEngineMessageKey.INVALID_CONFIG.name()));
            }
            if (null != iLogger) {
                iLogger.logWarning(PACKAGE_NAME, CLASS_NAME, "createProperties", "Max in-memory data size is larger than recommended block size.");
            }
            if (0 >= (n = (int)(l - 1L))) {
                throw SQLEngineExceptionFactory.invalidConfiguration();
            }
        }
        if (n2 < 4) {
            if (null != iWarningListener) {
                iWarningListener.postWarning(new Warning(WarningCode.GENERAL_WARNING, 7, SQLEngineMessageKey.INVALID_CONFIG.name()));
            }
            if (null != iLogger) {
                iLogger.logWarning(PACKAGE_NAME, CLASS_NAME, "createProperties", "Invalid value (" + n2 + ") for maximum number of open files per node.");
            }
            n2 = 4;
        }
        return new ExternalAlgorithmProperties(n, l, n2, iLogger, eTResourceManager);
    }

    public static long calculateRowSize(Iterable<IColumn> iterable, boolean[] blArray, int n) {
        long l = 0L;
        int n2 = 0;
        for (IColumn iColumn : iterable) {
            l = (long)((double)l + Math.ceil(ColumnSizeCalculator.getColumnSizePerRow(iColumn, blArray[n2], n)));
            l = (long)((double)l + Math.ceil(ColumnSizeCalculator.getOverHeadPerRow(iColumn, blArray[n2], n)));
            ++n2;
        }
        return l;
    }

    public static File createTempFile(File file, ILogger iLogger) throws ErrorException {
        if (null == file || !file.isDirectory()) {
            throw new IllegalArgumentException("The File passed in is not a direcotry.");
        }
        String string = "Unknown";
        try {
            File file2 = File.createTempFile("sql_", null, file);
            string = file2.getAbsolutePath();
            if (!file2.canRead() || !file2.canWrite()) {
                if (null != iLogger) {
                    iLogger.logError(PACKAGE_NAME, CLASS_NAME, "RowFile", "Could not create temporary file.");
                }
                throw SQLEngineExceptionFactory.failedToCreateFile(string);
            }
            return file2;
        }
        catch (IOException iOException) {
            if (null != iLogger) {
                iLogger.logError(PACKAGE_NAME, CLASS_NAME, "RowFile", "Could not create temporary file.");
            }
            throw SQLEngineExceptionFactory.failedToCreateFile(string, iOException.getLocalizedMessage());
        }
    }

    private static class TmpFileDirHolder {
        private static final File TEMP_DIR = TmpFileDirHolder.getTempFileDir();

        private TmpFileDirHolder() {
        }

        private static File getTempFileDir() {
            String string = null;
            IDriver iDriver = DSIDriverSingleton.getInstance();
            if (null != iDriver) {
                Variant variant;
                try {
                    variant = iDriver.getProperty(1006);
                }
                catch (Exception exception) {
                    throw new RuntimeException(exception);
                }
                if (null != variant) {
                    string = variant.getString();
                }
            }
            if (string == null || string.equals("")) {
                string = Objects.requireNonNull(System.getProperty("java.io.tmpdir"), "System.getProperty(\"java.io.tmpdir\") returned null");
            }
            return new File(string);
        }
    }

    public static class ExternalAlgorithmProperties {
        private final int m_cellMemoryLimit;
        private final long m_blockSize;
        private final int m_maxOpenFiles;
        private final ILogger m_logger;
        private File m_storageDir = null;
        private final ETResourceManager m_rManager;

        private ExternalAlgorithmProperties(int n, long l, int n2, ILogger iLogger, ETResourceManager eTResourceManager) {
            assert (n > 0);
            assert (l > 0L);
            this.m_cellMemoryLimit = n;
            this.m_blockSize = l;
            this.m_maxOpenFiles = n2;
            this.m_logger = iLogger;
            this.m_rManager = eTResourceManager;
        }

        public int getCellMemoryLimit() {
            return this.m_cellMemoryLimit;
        }

        public long getBlockSize() {
            return this.m_blockSize;
        }

        public File getStorageDir() throws ErrorException {
            if (null == this.m_storageDir) {
                File file;
                try {
                    file = TmpFileDirHolder.TEMP_DIR;
                }
                catch (ExceptionInInitializerError exceptionInInitializerError) {
                    throw exceptionInInitializerError.getCause() instanceof RuntimeException ? (RuntimeException)exceptionInInitializerError.getCause() : new RuntimeException(exceptionInInitializerError.getCause());
                }
                this.m_rManager.registerResource(new ETTempFolderResource(file, this.m_logger));
                this.m_storageDir = file;
            }
            return this.m_storageDir;
        }

        public ILogger getLogger() {
            return this.m_logger;
        }

        public int getMaxNumOpenFiles() {
            return this.m_maxOpenFiles;
        }
    }
}

