/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.futures;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.Set;
import java.util.Stack;
import java.util.WeakHashMap;
import org.apache.log4j.Logger;

public class FutureAborter {
    static ThreadLocal<FutureAborter> localFA = new InheritableThreadLocal<FutureAborter>(){

        @Override
        public FutureAborter childValue(FutureAborter parentValue) {
            return new FutureAborter(parentValue, true);
        }
    };
    private final boolean createdByChildValue;
    private final String threadId;
    private Set<FutureAborter> subAborters = Collections.newSetFromMap(new WeakHashMap());
    public Stack<Runnable> hookStack = new Stack();
    private boolean aborted;
    private static Logger logger = Logger.getLogger((String)"dku.future.aborter");

    private FutureAborter(FutureAborter parentValue, boolean createdByChildValue) {
        this.createdByChildValue = createdByChildValue;
        this.threadId = Thread.currentThread().getName() + "-" + Thread.currentThread().getId();
        if (parentValue != null) {
            parentValue.addSubAborter(this);
        }
    }

    public String toString() {
        return "FutureAborter@" + this.hashCode() + ",createdInThread=" + this.threadId + ",forChildThread=" + this.createdByChildValue;
    }

    private synchronized void addSubAborter(FutureAborter aborter) {
        this.subAborters.add(aborter);
    }

    public static FutureAborter getFutureAborter() {
        return localFA.get();
    }

    public static FutureAborter init() {
        if (localFA.get() != null) {
            return localFA.get();
        }
        FutureAborter fa = new FutureAborter(null, false);
        localFA.set(fa);
        return fa;
    }

    public static void deinit() {
        localFA.remove();
    }

    public static void pushHook(Runnable hook) {
        if (localFA.get() != null) {
            localFA.get().push(hook);
        } else {
            logger.trace((Object)"pushHook: The FutureAborter has not been initialized");
        }
    }

    public static AutoCloseableAbortHook pushAutoCloseableHook(Runnable hook) {
        if (localFA.get() != null) {
            localFA.get().push(hook);
        } else {
            logger.trace((Object)"pushAutoCloseableHook: The FutureAborter has not been initialized");
        }
        return new AutoCloseableAbortHook();
    }

    public static void popHook() {
        if (localFA.get() != null) {
            localFA.get().pop();
        } else {
            logger.trace((Object)"popHook: The FutureAborter has not been initialized");
        }
    }

    public synchronized void push(Runnable hook) {
        this.hookStack.push(hook);
    }

    public synchronized void pop() {
        if (!this.hookStack.isEmpty()) {
            this.hookStack.pop();
        } else {
            logger.warn((Object)"No hook to pop. May have been popped already by an abort.");
        }
    }

    public static boolean isAborted() {
        if (localFA.get() != null) {
            logger.info((Object)("Check aborted on " + String.valueOf(localFA.get())));
            return FutureAborter.localFA.get().aborted;
        }
        logger.trace((Object)"isAborted: The FutureAborter has not been initialized");
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void abort() {
        ArrayList subAborters;
        logger.info((Object)("Executing abort on FutureAborter " + String.valueOf(this)));
        ArrayList hooks = Lists.newArrayList();
        Iterator iterator = this;
        synchronized (iterator) {
            this.aborted = true;
            subAborters = Lists.newArrayList(this.subAborters);
            while (!this.hookStack.isEmpty()) {
                hooks.add(this.hookStack.pop());
            }
        }
        for (Runnable hook : hooks) {
            try {
                logger.info((Object)("Executing abort hook: " + String.valueOf(hook)));
                hook.run();
            }
            catch (Exception ex) {
                logger.error((Object)"Abort hook failed to run.", (Throwable)ex);
            }
        }
        for (FutureAborter aborter : subAborters) {
            if (aborter == null) continue;
            aborter.abort();
        }
    }

    public static class AutoCloseableAbortHook
    implements AutoCloseable {
        @Override
        public void close() {
            FutureAborter.popHook();
        }
    }
}

