/*
 * Decompiled with CFR 0.152.
 */
package com.maxmind.maxminddb;

import com.maxmind.maxminddb.MaxMindDbReader;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;

final class ThreadBuffer
extends ThreadLocal<ByteBuffer>
implements Closeable {
    private final ByteBuffer buffer;
    private final RandomAccessFile raf;
    private final FileChannel fc;

    ThreadBuffer(File database, MaxMindDbReader.FileMode mode) throws IOException {
        this.raf = new RandomAccessFile(database, "r");
        this.fc = this.raf.getChannel();
        if (mode == MaxMindDbReader.FileMode.MEMORY) {
            this.buffer = ByteBuffer.wrap(new byte[(int)this.fc.size()]);
            this.fc.read(this.buffer);
        } else {
            this.buffer = this.fc.map(FileChannel.MapMode.READ_ONLY, 0L, this.fc.size());
        }
    }

    ThreadBuffer(ByteBuffer buffer) {
        this.buffer = buffer;
        this.raf = null;
        this.fc = null;
    }

    @Override
    protected synchronized ByteBuffer initialValue() {
        return this.buffer.duplicate();
    }

    @Override
    public void close() throws IOException {
        if (this.fc != null) {
            this.fc.close();
        }
        if (this.raf != null) {
            this.raf.close();
        }
    }
}

