/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.input.formats;

import com.dataiku.dip.datalayer.Column;
import com.dataiku.dip.datalayer.ColumnFactory;
import com.dataiku.dip.datalayer.ProcessorOutput;
import com.dataiku.dip.datalayer.Row;
import com.dataiku.dip.datalayer.RowFactory;
import com.dataiku.dip.input.formats.AbstractBasicFormatExtractor;
import com.dataiku.dip.input.formats.ExtractionLimit;
import com.dataiku.dip.input.stream.EnrichedInputStream;
import com.dataiku.dip.input.stream.StreamsInputSplit;
import com.google.common.io.CountingInputStream;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;

public class BasicLineFormatExtractor
extends AbstractBasicFormatExtractor {
    private String charset;

    public BasicLineFormatExtractor(String charset) {
        this.charset = charset;
    }

    @Override
    public boolean run(StreamsInputSplit in, ProcessorOutput out, ProcessorOutput err, ColumnFactory cf, RowFactory rf, ExtractionLimit limit) throws Exception {
        EnrichedInputStream stream;
        Column c = cf.column("line");
        while ((stream = in.nextStream()) != null) {
            InputStream is = stream.decompressedStream();
            try (CountingInputStream cis = new CountingInputStream(is);
                 BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)cis, this.charset));){
                String str;
                while ((str = br.readLine()) != null) {
                    Row r = rf.row();
                    r.put(c, str);
                    out.emitRow(r);
                }
            }
        }
        return true;
    }
}

