/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.security;

import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.j2ts.annotations.UIData;
import com.dataiku.j2ts.annotations.UIModel;
import java.util.Locale;
import java.util.Set;
import org.apache.commons.lang.StringUtils;

@UIModel
public class MimeTypesSecurity {
    static Set<String> SAFE_IMAGE_TYPES = Set.of("image/bmp", "image/gif", "image/jpeg", "image/png", "image/tiff", "image/x-icon", "image/webp");
    @UIData
    public static Set<String> SAFE_IMAGE_EXTENSIONS = Set.of(".bmp", ".gif", ".jpeg", ".png", ".tiff", ".ico", ".webp");

    public static void failIfNotSafeImageType(String contentType) throws DKUSecurityException {
        if (!MimeTypesSecurity.isSafeImageType(contentType)) {
            throw new DKUSecurityException("Not a valid image type");
        }
    }

    public static void failIfNotSafeImageOrPdfType(String contentType) throws DKUSecurityException {
        if (!MimeTypesSecurity.isSafeImageType(contentType) && !MimeTypesSecurity.isSafePdfType(contentType)) {
            throw new DKUSecurityException("Not a valid image or PDF type");
        }
    }

    private static boolean isSafePdfType(String contentType) {
        if (StringUtils.isBlank((String)contentType)) {
            return false;
        }
        return "application/pdf".equals(contentType = contentType.toLowerCase(Locale.ENGLISH)) || "application/x-pdf".equals(contentType);
    }

    private static boolean isSafeImageType(String contentType) {
        if (StringUtils.isBlank((String)contentType)) {
            return false;
        }
        contentType = contentType.toLowerCase(Locale.ENGLISH).trim();
        return SAFE_IMAGE_TYPES.contains(contentType);
    }

    public static boolean isSafeForInlineContentDisposition(String contentType) {
        if (StringUtils.isBlank((String)contentType)) {
            return false;
        }
        return "text/plain".equals(contentType = contentType.toLowerCase(Locale.ENGLISH)) || MimeTypesSecurity.isSafePdfType(contentType) || MimeTypesSecurity.isSafeImageType(contentType);
    }
}

