/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.services.licensing;

import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.JSON;
import com.dataiku.j2ts.annotations.UIModel;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class LimitsStatusComputer {
    public static final String NONE_PROFILE = "NONE";
    public static final String AI_ACCESS_USER_PROFILE = "AI_ACCESS_USER";
    public static final String TECHNICAL_ACCOUNT_PROFILE = "TECHNICAL_ACCOUNT";
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.licensing.enforcement");

    public Map<String, UsedProfileLimit> getLimitsStatus(Iterable<LicensedProfile> licensedProfiles, String fallbackProfile, List<String> userProfilesWithoutTrials, List<String> trialProfiles) {
        HashMap<String, UsedProfileLimit> profileLimits = new HashMap<String, UsedProfileLimit>();
        try {
            String up;
            UsedProfileLimit upl;
            for (LicensedProfile lp : licensedProfiles) {
                upl = new UsedProfileLimit();
                upl.licensed = lp;
                upl.profile = lp.profile;
                profileLimits.put(lp.profile, upl);
            }
            logger.trace(() -> "getLimitsStatus. Init: " + JSON.log((Object)profileLimits));
            for (String userProfile : userProfilesWithoutTrials) {
                up = userProfile == null ? fallbackProfile : userProfile;
                UsedProfileLimit upl2 = (UsedProfileLimit)profileLimits.get(up);
                if (upl2 == null && (upl2 = (UsedProfileLimit)profileLimits.get(up = fallbackProfile)) == null) {
                    throw new LicenseLimitException("Unknown profile " + up);
                }
                ++upl2.directCount;
                ++upl2.countWithDemotedTo;
            }
            logger.trace(() -> "getLimitsStatus. After direct counts: " + JSON.log((Object)profileLimits));
            for (LicensedProfile lp : licensedProfiles) {
                upl = (UsedProfileLimit)profileLimits.get(lp.profile);
                assert (upl != null);
                if (lp.licensedLimit <= -1 || upl.directCount <= lp.licensedLimit) continue;
                logger.trace(() -> "Have too many " + lp.profile + " licensed=" + lp.licensedLimit + " counted=" + upl.directCount);
                for (int missing = 0; missing < upl.directCount - lp.licensedLimit; ++missing) {
                    boolean couldDemote = false;
                    for (String demoteFrom : lp.demotesFrom) {
                        logger.trace(() -> "Trying to demote a " + demoteFrom + " to fulfill a " + lp.profile + " seat");
                        UsedProfileLimit demoteFromLimit = (UsedProfileLimit)profileLimits.get(demoteFrom);
                        assert (demoteFromLimit != null);
                        if (demoteFromLimit.countWithDemotedTo >= demoteFromLimit.licensed.licensedLimit) continue;
                        logger.trace(() -> "Demoting a " + demoteFrom + " to make up a missing " + lp.profile);
                        demoteFromLimit.demotedTo.add(lp.profile);
                        ++demoteFromLimit.demotedToOther;
                        ++demoteFromLimit.countWithDemotedTo;
                        ++upl.limitWithDemoted;
                        ++upl.demotedFromOther;
                        upl.demotedFrom.add(demoteFrom);
                        couldDemote = true;
                        break;
                    }
                    if (couldDemote) {
                        logger.trace(() -> "Managed to demote to a missing " + lp.profile);
                        continue;
                    }
                    logger.trace(() -> "Did not manage to demote to a missing " + lp.profile);
                    ++upl.overQuota;
                }
            }
            for (String userProfile : trialProfiles) {
                up = userProfile == null ? fallbackProfile : userProfile;
                UsedProfileLimit upl3 = (UsedProfileLimit)profileLimits.get(up);
                if (upl3 == null && (upl3 = (UsedProfileLimit)profileLimits.get(up = fallbackProfile)) == null) {
                    throw new LicenseLimitException("Unknown profile " + up);
                }
                ++upl3.trials;
            }
            logger.trace(() -> "getLimitsStatus. At end: " + JSON.log((Object)profileLimits));
        }
        catch (Exception e) {
            logger.error((Object)"Failed to compute licensing limits", (Throwable)e);
        }
        return profileLimits;
    }

    public String getHighestProfile(Collection<LicensedProfile> licensedProfiles, Collection<String> profiles, String fallbackProfile) {
        assert (!profiles.isEmpty());
        Map<String, LicensedProfile> licensedProfilesMap = licensedProfiles.stream().collect(Collectors.toMap(lp -> lp.profile, lp -> lp));
        HashSet uniqueProfiles = Sets.newHashSet(profiles);
        if (uniqueProfiles.size() == 1) {
            return (String)uniqueProfiles.iterator().next();
        }
        for (String profile : uniqueProfiles) {
            if (AI_ACCESS_USER_PROFILE.equals(profile) || TECHNICAL_ACCOUNT_PROFILE.equals(profile)) continue;
            if (!licensedProfilesMap.containsKey(profile)) {
                logger.infoV("User profile %s not found in licensed profiles, falling back to %s", new Object[]{profile, fallbackProfile});
                profile = fallbackProfile;
            }
            List<String> demotesFrom = licensedProfilesMap.get((Object)profile).demotesFrom;
            Sets.SetView demotesFromAmongThePossibleOnes = Sets.intersection((Set)Sets.newHashSet(demotesFrom), (Set)uniqueProfiles);
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("Profile " + profile + " demotes from " + JSON.log((Object)demotesFromAmongThePossibleOnes) + " among " + JSON.log((Object)uniqueProfiles)));
            }
            if (!demotesFromAmongThePossibleOnes.isEmpty()) continue;
            logger.trace(() -> "--> It's the highest");
            return profile;
        }
        throw new Error("failed to find highest profile among " + JSON.log((Object)uniqueProfiles));
    }

    @UIModel
    public static class LicensedProfile {
        public String profile;
        public List<String> demotesFrom = new ArrayList<String>();
        public int licensedLimit;
        public boolean mayAdmin;
        public boolean mayRegularCode;
        public boolean maySQL;
        public boolean mayGitInProjectLibraries;
        public boolean mayWebapps;
        public boolean mayCodeStudios;
        public boolean mayWritePlugins;
        public boolean mayVisualML;
        public boolean mayAdvancedVisualML;
        public boolean mayEDA;
        public boolean mayLLMMeshPoweredRecipes;
        public boolean mayBasicLLMMesh;
        public boolean mayFullLLMMesh;
        public boolean mayReviewAgent;
        public boolean mayReadProjectContent;
        public boolean mayWriteProjectContent;
        public boolean mayWriteDashboards;
        public boolean mayWriteWiki;
        public boolean mayReadGovern;
        public boolean mayWriteGovern;
        public boolean mayCreateGovernBlueprints;
        public boolean mayReadStories;
        public boolean mayWriteStories;
        public boolean mayAccessAI;

        LicensedProfile() {
        }

        LicensedProfile(String profile) {
            this.profile = profile;
            this.mayAccessAI = true;
        }

        public LicensedProfile withLimit(int limit) {
            this.licensedLimit = limit;
            return this;
        }

        public LicensedProfile withNoAdminability() {
            this.mayAdmin = false;
            return this;
        }

        public LicensedProfile withAdminability() {
            this.mayAdmin = true;
            return this;
        }

        public LicensedProfile withoutAnyCode() {
            this.mayRegularCode = false;
            this.maySQL = false;
            return this;
        }

        public LicensedProfile withSQLCodeOnly() {
            this.mayRegularCode = false;
            this.maySQL = true;
            return this;
        }

        public LicensedProfile withAllCode() {
            this.mayRegularCode = true;
            this.maySQL = true;
            return this;
        }

        public LicensedProfile withNoAdvancedCoding() {
            this.mayGitInProjectLibraries = false;
            this.mayWebapps = false;
            this.mayCodeStudios = false;
            this.mayWritePlugins = false;
            return this;
        }

        public LicensedProfile withFullAdvancedCoding() {
            this.mayGitInProjectLibraries = true;
            this.mayWebapps = true;
            this.mayCodeStudios = true;
            this.mayWritePlugins = true;
            return this;
        }

        public LicensedProfile withNoVisualML() {
            this.mayVisualML = false;
            this.mayAdvancedVisualML = false;
            this.mayEDA = false;
            return this;
        }

        public LicensedProfile withNoVisualMLExceptEDA() {
            this.mayVisualML = false;
            this.mayAdvancedVisualML = false;
            this.mayEDA = true;
            return this;
        }

        public LicensedProfile withBasicVisualML() {
            this.mayVisualML = true;
            this.mayAdvancedVisualML = false;
            this.mayEDA = true;
            return this;
        }

        public LicensedProfile withFullVisualML() {
            this.mayVisualML = true;
            this.mayAdvancedVisualML = true;
            this.mayEDA = true;
            return this;
        }

        public LicensedProfile withNoLLMMesh() {
            this.mayLLMMeshPoweredRecipes = false;
            this.mayBasicLLMMesh = false;
            this.mayFullLLMMesh = false;
            this.mayReviewAgent = false;
            return this;
        }

        public LicensedProfile withNoLLMMeshExceptAgentReview() {
            this.mayLLMMeshPoweredRecipes = false;
            this.mayBasicLLMMesh = false;
            this.mayFullLLMMesh = false;
            this.mayReviewAgent = true;
            return this;
        }

        public LicensedProfile withOnlyLLMMeshPoweredRecipesAndAgentReview() {
            this.mayLLMMeshPoweredRecipes = true;
            this.mayReviewAgent = true;
            this.mayBasicLLMMesh = false;
            this.mayFullLLMMesh = false;
            return this;
        }

        public LicensedProfile withBasicLLMMesh() {
            this.mayLLMMeshPoweredRecipes = true;
            this.mayReviewAgent = true;
            this.mayBasicLLMMesh = true;
            this.mayFullLLMMesh = false;
            return this;
        }

        public LicensedProfile withFullLLMMesh() {
            this.mayLLMMeshPoweredRecipes = true;
            this.mayReviewAgent = true;
            this.mayBasicLLMMesh = true;
            this.mayFullLLMMesh = true;
            return this;
        }

        public LicensedProfile withNoProjectAccess() {
            this.mayReadProjectContent = false;
            this.mayWriteProjectContent = false;
            this.mayWriteDashboards = false;
            this.mayWriteWiki = false;
            return this;
        }

        public LicensedProfile withProjectReadAccessOnly() {
            this.mayReadProjectContent = true;
            this.mayWriteProjectContent = false;
            this.mayWriteDashboards = false;
            this.mayWriteWiki = false;
            return this;
        }

        public LicensedProfile withProjectReadAccessAndDashboardWriteAndWikiWrite() {
            this.mayReadProjectContent = true;
            this.mayWriteProjectContent = false;
            this.mayWriteDashboards = true;
            this.mayWriteWiki = true;
            return this;
        }

        public LicensedProfile withFullProjectAccess() {
            this.mayReadProjectContent = true;
            this.mayWriteProjectContent = true;
            this.mayWriteDashboards = true;
            this.mayWriteWiki = true;
            return this;
        }

        public LicensedProfile withNoGovernAccess() {
            this.mayReadGovern = false;
            this.mayWriteGovern = false;
            this.mayCreateGovernBlueprints = false;
            return this;
        }

        public LicensedProfile withReadOnlyGovernAccess() {
            this.mayReadGovern = true;
            this.mayWriteGovern = false;
            this.mayCreateGovernBlueprints = false;
            return this;
        }

        public LicensedProfile withReadWriteGovernAccess() {
            this.mayReadGovern = true;
            this.mayWriteGovern = true;
            this.mayCreateGovernBlueprints = false;
            return this;
        }

        public LicensedProfile withFullGovernAccessIncludingBlueprints() {
            this.mayReadGovern = true;
            this.mayWriteGovern = true;
            this.mayCreateGovernBlueprints = true;
            return this;
        }

        public LicensedProfile withNoStoriesAccess() {
            this.mayReadStories = false;
            this.mayWriteStories = false;
            return this;
        }

        public LicensedProfile withReadWriteStoriesAccess() {
            this.mayReadStories = true;
            this.mayWriteStories = true;
            return this;
        }

        public LicensedProfile withNoAIAccess() {
            this.mayAccessAI = false;
            return this;
        }
    }

    public static class UsedProfileLimit {
        public String profile;
        LicensedProfile licensed;
        int directCount;
        int demotedToOther;
        int countWithDemotedTo;
        Set<String> demotedTo = new HashSet<String>();
        int demotedFromOther;
        Set<String> demotedFrom = new HashSet<String>();
        int limitWithDemoted;
        int trials;
        public int overQuota;
    }

    public static class LicenseLimitException
    extends Exception {
        private static final long serialVersionUID = 1L;

        public LicenseLimitException(String message) {
            super(message);
        }
    }

    @UIModel
    public static class LicenseLimitsStatus {
        public Map<String, LicensedProfile> licensedProfiles = new LinkedHashMap<String, LicensedProfile>();
        public Map<String, UsedProfileLimit> profileLimits = new HashMap<String, UsedProfileLimit>();
        public String fallbackProfile;
    }
}

