/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadeliba2a.io.a2a.spec;

import com.dataiku.dss.shadeliba2a.com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.dataiku.dss.shadeliba2a.com.fasterxml.jackson.annotation.JsonInclude;
import com.dataiku.dss.shadeliba2a.io.a2a.spec.JSONRPCMessage;
import com.dataiku.dss.shadeliba2a.io.a2a.util.Assert;
import com.dataiku.dss.shadeliba2a.io.a2a.util.Utils;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonIgnoreProperties(ignoreUnknown=true)
public abstract class JSONRPCRequest<T>
implements JSONRPCMessage {
    protected String jsonrpc;
    protected Object id;
    protected String method;
    protected T params;

    public JSONRPCRequest() {
    }

    public JSONRPCRequest(String jsonrpc, Object id, String method, T params) {
        Assert.checkNotNullParam("jsonrpc", jsonrpc);
        Assert.checkNotNullParam("method", method);
        Assert.isNullOrStringOrInteger(id);
        this.jsonrpc = Utils.defaultIfNull(jsonrpc, "2.0");
        this.id = id;
        this.method = method;
        this.params = params;
    }

    @Override
    public String getJsonrpc() {
        return this.jsonrpc;
    }

    @Override
    public Object getId() {
        return this.id;
    }

    public String getMethod() {
        return this.method;
    }

    public T getParams() {
        return this.params;
    }
}

