/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadeliba2a.io.a2a.spec;

import com.dataiku.dss.shadeliba2a.com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.dataiku.dss.shadeliba2a.com.fasterxml.jackson.annotation.JsonInclude;
import com.dataiku.dss.shadeliba2a.com.fasterxml.jackson.core.type.TypeReference;
import com.dataiku.dss.shadeliba2a.io.a2a.spec.PushNotificationAuthenticationInfo;
import com.dataiku.dss.shadeliba2a.io.a2a.util.Assert;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonIgnoreProperties(ignoreUnknown=true)
public record PushNotificationConfig(String url, String token, PushNotificationAuthenticationInfo authentication, String id) {
    public static final TypeReference<PushNotificationConfig> TYPE_REFERENCE = new TypeReference<PushNotificationConfig>(){};

    public PushNotificationConfig {
        Assert.checkNotNullParam("url", url);
    }

    public static class Builder {
        private String url;
        private String token;
        private PushNotificationAuthenticationInfo authentication;
        private String id;

        public Builder() {
        }

        public Builder(PushNotificationConfig notificationConfig) {
            this.url = notificationConfig.url;
            this.token = notificationConfig.token;
            this.authentication = notificationConfig.authentication;
            this.id = notificationConfig.id;
        }

        public Builder url(String url) {
            this.url = url;
            return this;
        }

        public Builder token(String token) {
            this.token = token;
            return this;
        }

        public Builder authenticationInfo(PushNotificationAuthenticationInfo authenticationInfo) {
            this.authentication = authenticationInfo;
            return this;
        }

        public Builder id(String id) {
            this.id = id;
            return this;
        }

        public PushNotificationConfig build() {
            return new PushNotificationConfig(this.url, this.token, this.authentication, this.id);
        }
    }
}

