/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadeliba2a.jakarta.enterprise.inject.spi;

import com.dataiku.dss.shadeliba2a.jakarta.enterprise.inject.Instance;
import com.dataiku.dss.shadeliba2a.jakarta.enterprise.inject.spi.BeanContainer;
import com.dataiku.dss.shadeliba2a.jakarta.enterprise.inject.spi.BeanManager;
import com.dataiku.dss.shadeliba2a.jakarta.enterprise.inject.spi.CDIProvider;
import com.dataiku.dss.shadeliba2a.jakarta.enterprise.inject.spi.SecurityActions;
import java.util.Collections;
import java.util.Comparator;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.TreeSet;

public abstract class CDI<T>
implements Instance<T> {
    private static final Object lock = new Object();
    private static volatile boolean providerSetManually = false;
    protected static volatile Set<CDIProvider> discoveredProviders = null;
    protected static volatile CDIProvider configuredProvider = null;

    public static CDI<Object> current() {
        return CDI.getCDIProvider().getCDI();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static CDIProvider getCDIProvider() {
        block8: {
            try {
                if (configuredProvider != null && configuredProvider.getCDI() != null) {
                    return configuredProvider;
                }
            }
            catch (IllegalStateException e) {
                if (!providerSetManually) break block8;
                throw e;
            }
        }
        configuredProvider = null;
        if (discoveredProviders == null) {
            Object object = lock;
            synchronized (object) {
                if (discoveredProviders == null) {
                    CDI.findAllProviders();
                }
            }
        }
        configuredProvider = discoveredProviders.stream().filter(CDI::checkProvider).findFirst().orElseThrow(() -> new IllegalStateException("Unable to access CDI"));
        return configuredProvider;
    }

    private static boolean checkProvider(CDIProvider c) {
        try {
            return c.getCDI() != null;
        }
        catch (IllegalStateException e) {
            return false;
        }
    }

    public static void setCDIProvider(CDIProvider provider) {
        if (provider == null) {
            throw new IllegalArgumentException("CDIProvider must not be null");
        }
        providerSetManually = true;
        configuredProvider = provider;
    }

    private static void findAllProviders() {
        TreeSet<CDIProvider> providers = new TreeSet<CDIProvider>(Comparator.comparingInt(CDIProvider::getPriority).reversed());
        ServiceLoader<CDIProvider> providerLoader = SecurityActions.loadService(CDIProvider.class, CDI.class.getClassLoader());
        if (!providerLoader.iterator().hasNext()) {
            throw new IllegalStateException("Unable to locate CDIProvider");
        }
        try {
            providerLoader.forEach(providers::add);
        }
        catch (ServiceConfigurationError e) {
            throw new IllegalStateException(e);
        }
        discoveredProviders = Collections.unmodifiableSet(providers);
    }

    public abstract BeanManager getBeanManager();

    public BeanContainer getBeanContainer() {
        return this.getBeanManager();
    }
}

