/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadeliba2a.mutiny.zero.internal;

import com.dataiku.dss.shadeliba2a.mutiny.zero.BackpressureStrategy;
import com.dataiku.dss.shadeliba2a.mutiny.zero.Tube;
import com.dataiku.dss.shadeliba2a.mutiny.zero.TubeConfiguration;
import com.dataiku.dss.shadeliba2a.mutiny.zero.internal.BufferingTube;
import com.dataiku.dss.shadeliba2a.mutiny.zero.internal.DroppingTube;
import com.dataiku.dss.shadeliba2a.mutiny.zero.internal.ErroringTube;
import com.dataiku.dss.shadeliba2a.mutiny.zero.internal.IgnoringTube;
import com.dataiku.dss.shadeliba2a.mutiny.zero.internal.LatestTube;
import com.dataiku.dss.shadeliba2a.mutiny.zero.internal.TubeBase;
import com.dataiku.dss.shadeliba2a.mutiny.zero.internal.UnbounbedBufferingTube;
import java.util.Objects;
import java.util.concurrent.Flow;
import java.util.function.Consumer;

public class TubePublisher<T>
implements Flow.Publisher<T> {
    private final BackpressureStrategy backpressureStrategy;
    private final int bufferSize;
    private final Consumer<Tube<T>> tubeConsumer;

    public TubePublisher(TubeConfiguration configuration, Consumer<Tube<T>> tubeConsumer) {
        this.backpressureStrategy = configuration.getBackpressureStrategy();
        this.bufferSize = configuration.getBufferSize();
        this.tubeConsumer = tubeConsumer;
    }

    @Override
    public void subscribe(Flow.Subscriber<? super T> subscriber) {
        Objects.requireNonNull(subscriber, "The subscriber cannot be null");
        TubeBase tube = null;
        switch (this.backpressureStrategy) {
            case BUFFER: {
                tube = new BufferingTube<T>(subscriber, this.bufferSize);
                break;
            }
            case UNBOUNDED_BUFFER: {
                tube = new UnbounbedBufferingTube<T>(subscriber);
                break;
            }
            case DROP: {
                tube = new DroppingTube<T>(subscriber);
                break;
            }
            case ERROR: {
                tube = new ErroringTube<T>(subscriber);
                break;
            }
            case IGNORE: {
                tube = new IgnoringTube<T>(subscriber);
                break;
            }
            case LATEST: {
                tube = new LatestTube<T>(subscriber, this.bufferSize);
            }
        }
        subscriber.onSubscribe(tube);
        this.tubeConsumer.accept(tube);
    }
}

