/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibsnowflake.org.apache.iceberg.snowflake;

import com.dataiku.dss.shadelib.org.apache.iceberg.BaseMetastoreTableOperations;
import com.dataiku.dss.shadelib.org.apache.iceberg.catalog.TableIdentifier;
import com.dataiku.dss.shadelib.org.apache.iceberg.exceptions.NoSuchTableException;
import com.dataiku.dss.shadelib.org.apache.iceberg.io.FileIO;
import com.dataiku.dss.shadelib.org.apache.iceberg.relocated.com.google.common.annotations.VisibleForTesting;
import com.dataiku.dss.shadelib.org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import com.dataiku.dss.shadelibsnowflake.org.apache.iceberg.snowflake.NamespaceHelpers;
import com.dataiku.dss.shadelibsnowflake.org.apache.iceberg.snowflake.SnowflakeClient;
import com.dataiku.dss.shadelibsnowflake.org.apache.iceberg.snowflake.SnowflakeIdentifier;
import com.dataiku.dss.shadelibsnowflake.org.apache.iceberg.snowflake.SnowflakeTableMetadata;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SnowflakeTableOperations
extends BaseMetastoreTableOperations {
    private static final Logger LOG = LoggerFactory.getLogger(SnowflakeTableOperations.class);
    private final FileIO fileIO;
    private final TableIdentifier tableIdentifier;
    private final SnowflakeIdentifier snowflakeIdentifierForTable;
    private final String fullTableName;
    private final SnowflakeClient snowflakeClient;

    protected SnowflakeTableOperations(SnowflakeClient snowflakeClient, FileIO fileIO, String catalogName, TableIdentifier tableIdentifier) {
        this.snowflakeClient = snowflakeClient;
        this.fileIO = fileIO;
        this.tableIdentifier = tableIdentifier;
        this.snowflakeIdentifierForTable = NamespaceHelpers.toSnowflakeIdentifier(tableIdentifier);
        this.fullTableName = String.format("%s.%s", catalogName, tableIdentifier);
    }

    public void doRefresh() {
        LOG.debug("Getting metadata location for table {}", (Object)this.tableIdentifier);
        String location = this.loadTableMetadataLocation();
        Preconditions.checkState((location != null && !location.isEmpty() ? 1 : 0) != 0, (String)"Got null or empty location %s for table %s", (Object)location, (Object)this.tableIdentifier);
        this.refreshFromMetadataLocation(location);
    }

    public FileIO io() {
        return this.fileIO;
    }

    protected String tableName() {
        return this.fullTableName;
    }

    @VisibleForTesting
    String fullTableName() {
        return this.tableName();
    }

    private String loadTableMetadataLocation() {
        SnowflakeTableMetadata metadata = this.snowflakeClient.loadTableMetadata(this.snowflakeIdentifierForTable);
        if (metadata == null) {
            throw new NoSuchTableException("Cannot find table %s", new Object[]{this.snowflakeIdentifierForTable});
        }
        if (!metadata.getStatus().equals("success")) {
            LOG.warn("Got non-successful table metadata: {} with metadataLocation {} for table {}", new Object[]{metadata.getStatus(), metadata.icebergMetadataLocation(), this.snowflakeIdentifierForTable});
        }
        return metadata.icebergMetadataLocation();
    }
}

