/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.agentreview;

import com.dataiku.common.stereotype.PartOfPublicAPI;
import com.dataiku.dip.agentreview.AgentReviewTrait;
import com.dataiku.dip.server.services.ITaggingService;
import com.dataiku.dip.server.services.TaggableObjectsService;
import com.dataiku.dip.utils.JSON;
import com.dataiku.j2ts.annotations.UIModel;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;

@UIModel
@PartOfPublicAPI
public class AgentReview
extends TaggableObjectsService.TaggableObject {
    private static final int DEFAULT_NB_EXECUTIONS = 3;
    @JSON.FileTransient
    public String id;
    @JSON.FileTransient
    public String projectKey;
    public String name;
    public String agentSmartId;
    @Nullable
    public String agentVersion;
    public String owner;
    @Nullable
    public String helperLLMId;
    public long creationTimestamp;
    public int nbExecutions = 3;
    public List<AgentReviewTrait> traits = new ArrayList<AgentReviewTrait>();

    @Override
    public ITaggingService.TaggableType getTaggableType() {
        return ITaggingService.TaggableType.AGENT_REVIEW;
    }

    @Override
    public String getProjectKey() {
        return this.projectKey;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setProjectKey(String projectKey) {
        this.projectKey = projectKey;
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }

    @Override
    public String getDisplayName() {
        return this.name;
    }

    public List<AgentReviewTrait> getEnabledTraits() {
        return this.traits.stream().filter(t -> t.enabled).toList();
    }

    public static class AgentReviewListItem
    extends TaggableObjectsService.TaggableListItem {
        public String owner;
        public String agentId;
        public String agentVersion;
        public String agentDisplayName;

        public AgentReviewListItem(AgentReview agentReview) {
            super(agentReview);
            this.owner = agentReview.owner;
            this.agentId = agentReview.agentSmartId;
            this.agentVersion = agentReview.agentVersion;
        }

        public AgentReviewListItem(AgentReview agentReview, String agentDisplayName) {
            this(agentReview);
            this.agentDisplayName = agentDisplayName;
        }

        @Override
        public ITaggingService.TaggableType getTaggableType() {
            return ITaggingService.TaggableType.AGENT_REVIEW;
        }
    }
}

