/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.agentreview;

import com.dataiku.dip.agentreview.AgentReview;
import com.dataiku.dip.agentreview.AgentReviewTrait;
import com.dataiku.dip.analysis.coreservices.flow.SavedModelsCRUDService;
import com.dataiku.dip.dao.GeneralSettingsDAO;
import com.dataiku.dip.dao.SavedModel;
import com.dataiku.dip.llm.EnrichedLLMStructuredRef;
import com.dataiku.dip.llm.LLMRefEnricherService;
import com.dataiku.dip.llm.governance.GuardrailsPipelineSettings;
import com.dataiku.dip.llm.governance.GuardrailsPipelineUtils;
import com.dataiku.dip.llm.online.LLMClient;
import com.dataiku.dip.llm.online.LLMMeshClient;
import com.dataiku.dip.llm.online.LLMMeshClientFactory;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.util.AnyLoc;
import com.dataiku.dip.utils.DKULogger;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public class AgentReviewLLMClientManager
implements AutoCloseable {
    public LLMMeshClient agentClient;
    public LLMClient.CompletionSettings agentCompletionSettings;
    public Map<String, LLMMeshClient> llmClientPerTraitId = new HashMap<String, LLMMeshClient>();
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.agentreview.llm-client-manager");

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public AgentReviewLLMClientManager(AuthCtx authCtx, AgentReview agentReview, int nbTests) throws Exception {
        TransactionService transactionService = (TransactionService)SpringUtils.getBean(TransactionService.class);
        SavedModelsCRUDService savedModelsCRUDService = (SavedModelsCRUDService)SpringUtils.getBean(SavedModelsCRUDService.class);
        LLMRefEnricherService llmRefEnricherService = (LLMRefEnricherService)SpringUtils.getBean(LLMRefEnricherService.class);
        GeneralSettingsDAO generalSettingsDAO = (GeneralSettingsDAO)SpringUtils.getBean(GeneralSettingsDAO.class);
        try {
            GuardrailsPipelineSettings guardrailsPipelineSettings;
            EnrichedLLMStructuredRef agentRef;
            String defaultCompletionLLMId;
            SavedModel agent;
            try (Transaction ignored = transactionService.retrieveOrBeginRead();){
                AnyLoc loc = AnyLoc.resolveSmart(agentReview.projectKey, agentReview.agentSmartId).resolved();
                agent = savedModelsCRUDService.getMandatory(loc.getProjectKey(), loc.getId());
                GeneralSettingsDAO.GeneralSettings generalSettings = generalSettingsDAO.read();
                defaultCompletionLLMId = generalSettings.generativeAISettings.defaultEvalLLMCompletionModelId;
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Cannot find agent " + agentReview.agentSmartId + " in project " + agentReview.projectKey);
            }
            String resolvedVersion = StringUtils.isBlank((String)agentReview.agentVersion) ? agent.getActiveVersion() : agentReview.agentVersion;
            SavedModel.SavedModelInlineVersion agentInlineVersion = agent.getVersion(resolvedVersion).orElseThrow(() -> new IllegalArgumentException("Unknown agent version " + resolvedVersion + " for agent " + agentReview.agentSmartId));
            this.agentCompletionSettings = agentInlineVersion.toolsUsingAgentSettings.completionSettings;
            try {
                agentRef = ((LLMRefEnricherService)SpringUtils.getBean(LLMRefEnricherService.class)).getEnrichedLLMRefFromAgentSMVersion(authCtx, agent, resolvedVersion, agentReview.projectKey);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Cannot find agent version %s of agent %s in project %s".formatted(resolvedVersion, agentReview.agentSmartId, agentReview.projectKey), e);
            }
            try {
                GuardrailsPipelineSettings connectionGuardrailsPipelineSettings = GuardrailsPipelineUtils.getConnectionAndLLMLevelSettings(authCtx, agentReview.projectKey, agentRef);
                guardrailsPipelineSettings = GuardrailsPipelineUtils.mergeEnforcementSettings(connectionGuardrailsPipelineSettings, agentInlineVersion.guardrailsPipelineSettings);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("An error happened while retrieving guardrails settings of agent %s".formatted(agentReview.agentSmartId), e);
            }
            try {
                this.agentClient = LLMMeshClientFactory.get(authCtx, agentReview.projectKey, agentRef, guardrailsPipelineSettings, null, nbTests);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("An error happened during the initialization of the HTTP client for the agent", e);
            }
            for (AgentReviewTrait trait : agentReview.getEnabledTraits()) {
                EnrichedLLMStructuredRef enrichedLLMRef;
                if (StringUtils.isBlank((String)trait.name)) {
                    throw new IllegalArgumentException("Missing trait name for trait '%s'".formatted(trait.id));
                }
                if (StringUtils.isBlank((String)trait.criteria)) {
                    throw new IllegalArgumentException("No criteria is defined for trait '%s' (name='%s')".formatted(trait.id, trait.name));
                }
                String llmId = trait.llmId;
                try {
                    if (StringUtils.isBlank((String)trait.llmId)) {
                        logger.debugV("Trait %s has no LLM configure. Using instance default %s", new Object[]{trait.name, defaultCompletionLLMId});
                        llmId = defaultCompletionLLMId;
                    }
                    enrichedLLMRef = llmRefEnricherService.getEnrichedLLMRef(llmId, authCtx, agentReview.projectKey);
                }
                catch (Exception e) {
                    throw new RuntimeException("Error while retrieving enriched LLM reference for LLM '%s' for trait %s".formatted(llmId, trait.name));
                }
                try {
                    LLMMeshClient traitClient = LLMMeshClientFactory.get(authCtx, agentReview.projectKey, enrichedLLMRef, GuardrailsPipelineUtils.getConnectionAndLLMLevelSettings(authCtx, agentReview.projectKey, enrichedLLMRef), null, nbTests * agentReview.nbExecutions);
                    this.llmClientPerTraitId.put(trait.id, traitClient);
                }
                catch (Exception e) {
                    throw new IllegalArgumentException("An error happened during the initialization of the HTTP client for trait '%s' (name='%s')".formatted(trait.id, trait.name), e);
                    return;
                }
            }
        }
        catch (Throwable t) {
            this.close();
            throw new RuntimeException("Error while initializing the LLM clients for the agent and traits", t);
        }
    }

    @Override
    public void close() throws Exception {
        if (this.agentClient != null) {
            try {
                this.agentClient.close();
            }
            catch (Exception e) {
                logger.warn((Object)"Error while closing agent LLM client", (Throwable)e);
            }
        }
        for (LLMMeshClient client : this.llmClientPerTraitId.values()) {
            try {
                client.close();
            }
            catch (Exception e) {
                logger.warn((Object)"Error while closing trait LLM client", (Throwable)e);
            }
        }
    }
}

