/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.aigenerations;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.aigenerations.AIFlowGenerationService;
import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.SchemaColumn;
import com.dataiku.dip.datalayer.Column;
import com.dataiku.dip.datalayer.memimpl.MemColumn;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.shaker.model.SerializedShakerScript;
import com.dataiku.dip.shaker.server.DataService;
import com.dataiku.dip.shaker.server.MemScriptRunner;
import com.dataiku.dip.shaker.types.DataTypeMatch;
import com.dataiku.dip.util.AIFeaturesUtil;
import com.dataiku.dip.utils.DKULogger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AIGenerationService {
    @Autowired
    private DataService dataService;
    private static final DKULogger logger = DKULogger.getLogger(AIFlowGenerationService.class);

    public Map<String, MemScriptRunner.TableWithReport> getDatasetNameToTWRMap(AuthCtx owner, String projectKey, List<Dataset> datasets) {
        HashMap<String, MemScriptRunner.TableWithReport> datasetNameToTWRMap = new HashMap<String, MemScriptRunner.TableWithReport>();
        for (Dataset dataset : datasets) {
            SerializedShakerScript sss = new SerializedShakerScript();
            sss.contextProjectKey = dataset.getProjectKey();
            try {
                MemScriptRunner.TableWithReport twr = this.dataService.get_NOTRANSACTION(dataset, sss, null, null, false, owner);
                String name = dataset.getProjectKey().equals(projectKey) ? dataset.getName() : dataset.getFullName();
                datasetNameToTWRMap.put(name, twr);
            }
            catch (Exception e) {
                logger.warn((Object)("We were not able to get the sample of the dataset " + dataset.getName()), (Throwable)e);
            }
        }
        return datasetNameToTWRMap;
    }

    public List<AIDatasetInformation> getDatasetsInformation(String projectKey, List<Dataset> datasets, String query, Map<String, MemScriptRunner.TableWithReport> datasetNameToTWRMap) {
        ArrayList<AIDatasetInformation> datasetsInformation = new ArrayList<AIDatasetInformation>();
        for (Dataset dataset : datasets) {
            AIDatasetInformation datasetInformation = datasetNameToTWRMap.containsKey(dataset.getName()) ? this.getDatasetInformationWithSampleValues(projectKey, dataset, query, datasetNameToTWRMap.get(dataset.getName())) : this.getMinimalAIDatasetInformation(projectKey, dataset);
            datasetsInformation.add(datasetInformation);
        }
        return datasetsInformation;
    }

    private AIDatasetInformation getDatasetInformationWithSampleValues(String projectKey, Dataset dataset, String query, MemScriptRunner.TableWithReport twr) {
        SerializedShakerScript sss = new SerializedShakerScript();
        sss.contextProjectKey = dataset.getProjectKey();
        AIDatasetInformation datasetInformation = this.createBaseAIDatasetInformation(projectKey, dataset);
        Map<String, SchemaColumn> datasetNameToSchemaColumns = dataset.getSchema().columns.stream().collect(Collectors.toMap(SchemaColumn::getName, sc -> sc));
        for (Column c2 : twr.table.columns()) {
            MemColumn mc = (MemColumn)c2;
            if (datasetInformation.datasetColumns.size() > 50) break;
            SchemaColumn sc2 = datasetNameToSchemaColumns.get(mc.getName());
            if (sc2 == null) continue;
            AIDatasetSchemaColumnInformation datasetColInfo = this.createBaseColumnInformationWithTwr(sc2, twr);
            if (ApplicationConfigurator.getGeneralSettingsUnsafeAutoTXN().aiDrivenAnalyticsSettings.sendSampleValues) {
                datasetColInfo.sampleValues.addAll(AIFeaturesUtil.collectSampleRowValues(twr, mc, AIFeaturesUtil.Feature.AIRECIPE, query));
            }
            datasetInformation.datasetColumns.add(datasetColInfo);
        }
        datasetInformation.ok = !datasetInformation.datasetColumns.isEmpty();
        return datasetInformation;
    }

    private AIDatasetInformation getMinimalAIDatasetInformation(String projectKey, Dataset dataset) {
        AIDatasetInformation datasetInformation = this.createBaseAIDatasetInformation(projectKey, dataset);
        List schemaColumns = dataset.getSchema().columns;
        if (schemaColumns.isEmpty()) {
            datasetInformation.ok = false;
            return datasetInformation;
        }
        datasetInformation.ok = true;
        for (int i = 0; i < Math.min(schemaColumns.size(), Math.max(schemaColumns.size(), 50)); ++i) {
            datasetInformation.datasetColumns.add(this.createBaseColumnInformation((SchemaColumn)schemaColumns.get(i)));
        }
        return datasetInformation;
    }

    private AIDatasetInformation createBaseAIDatasetInformation(String projectKey, Dataset dataset) {
        AIDatasetInformation datasetInformation = new AIDatasetInformation();
        datasetInformation.name = dataset.getSmartName(projectKey);
        datasetInformation.datasetColumns = new ArrayList<AIDatasetSchemaColumnInformation>();
        return datasetInformation;
    }

    private AIDatasetSchemaColumnInformation createBaseColumnInformationWithTwr(SchemaColumn schemaColumn, MemScriptRunner.TableWithReport twr) {
        AIDatasetSchemaColumnInformation columnInformation = this.createBaseColumnInformation(schemaColumn);
        MemColumn memColumn = null;
        if (schemaColumn != null) {
            memColumn = twr.table.columns.get(schemaColumn.getName());
        }
        if (memColumn != null) {
            DataTypeMatch dataTypeMatch = memColumn.selectedType;
            columnInformation.meaning = dataTypeMatch.type.getMeaningId();
        }
        return columnInformation;
    }

    private AIDatasetSchemaColumnInformation createBaseColumnInformation(SchemaColumn schemaColumn) {
        AIDatasetSchemaColumnInformation columnInformation = new AIDatasetSchemaColumnInformation();
        if (schemaColumn != null) {
            columnInformation.name = schemaColumn.getName();
            columnInformation.columnType = schemaColumn.getType().getName();
            columnInformation.columnDescription = schemaColumn.comment;
        }
        return columnInformation;
    }

    public static class AIDatasetInformation {
        String name;
        boolean ok = true;
        List<AIDatasetSchemaColumnInformation> datasetColumns;
    }

    public static class AIDatasetSchemaColumnInformation {
        String name;
        String meaning;
        String columnType;
        String columnDescription;
        List<String> sampleValues = new ArrayList<String>();

        public AIDatasetSchemaColumnInformation() {
        }

        public AIDatasetSchemaColumnInformation(String name, String meaning, String columnDescription) {
            this(name, meaning, columnDescription, new ArrayList<String>());
        }

        public AIDatasetSchemaColumnInformation(String name, String meaning, String columnDescription, List<String> sampleValues) {
            this.name = name;
            this.meaning = meaning;
            this.columnDescription = columnDescription;
            this.sampleValues = sampleValues != null ? sampleValues : new ArrayList();
        }
    }
}

