/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.analysis.ml.clustering.flow;

import com.dataiku.dip.analysis.coreservices.AnalysisDataService;
import com.dataiku.dip.analysis.coreservices.flow.SavedModelsCRUDService;
import com.dataiku.dip.analysis.ml.FullModelId;
import com.dataiku.dip.analysis.ml.MLFlowUtils;
import com.dataiku.dip.analysis.ml.SavedModelCodes;
import com.dataiku.dip.analysis.ml.clustering.ClusteringResultsReader;
import com.dataiku.dip.analysis.ml.clustering.flow.ClusteringClusterRecipePayloadParams;
import com.dataiku.dip.analysis.ml.clustering.flow.ClusteringRecipesBasicService;
import com.dataiku.dip.analysis.ml.clustering.flow.ClusteringRecipesHelper;
import com.dataiku.dip.analysis.ml.clustering.flow.ClusteringRecipesMeta;
import com.dataiku.dip.analysis.ml.clustering.flow.ClusteringSMMgmtService;
import com.dataiku.dip.analysis.ml.clustering.flow.ClusteringScoringRecipePayloadParams;
import com.dataiku.dip.analysis.ml.clustering.flow.ClusteringTrainingRecipePayloadParams;
import com.dataiku.dip.analysis.ml.prediction.MLSchemaComparator;
import com.dataiku.dip.analysis.model.MLTask;
import com.dataiku.dip.analysis.model.ModelTrainInfo;
import com.dataiku.dip.analysis.model.clustering.ClusteringMLTask;
import com.dataiku.dip.analysis.model.clustering.ClusteringModelDetails;
import com.dataiku.dip.analysis.model.clustering.PreTrainClusteringModelingParams;
import com.dataiku.dip.analysis.model.core.ResolvedCoreParams;
import com.dataiku.dip.containers.exec.ContainerExecUtils;
import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.coremodel.Schema;
import com.dataiku.dip.coremodel.SerializedRecipe;
import com.dataiku.dip.dao.RecipesDAO;
import com.dataiku.dip.dao.SavedModel;
import com.dataiku.dip.dataflow.JobActivity;
import com.dataiku.dip.dataflow.RecipeRunnableSubgraph;
import com.dataiku.dip.dataflow.exec.ContainerRecipeParams;
import com.dataiku.dip.datalayer.utils.RecipeCreationUtils;
import com.dataiku.dip.datalayer.utils.SchemaComparator;
import com.dataiku.dip.datasets.ManagedDatasetsHelper;
import com.dataiku.dip.exceptions.CodedException;
import com.dataiku.dip.recipes.ManagedDatasetsCreationService;
import com.dataiku.dip.recipes.RecipeRegistry;
import com.dataiku.dip.recipes.common.RecipeCreator;
import com.dataiku.dip.recipes.services.PDepsFixuper;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.server.datasets.DatasetAccessService;
import com.dataiku.dip.server.datasets.DatasetSaveService;
import com.dataiku.dip.server.recipes.RecipeSaveService;
import com.dataiku.dip.server.recipes.ShakerRecipeService;
import com.dataiku.dip.server.services.FlowZonesService;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.shaker.model.SerializedShakerScript;
import com.dataiku.dip.transactions.TransactionContext;
import com.dataiku.dip.transactions.ifaces.RWTransaction;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.util.DatasetLocUtils;
import com.dataiku.dip.util.SecretKeyGenerator;
import com.dataiku.dip.utils.ErrorContext;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.utils.Pair;
import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ClusteringRecipesService
extends ClusteringRecipesBasicService {
    @Autowired
    private DatasetAccessService datasetAccessService;
    @Autowired
    private DatasetSaveService datasetSaveService;
    @Autowired
    private ClusteringSMMgmtService savedModelsMgmtService;
    @Autowired
    private SavedModelsCRUDService savedModelsService;
    @Autowired
    private RecipeSaveService recipeSaveService;
    @Autowired
    private RecipesDAO recipesDAO;
    @Autowired
    private ShakerRecipeService shakerRecipeService;
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private AnalysisDataService dataService;
    @Autowired
    private ManagedDatasetsCreationService mdcService;
    @Autowired
    private FlowZonesService flowZonesService;
    private static Logger logger = Logger.getLogger((String)"dku.analysis.flow");

    public Pair<String, String> createTrainingRecipePrep_NT(AuthCtx u, FullModelId fmi, DatasetLocUtils.DatasetLoc inputDataset, String modelName) throws Exception {
        TransactionContext.assertNoAttachedTransaction();
        String targetProjectKey = fmi.getTaskLoc().analysisProjectKey;
        ClusteringModelDetails details = ClusteringResultsReader.makeDetails(fmi);
        if (details.trainInfo.state != ModelTrainInfo.ModelTrainState.DONE) {
            throw ErrorContext.iae((String)"Can't create a recipe on a non-DONE model");
        }
        if (details.modeling.algorithm.backendType == MLTask.BackendType.VERTICA) {
            throw new CodedException((InfoMessage.MessageCode)SavedModelCodes.ERR_ML_VERTICA_NOT_SUPPORTED, "Cannot create training recipe for model " + String.valueOf(fmi));
        }
        SerializedShakerScript script = fmi.parseSessionFile("script.json", SerializedShakerScript.class);
        SavedModel sm = new SavedModel(targetProjectKey, SecretKeyGenerator.generate((int)8));
        sm.name = modelName;
        this.savedModelsMgmtService.createFromMLTask(u, fmi, sm);
        Dataset trainDataset = null;
        try (Transaction t = this.transactionService.beginRead();){
            trainDataset = this.datasetAccessService.getMandatory(inputDataset);
        }
        ClusteringTrainingRecipePayloadParams desc = new ClusteringTrainingRecipePayloadParams();
        desc.modelVersionNamePrefix = fmi.getUserMeta().name;
        desc.preprocessing = details.preprocessing;
        desc.modeling = (PreTrainClusteringModelingParams)JSON.deepCopy((Object)details.modeling);
        desc.sampling = details.splitDesc.cparams;
        desc.script = script;
        desc.generatingModelId = fmi.toString();
        ClusteringMLTask miniTask = (ClusteringMLTask)sm.miniTask;
        desc.sampling.datasetSmartName = inputDataset.getSmartName(targetProjectKey);
        this.setFromCoreParams(details.coreParams, desc);
        ArrayList contentTypeChunks = Lists.newArrayList();
        contentTypeChunks.add(miniTask.taskType.name().toLowerCase());
        contentTypeChunks.add(miniTask.backendType.name().toLowerCase());
        sm.contentType = Joiner.on((String)"/").join((Iterable)contentTypeChunks);
        desc.expectedPreparationOutputSchema = details.splitDesc.schema;
        SerializedRecipe sr = new SerializedRecipe();
        sr.type = ClusteringRecipesMeta.TRAINING_META.getType();
        sr.params = new ContainerRecipeParams();
        ContainerExecUtils.expandContainerParamsIfNeeded(sr, details.coreParams);
        sr.addInput("main", inputDataset.getSmartName(targetProjectKey));
        sr.addOutput("main", sm.id, false);
        sr.labels = fmi.getTrainedWithMLTask().labels;
        RecipeCreationUtils.makeEqualsOrAllAvailableDep(sr, "main", inputDataset.getSmartName(targetProjectKey), trainDataset, sm);
        logger.info((Object)("Training recipe ready: \n" + JSON.prettyLog((Object)desc)));
        try (RWTransaction rwt = this.transactionService.beginWriteAsLoggedInUser(u);){
            this.savedModelsService.save(sm, true, false);
            sr.name = this.recipeSaveService.transmogrifyName(targetProjectKey, "train_" + modelName.replaceAll("[^A-Za-z0-9\\-_]", "_"));
            sr.projectKey = targetProjectKey;
            String inputZone = this.flowZonesService.retrieveInputZone(sr);
            if (inputZone != null) {
                this.flowZonesService.attachObjectToZone(inputZone, sr.projectKey, sr);
                this.flowZonesService.attachObjectToZone(inputZone, sr.projectKey, sm);
            }
            this.shakerRecipeService.updateDependenciesOnAnyRecipe(targetProjectKey, sr, script);
            this.recipeSaveService.create(fmi.getTaskLoc().analysisProjectKey, sr, JSON.pretty((Object)desc));
            rwt.commit("Created train recipe " + sr.projectKey + "." + sr.name);
        }
        return new Pair((Object)sr.name, (Object)sm.id);
    }

    private void setFromCoreParams(ResolvedCoreParams rcp, ClusteringTrainingRecipePayloadParams desc) {
        desc.backendType = rcp.backendType;
        desc.diagnosticsSettings = rcp.diagnosticsSettings;
        desc.sparkParams.sparkConf = rcp.executionParams.sparkParams.sparkConf;
        desc.sparkParams.sparkExecutionEngine = rcp.executionParams.sparkParams.sparkExecutionEngine;
        desc.sparkParams.sparkUseGlobalMetastore = rcp.executionParams.sparkParams.sparkUseGlobalMetastore;
        desc.sparkParams.sparkPreparedDFStorageLevel = rcp.executionParams.sparkParams.sparkPreparedDFStorageLevel;
        if (desc.backendType == MLTask.BackendType.PY_MEMORY) {
            desc.envSelection = rcp.executionParams.envSelection;
            desc.envName = rcp.executionParams.envName;
        }
    }

    public boolean updateTrainingRecipePrep_NT(AuthCtx u, FullModelId fmi, SerializedRecipe sr, boolean activate) throws Exception {
        ClusteringTrainingRecipePayloadParams desc;
        Dataset trainDataset;
        String versionId;
        SavedModel sm;
        TransactionContext.assertNoAttachedTransaction();
        String targetProjectKey = fmi.getTaskLoc().analysisProjectKey;
        ClusteringModelDetails details = ClusteringResultsReader.makeDetails(fmi);
        if (details.trainInfo.state != ModelTrainInfo.ModelTrainState.DONE) {
            throw ErrorContext.iae((String)"Can't update a recipe on a non-DONE model");
        }
        if (details.modeling.algorithm.backendType == MLTask.BackendType.VERTICA) {
            throw new CodedException((InfoMessage.MessageCode)SavedModelCodes.ERR_ML_VERTICA_NOT_SUPPORTED, "Cannot update training recipe for model " + String.valueOf(fmi));
        }
        SerializedShakerScript script = fmi.parseSessionFile("script.json", SerializedShakerScript.class);
        try (Transaction t = this.transactionService.beginRead();){
            sm = this.savedModelsService.getMandatory(targetProjectKey, sr.getSingleOutput((String)"main").ref);
            versionId = this.savedModelsMgmtService.updateFromMLTask(fmi, sm);
            trainDataset = this.datasetAccessService.getMandatory(DatasetLocUtils.resolveSmart(targetProjectKey, sr.getSingleInput((String)"main").ref));
            String payload = this.recipesDAO.getPayloadOrNull(fmi.getProjectKey(), sr.name);
            desc = (ClusteringTrainingRecipePayloadParams)JSON.parse((String)payload, ClusteringTrainingRecipePayloadParams.class);
        }
        sr.labels = fmi.getTrainedWithMLTask().labels;
        script.contextProjectKey = sm.projectKey;
        desc.modelVersionNamePrefix = fmi.getUserMeta().name;
        desc.preprocessing = details.preprocessing;
        desc.modeling = (PreTrainClusteringModelingParams)JSON.deepCopy((Object)details.modeling);
        desc.sampling = fmi.parseSessionFile((String)"mltask.json", ClusteringMLTask.class).sampling;
        desc.script = script;
        desc.generatingModelId = fmi.toString();
        desc.sampling.datasetSmartName = trainDataset.getLoc().getSmartName(targetProjectKey);
        this.setFromCoreParams(details.coreParams, desc);
        desc.expectedPreparationOutputSchema = details.splitDesc.schema;
        ContainerExecUtils.expandContainerParamsIfNeeded(sr, details.coreParams);
        logger.info((Object)("Training recipe updated: \n" + JSON.prettyLog((Object)desc)));
        boolean schemaChanged = false;
        try (RWTransaction rwt = this.transactionService.beginWriteAsLoggedInUser(u);){
            sm.lastTrainIndex = 1L;
            if (activate) {
                schemaChanged = this.savedModelsMgmtService.setActive(sm, versionId) && this.hasDownstreamRecipe(sm);
            } else {
                this.savedModelsService.save(sm, false, false);
            }
            this.savedModelsService.addDeployedSavedModelVersionSuffixAndUpdateLabel(sm, versionId);
            this.recipeSaveService.save(targetProjectKey, sr, JSON.pretty((Object)desc));
            rwt.commit("Updated train recipe " + sr.projectKey + "." + sr.name);
        }
        return schemaChanged;
    }

    public boolean hasDownstreamRecipe(SavedModel sm) throws IOException {
        for (SerializedRecipe recipe : this.recipesDAO.listUnsafe(sm.projectKey)) {
            if (!recipe.getType().equals(ClusteringRecipesMeta.SCORING_META.getType()) || recipe.getInputsForRole("model").size() != 1 || !recipe.getSingleInput((String)"model").ref.endsWith(sm.id)) continue;
            return true;
        }
        return false;
    }

    public String createClusterRecipe_NT(AuthCtx u, FullModelId fmi, DatasetLocUtils.DatasetLoc inputDatasetLoc, String outputDatasetName, ManagedDatasetsCreationService.ManagedDatasetCreationSettings outputDatasetSettings) throws Exception {
        Dataset outputDataset;
        TransactionContext.assertNoAttachedTransaction();
        String targetProjectKey = fmi.getTaskLoc().analysisProjectKey;
        DatasetLocUtils.DatasetLoc outputDatasetLoc = new DatasetLocUtils.DatasetLoc(targetProjectKey, outputDatasetName);
        ClusteringModelDetails details = ClusteringResultsReader.makeDetails(fmi);
        if (details.trainInfo.state != ModelTrainInfo.ModelTrainState.DONE) {
            throw ErrorContext.iae((String)"Can't create a recipe on a non-DONE model");
        }
        Dataset inputDataset = null;
        try (Transaction t = this.transactionService.beginRead();){
            inputDataset = this.datasetAccessService.getMandatory(inputDatasetLoc);
            outputDataset = this.mdcService.prepareCopyPartitioning(u, outputDatasetLoc.getProjectKey(), outputDatasetName, outputDatasetSettings);
        }
        SerializedShakerScript script = fmi.parseSessionFile("script.json", SerializedShakerScript.class);
        Schema inferredPreparationOutputSchema = this.dataService.getInferredSchemaForML_NT(script, targetProjectKey, inputDataset, outputDataset.getType(), u);
        List<InfoMessage> messages = MLSchemaComparator.checkForScore(details.preprocessing, inferredPreparationOutputSchema);
        if (InfoMessage.anyFatal(messages)) {
            throw ErrorContext.iae((String)("Cannot apply the model with the dataset schema (" + InfoMessage.firstFatal(messages).message + ")"));
        }
        Schema usedPreparationOutputSchema = MLFlowUtils.getSchemaToUseForPreparedScoringInput(details.preprocessing, details.splitDesc.schema, inferredPreparationOutputSchema);
        outputDataset.setSchema(this.getOutputSchema(usedPreparationOutputSchema, null, details.modeling.algorithm.meta.additionalScoringColumns()));
        ClusteringClusterRecipePayloadParams desc = new ClusteringClusterRecipePayloadParams();
        desc.preprocessing = details.preprocessing;
        desc.modeling = (PreTrainClusteringModelingParams)JSON.deepCopy((Object)details.modeling);
        desc.sampling = fmi.parseSessionFile((String)"mltask.json", ClusteringMLTask.class).sampling;
        desc.generatingModelId = fmi.toString();
        desc.script = script;
        desc.sampling.datasetSmartName = inputDatasetLoc.getSmartName(targetProjectKey);
        this.setFromCoreParams(details.coreParams, desc);
        desc.expectedPreparationOutputSchema = usedPreparationOutputSchema;
        SerializedRecipe sr = new SerializedRecipe();
        sr.type = ClusteringRecipesMeta.CLUSTER_META.getType();
        sr.params = new ContainerRecipeParams();
        ContainerExecUtils.expandContainerParamsIfNeeded(sr, details.coreParams);
        sr.addInput("main", inputDatasetLoc.getSmartName(outputDatasetLoc.getProjectKey()));
        sr.addOutput("main", outputDatasetLoc.getName(), false);
        logger.info((Object)("Clustering recipe ready: \n" + JSON.prettyLog((Object)desc)));
        try (RWTransaction rwt = this.transactionService.beginWriteAsLoggedInUser(u);){
            String dotlessDsName = inputDatasetLoc.getSmartName(targetProjectKey).replace('.', '_');
            sr.name = this.recipeSaveService.transmogrifyName(targetProjectKey, "cluster_" + dotlessDsName);
            DatasetSaveService.DatasetCreationContext dsCtx = DatasetSaveService.DatasetCreationContext.buildFromRecipe(sr);
            this.datasetSaveService.create(outputDatasetLoc.getProjectKey(), outputDataset.serialize(), dsCtx, u);
            sr.projectKey = targetProjectKey;
            this.shakerRecipeService.updateDependenciesOnAnyRecipe(targetProjectKey, sr, script);
            new PDepsFixuper().fixupInPlace(sr);
            this.recipeSaveService.create(fmi.getTaskLoc().analysisProjectKey, sr, JSON.pretty((Object)desc));
            rwt.commit("Created clustering recipe " + sr.projectKey + "." + sr.name);
        }
        return sr.name;
    }

    public boolean updateClusterRecipe_NT(AuthCtx u, FullModelId fmi, SerializedRecipe sr) throws Exception {
        TransactionContext.assertNoAttachedTransaction();
        String targetProjectKey = fmi.getTaskLoc().analysisProjectKey;
        ClusteringModelDetails details = ClusteringResultsReader.makeDetails(fmi);
        if (details.trainInfo.state != ModelTrainInfo.ModelTrainState.DONE) {
            throw ErrorContext.iae((String)"Can't update a recipe on a non-DONE model");
        }
        SerializedShakerScript script = fmi.parseSessionFile("script.json", SerializedShakerScript.class);
        Dataset inputDataset = null;
        Dataset outputDataset = null;
        ClusteringClusterRecipePayloadParams desc = null;
        try (Transaction t = this.transactionService.beginRead();){
            inputDataset = this.datasetAccessService.getMandatory(DatasetLocUtils.resolveSmart(targetProjectKey, sr.getSingleInput((String)"main").ref));
            outputDataset = this.datasetAccessService.getMandatory(DatasetLocUtils.resolveSmart(targetProjectKey, sr.getSingleOutput((String)"main").ref));
            desc = (ClusteringClusterRecipePayloadParams)JSON.parse((String)this.recipesDAO.getPayloadOrNull(fmi.getProjectKey(), sr.name), ClusteringClusterRecipePayloadParams.class);
        }
        script.contextProjectKey = targetProjectKey;
        Schema expectedPreparationOutputSchema = this.dataService.getInferredSchemaForML_NT(script, targetProjectKey, inputDataset, outputDataset.getType(), u);
        boolean schemaChanged = !SchemaComparator.findIncompatibilities(desc.expectedPreparationOutputSchema, expectedPreparationOutputSchema, true).isEmpty();
        List<InfoMessage> messages = MLSchemaComparator.checkForScore(details.preprocessing, expectedPreparationOutputSchema);
        if (InfoMessage.anyFatal(messages)) {
            throw ErrorContext.iae((String)("Cannot apply the model with the dataset schema (" + InfoMessage.firstFatal(messages).message + ")"));
        }
        if (inputDataset.getPartitioningSchema().isPartitioned()) {
            ManagedDatasetsHelper.copyPartitioning(this.datasetsDAO, inputDataset, outputDataset);
        }
        desc.preprocessing = details.preprocessing;
        desc.modeling = (PreTrainClusteringModelingParams)JSON.deepCopy((Object)details.modeling);
        desc.sampling = fmi.parseSessionFile((String)"mltask.json", ClusteringMLTask.class).sampling;
        desc.diagnosticsSettings = details.coreParams.diagnosticsSettings;
        desc.generatingModelId = fmi.toString();
        desc.script = script;
        desc.sampling.datasetSmartName = inputDataset.getLoc().getSmartName(targetProjectKey);
        desc.expectedPreparationOutputSchema = expectedPreparationOutputSchema;
        this.setFromCoreParams(details.coreParams, desc);
        logger.info((Object)("Clustering recipe ready: \n" + JSON.prettyLog((Object)desc)));
        ContainerExecUtils.expandContainerParamsIfNeeded(sr, details.coreParams);
        try (RWTransaction rwt = this.transactionService.beginWriteAsLoggedInUser(u);){
            this.recipeSaveService.save(targetProjectKey, sr, JSON.pretty((Object)desc));
            rwt.commit("Updated clustering recipe " + sr.projectKey + "." + sr.name);
        }
        return schemaChanged;
    }

    public RecipeCreator.CreationResult createScoringRecipe_NT(AuthCtx u, String projectKey, String savedModelSM, String inputDatasetSM, boolean createOutputDataset, String outputDatasetSM, ManagedDatasetsCreationService.ManagedDatasetCreationSettings outputDatasetSettings) throws Exception {
        TransactionContext.assertNoAttachedTransaction();
        ClusteringRecipesHelper helper = new ClusteringRecipesHelper();
        SpringUtils.getInstance().autowire((Object)helper);
        return helper.createScoringRecipe_NT(u, projectKey, savedModelSM, inputDatasetSM, createOutputDataset, outputDatasetSM, outputDatasetSettings);
    }

    public Map<SerializedRecipe, SavedModel> listUpdatableTrain(String projectKey, MLTask.BackendType backendType) throws Exception {
        HashMap<String, SavedModel> models = new HashMap<String, SavedModel>();
        for (SavedModel sm : this.savedModelsService.list(projectKey)) {
            if (sm.miniTask == null || sm.getType() != MLTask.MLTaskType.CLUSTERING || sm.miniTask.backendType != backendType) continue;
            models.put(sm.id, sm);
        }
        HashMap<SerializedRecipe, SavedModel> result = new HashMap<SerializedRecipe, SavedModel>();
        if (!models.isEmpty()) {
            for (SerializedRecipe recipe : this.recipesDAO.list(projectKey)) {
                if (recipe.getOutputsForRole("main").size() != 1 || !models.containsKey(recipe.getSingleOutput((String)"main").ref)) continue;
                result.put(recipe, (SavedModel)models.get(recipe.getSingleOutput((String)"main").ref));
            }
        }
        return result;
    }

    public List<SerializedRecipe> listUpdatableCluster(String projectKey, MLTask.BackendType backendType) throws Exception {
        LinkedList<SerializedRecipe> result = new LinkedList<SerializedRecipe>();
        for (SerializedRecipe recipe : this.recipesDAO.list(projectKey)) {
            if (RecipeRegistry.getMeta(recipe.type) != ClusteringRecipesMeta.CLUSTER_META) continue;
            ClusteringClusterRecipePayloadParams desc = (ClusteringClusterRecipePayloadParams)JSON.parse((String)this.recipesDAO.getPayloadOrNull(projectKey, recipe.name), ClusteringClusterRecipePayloadParams.class);
            if (desc.backendType != backendType) continue;
            result.add(recipe);
        }
        return result;
    }

    public Schema getPreparedSchema_NT(AuthCtx authCtx, JobActivity activity) throws Exception {
        Schema preparedSchema;
        SerializedRecipe recipe = ((RecipeRunnableSubgraph)activity.getSubgraph()).getRecipe().getModel();
        String payload = null;
        try (Transaction t = this.transactionService.beginRead();){
            payload = this.recipesDAO.getPayloadOrNull(recipe.projectKey, recipe.name);
        }
        if ("clustering_cluster".equals(recipe.type)) {
            desc = (ClusteringClusterRecipePayloadParams)JSON.parse((String)payload, ClusteringClusterRecipePayloadParams.class);
            preparedSchema = this.getClusterRecipePreparedSchema_NT(authCtx, activity, (ClusteringClusterRecipePayloadParams)desc);
        } else if ("clustering_scoring".equals(recipe.type)) {
            desc = (ClusteringScoringRecipePayloadParams)JSON.parse((String)payload, ClusteringScoringRecipePayloadParams.class);
            preparedSchema = this.getScoringRecipePreparedSchema_NT(authCtx, activity, (ClusteringScoringRecipePayloadParams)desc);
        } else {
            throw ErrorContext.iae((String)("Invalid recipe type: " + recipe.type));
        }
        return preparedSchema;
    }
}

