/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.analysis.ml.llm;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.DSSTempUtils;
import com.dataiku.dip.agents.tools.AgentTool;
import com.dataiku.dip.agents.tools.AgentToolsDAO;
import com.dataiku.dip.agents.tools.inlinepython.InlinePythonTool;
import com.dataiku.dip.analysis.ml.MLPaths;
import com.dataiku.dip.code.CodeEnvModel;
import com.dataiku.dip.code.CodeEnvSelection;
import com.dataiku.dip.code.CodeEnvSelector;
import com.dataiku.dip.code.DesignNodeCodeEnvsService;
import com.dataiku.dip.dao.SavedModel;
import com.dataiku.dip.export.ZipUnzipDir;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.DiagConfigRedactionUtils;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.fs.NativeFS;
import com.dataiku.dip.transactions.fs.RelFile;
import com.dataiku.dip.transactions.fs.ifaces.ReadWriteFS;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.util.AnyLoc;
import com.dataiku.dip.util.AutoDelete;
import com.dataiku.dip.utils.DKUDateUtils;
import com.dataiku.dip.utils.DKUFileUtils;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableSet;
import com.google.gson.JsonObject;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AgentDiagnosisService {
    public static final ImmutableSet<String> EXCLUDED_PATH_SUFFIXES = ImmutableSet.of((Object)"secret.yaml");
    private final Predicate<String> pathPredicate = filename -> EXCLUDED_PATH_SUFFIXES.stream().noneMatch(filename::endsWith);
    @Autowired
    private DesignNodeCodeEnvsService designNodeEnvsService;
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private AgentToolsDAO agentToolsDAO;

    public String preloadDiagnosis(AuthCtx authCtx, SavedModel savedModel, String versionId, DiagnosisPreloadPayload payload) throws IOException {
        Preconditions.checkArgument((boolean)savedModel.savedModelType.isAgent(), (Object)"Agent diagnosis only supports agents.");
        AutoDelete preloadTmpDir = DSSTempUtils.getTempFolder((String)"agent-diag", (String)("agent" + savedModel.id));
        if (StringUtils.isNotBlank((String)payload.trace)) {
            File preloadedFile = DKUFileUtils.build((File)preloadTmpDir, (String[])new String[]{"trace.json"});
            DKUFileUtils.writeFileUTF8((File)preloadedFile, (String)payload.trace);
        }
        return preloadTmpDir.getName();
    }

    public void generateDiagnosis(AuthCtx authCtx, SavedModel savedModel, String versionId, String preloadTmpFolderName, OutputStream outputStream) throws IOException {
        Preconditions.checkArgument((boolean)savedModel.savedModelType.isAgent(), (Object)"Agent diagnosis only supports agents.");
        try (AutoDelete workingDir = DSSTempUtils.getTempFolder((String)"agent-diag", (String)("agent" + savedModel.id));){
            String codeEnvName2;
            Optional<SavedModel.SavedModelInlineVersion> smiv;
            File logsFolder;
            Files.copy(MLPaths.agentConfigFile(savedModel.projectKey, savedModel.id).toPath(), DKUFileUtils.build((File)workingDir, (String[])new String[]{"agent.json"}).toPath(), new CopyOption[0]);
            if (savedModel.savedModelType == SavedModel.SavedModelType.PYTHON_AGENT) {
                Files.copy(MLPaths.agentSourceCodeFile(savedModel.projectKey, savedModel.id, versionId).toPath(), DKUFileUtils.build((File)workingDir, (String[])new String[]{"agent.py"}).toPath(), new CopyOption[0]);
            }
            if (DKUFileUtils.isDirectory((File)(logsFolder = DKUFileUtils.build((File)MLPaths.savedModelVersionFolder(savedModel.projectKey, savedModel.id, versionId), (String[])new String[]{"logs"})))) {
                DKUFileUtils.copyDirectory((File)logsFolder, (File)DKUFileUtils.build((File)workingDir, (String[])new String[]{"logs"}));
            }
            if (StringUtils.isNotBlank((String)preloadTmpFolderName)) {
                File preloadTmpDir = DKUFileUtils.getWithin((File)workingDir.getParentFile(), (String[])new String[]{preloadTmpFolderName});
                DKUFileUtils.copyDirectory((File)preloadTmpDir, (File)workingDir);
                DKUFileUtils.deleteDirectory((File)preloadTmpDir);
            }
            HashSet<String> codeEnvNames = new HashSet<String>();
            switch (savedModel.savedModelType) {
                case TOOLS_USING_AGENT: {
                    String codeEnvName3;
                    smiv = savedModel.getVersion(versionId);
                    if (smiv.isPresent() && smiv.get().toolsUsingAgentSettings.mode == SavedModel.ToolsUsingAgentMode.BLOCKS_GRAPH) {
                        codeEnvName2 = new CodeEnvSelector().selectForAdvancedLLMAgent(savedModel.projectKey, smiv.get().toolsUsingAgentSettings.codeEnvSelection);
                    } else {
                        codeEnvName3 = new CodeEnvSelector().selectForLLMAgent();
                    }
                    if (!StringUtils.isNotBlank((String)codeEnvName3) || StringUtils.equals((String)codeEnvName3, (String)"__BUILTIN_ENV__")) break;
                    codeEnvNames.add(codeEnvName3);
                    break;
                }
                case PYTHON_AGENT: {
                    smiv = savedModel.getVersion(versionId);
                    if (!smiv.isPresent() || !StringUtils.isNotBlank((String)(codeEnvName2 = new CodeEnvSelector().selectForPythonRecipe(savedModel.projectKey, smiv.get().pythonAgentSettings.codeEnvSelection))) || StringUtils.equals((String)codeEnvName2, (String)"__BUILTIN_ENV__")) break;
                    codeEnvNames.add(codeEnvName2);
                }
            }
            Files.copy(ApplicationConfigurator.getFile((String[])new String[]{"config", "connections.json"}).toPath(), DKUFileUtils.build((File)workingDir, (String[])new String[]{"connections.json"}).toPath(), new CopyOption[0]);
            if (savedModel.savedModelType == SavedModel.SavedModelType.TOOLS_USING_AGENT && (smiv = savedModel.getVersion(versionId)).isPresent()) {
                File toolsFolder = DKUFileUtils.build((File)workingDir, (String[])new String[]{"tools"});
                toolsFolder.mkdir();
                HashSet<String> toolsToAdd = new HashSet<String>();
                SavedModel.ToolsUsingAgentSettings settings = smiv.get().toolsUsingAgentSettings;
                if (settings.mode == SavedModel.ToolsUsingAgentMode.BLOCKS_GRAPH) {
                    for (SavedModel.BlocksGraphBlock block : smiv.get().toolsUsingAgentSettings.blocks) {
                        SavedModel.ToolUsingBlock toolUsingBlock;
                        List<? extends SavedModel.BlockGraphTool> toolRefs;
                        if (!(block instanceof SavedModel.ToolUsingBlock) || (toolRefs = (toolUsingBlock = (SavedModel.ToolUsingBlock)((Object)block)).getToolRefs()) == null) continue;
                        for (SavedModel.BlockGraphTool blockGraphTool : toolRefs) {
                            if (blockGraphTool == null || !StringUtils.isNotBlank((String)blockGraphTool.toolRef)) continue;
                            toolsToAdd.add(blockGraphTool.toolRef);
                        }
                    }
                } else {
                    for (SavedModel.UsedTool usedTool : settings.tools) {
                        if (usedTool.toolRef == null) continue;
                        toolsToAdd.add(usedTool.toolRef);
                    }
                }
                for (String toolRef : toolsToAdd) {
                    String codeEnvName2;
                    JsonObject codeEnvSelectionJson;
                    AgentTool agentTool;
                    AnyLoc loc = AnyLoc.resolveSmart(savedModel.projectKey, toolRef);
                    File toolFolder = DKUFileUtils.build((File)toolsFolder, (String[])new String[]{toolRef});
                    toolFolder.mkdir();
                    Files.copy(MLPaths.agentToolConfigFile(loc.getProjectKey(), loc.getId()).toPath(), DKUFileUtils.build((File)toolFolder, (String[])new String[]{"tool.json"}).toPath(), new CopyOption[0]);
                    try (Transaction transaction = this.transactionService.beginRead();){
                        agentTool = (AgentTool)this.agentToolsDAO.getMandatoryUnsafe(loc);
                    }
                    if (agentTool == null) continue;
                    File file = DKUFileUtils.build((File)MLPaths.agentToolFolder(loc.getProjectKey(), loc.getId()), (String[])new String[]{"logs"});
                    if (DKUFileUtils.isDirectory((File)file)) {
                        DKUFileUtils.copyDirectory((File)file, (File)DKUFileUtils.build((File)toolFolder, (String[])new String[]{"logs"}));
                    }
                    if (StringUtils.equals((String)agentTool.type, (String)InlinePythonTool.META.getType())) {
                        Files.copy(MLPaths.agentToolSourceCodeFile(loc.getProjectKey(), loc.getId()).toPath(), DKUFileUtils.build((File)toolFolder, (String[])new String[]{"tool.py"}).toPath(), new CopyOption[0]);
                    }
                    if ((codeEnvSelectionJson = agentTool.params.getAsJsonObject("codeEnvSelection")) == null) continue;
                    CodeEnvSelection envSelection = new CodeEnvSelection();
                    envSelection.envMode = CodeEnvSelection.EnvMode.valueOf(codeEnvSelectionJson.get("envMode").getAsString());
                    if (codeEnvSelectionJson.get("envName") != null) {
                        envSelection.envName = codeEnvSelectionJson.get("envName").getAsString();
                    }
                    if (!StringUtils.isNotBlank((String)(codeEnvName2 = new CodeEnvSelector().selectForPythonRecipe(loc.getProjectKey(), envSelection))) || StringUtils.equals((String)codeEnvName2, (String)"__BUILTIN_ENV__")) continue;
                    codeEnvNames.add(codeEnvName2);
                }
            }
            for (String codeEnvName2 : codeEnvNames) {
                File codeEnvExportDir = DKUFileUtils.build((File)workingDir, (String[])new String[]{"code-envs", codeEnvName2});
                codeEnvExportDir.mkdirs();
                this.designNodeEnvsService.exportEnvDefStandalone(CodeEnvModel.EnvLang.PYTHON, codeEnvName2, codeEnvExportDir);
                DKUFileUtils.copyDirectory((File)this.designNodeEnvsService.getEnvLogsDir(CodeEnvModel.EnvLang.PYTHON, codeEnvName2), (File)DKUFileUtils.build((File)codeEnvExportDir, (String[])new String[]{"logs"}));
            }
            DiagConfigRedactionUtils.redactLocalConfig((ReadWriteFS)NativeFS.from((File)workingDir).build(), authCtx);
            String zipBasePath = this.getArchiveName(savedModel, versionId) + "/";
            try (ZipUnzipDir.ZipBuilder zipBuilder = ZipUnzipDir.zipBuilder(new BufferedOutputStream(outputStream));){
                ZipUnzipDir.DefaultFileInputStreamProvider fisp = new ZipUnzipDir.DefaultFileInputStreamProvider();
                Pattern configFilesExclude = DiagConfigRedactionUtils.configFilesExclude;
                zipBuilder.addDirectory(zipBasePath, (File)workingDir, true, this.pathPredicate, configFilesExclude, fisp);
            }
        }
    }

    public String getArchiveName(SavedModel savedModel, String versionId) {
        Object archiveName = "dss-agent-diag-" + savedModel.projectKey + "-" + savedModel.getDisplayName() + "-" + savedModel.getId() + "-" + versionId + "-" + DKUDateUtils.isoFormatFileFriendlyLocalNow();
        archiveName = RelFile.ensureValidName((String)archiveName);
        return archiveName;
    }

    public static class DiagnosisPreloadPayload {
        String trace;
    }
}

