/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.analysis.ml.timeseries;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.analysis.coreservices.AnalysisMLContainerKernel;
import com.dataiku.dip.analysis.coreservices.AnalysisMLKernel;
import com.dataiku.dip.analysis.coreservices.IAnalysisMLKernel;
import com.dataiku.dip.analysis.ml.FullModelId;
import com.dataiku.dip.analysis.ml.MLPaths;
import com.dataiku.dip.analysis.model.core.ResolvedCoreParams;
import com.dataiku.dip.analysis.model.prediction.TimeseriesEvaluationForecasts;
import com.dataiku.dip.analysis.model.prediction.TimeseriesInteractiveScoringScenarios;
import com.dataiku.dip.containers.exec.ContainerExecConfigSelector;
import com.dataiku.dip.containers.exec.ContainerExecRuntimeConfig;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.exceptions.CodedException;
import com.dataiku.dip.futures.FutureProgress;
import com.dataiku.dip.futures.FutureProgressState;
import com.dataiku.dip.io.AlivenessCheckableAndClosable;
import com.dataiku.dip.io.SingleCommandKernelLink;
import com.dataiku.dip.io.SocketBlockLinkException;
import com.dataiku.dip.io.SocketBlockLinkIOException;
import com.dataiku.dip.io.SocketBlockLinkInteraction;
import com.dataiku.dip.io.SocketBlockLinkKernelException;
import com.dataiku.dip.kernels.IDSSKernelBase;
import com.dataiku.dip.remoterun.RemoteRunsRegistry;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.impersonation.FilesystemACLUtils;
import com.dataiku.dip.security.rpc.EncryptedRPC;
import com.dataiku.dip.util.SecretKeyGenerator;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.JSON;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class TimeseriesInteractiveScoringKernel
implements AlivenessCheckableAndClosable {
    private static final String CREATE_COMMAND = "create_scenario";
    private static final String COMPUTE_COMMAND = "compute_scenario";
    private IAnalysisMLKernel kernel;
    private final AuthCtx authCtx;
    private final FullModelId fmi;
    private final boolean runsInContainer;
    private boolean started;
    private final SingleCommandKernelLink link;
    private static final String pythonModule = "dataiku.doctor.timeseries_interactive.server";
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.ml.timeseries-interactive");

    public TimeseriesInteractiveScoringKernel(AuthCtx authCtx, FullModelId fmi) throws Exception {
        this.authCtx = authCtx;
        this.fmi = fmi;
        ResolvedCoreParams coreParams = fmi.getResolvedCoreParams();
        String envName = coreParams.executionParams.envName;
        ContainerExecRuntimeConfig containerConfig = new ContainerExecConfigSelector().selectForML_autoTXN(authCtx, fmi.getProjectKey(), coreParams.executionParams.containerSelection, coreParams.backendType);
        this.runsInContainer = containerConfig != null;
        this.link = new SingleCommandKernelLink(SecretKeyGenerator.generate((int)16), ApplicationConfigurator.getPortRangeParams(), this.runsInContainer ? EncryptedRPC.getSSLContext() : null);
        if (!this.runsInContainer) {
            this.kernel = new AnalysisMLKernel(this.link, null, fmi.getProjectKey(), envName, authCtx, fmi.getModelFolder());
        } else {
            AnalysisMLContainerKernel containerKernel = new AnalysisMLContainerKernel(this.link, null, fmi.getProjectKey(), envName, authCtx, fmi.getPreprocessingFolder(), MLPaths.getContextDir(fmi), containerConfig, "ts-interactive-scoring-");
            containerKernel.setExecutionType(RemoteRunsRegistry.ExecutionType.ML_INTERACTIVE_SCORING);
            this.kernel = containerKernel;
        }
        this.kernel.setPythonModule(pythonModule);
    }

    public synchronized void startIfNeeded() throws Exception {
        if (!this.started) {
            this.start();
            this.started = true;
        }
    }

    private synchronized void start() throws Exception {
        try (FutureProgress.AutocloseableFutureProgressState fp = FutureProgress.pushAutoCloseableState((String)"Initializing computation engine", (double)1.0, (FutureProgressState.StateUnit)FutureProgressState.StateUnit.NONE);){
            FutureProgress.updateState((double)0.0);
            logger.info((Object)("Starting kernel with user id " + this.authCtx.getIdentifier() + " and model id " + this.fmi.getModelId()));
            this.kernel.start();
            if (!this.runsInContainer) {
                FilesystemACLUtils.grantFSFullACLs(this.authCtx, this.fmi.getProjectKey(), this.fmi.getModelFolder());
            }
            FutureProgress.updateState((double)1.0);
        }
        catch (Exception e) {
            this.close();
            throw new CodedException((InfoMessage.MessageCode)InfoMessage.GenericCodes.ERR_UNKNOWN, "Timeseries Interactive Scoring Python kernel failed to start", (Throwable)e);
        }
    }

    @Override
    public synchronized void close() throws IOException {
        logger.info((Object)"Killing Timeseries Interactive Scoring kernel");
        try {
            this.link.close();
        }
        catch (IOException e) {
            logger.error((Object)"Could not close Javalink", (Throwable)e);
        }
    }

    public void killKernel() throws IOException {
        try {
            this.kernel.abort();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new IOException("Interrupted while killing python kernel", e);
        }
    }

    public synchronized TimeseriesInteractiveScoringScenarios create(JsonObject params) throws Exception {
        Map<String, Object> callableParams = TimeseriesInteractiveScoringKernel.getCallableParams(this.fmi, params);
        TimeseriesInteractiveScoringResponse response = new TimeseriesInteractiveScoringResponse();
        try {
            this.link.sendRequest((Object)new ArbitraryCommand(CREATE_COMMAND, JSON.pretty(callableParams)));
            response = (TimeseriesInteractiveScoringResponse)this.link.receiveJsonResponse(TimeseriesInteractiveScoringResponse.class);
        }
        catch (SocketBlockLinkException e) {
            logger.error((Object)e.getMessage());
            throw this.kernel.maybeRethrowAsProcessDied((IOException)((Object)e.withLogTail((IDSSKernelBase)this.kernel)));
        }
        catch (IOException e) {
            throw this.kernel.maybeRethrowAsProcessDied((IOException)((Object)new SocketBlockLinkIOException("Failed to run kernel computation", (Throwable)e).withLogTail((IDSSKernelBase)this.kernel)));
        }
        if (response.error != null) {
            throw new SocketBlockLinkKernelException("Could not compute " + CREATE_COMMAND, response.error).withLogTail((IDSSKernelBase)this.kernel);
        }
        return response.scenarios;
    }

    public synchronized TimeseriesEvaluationForecasts.TimeseriesScenariosForecasts compute(JsonObject params) throws Exception {
        TimeseriesInteractiveScoringResponse response;
        Map<String, Object> callableParams = TimeseriesInteractiveScoringKernel.getCallableParams(this.fmi, params);
        try {
            this.link.sendRequest((Object)new ArbitraryCommand(COMPUTE_COMMAND, JSON.pretty(callableParams)));
            response = (TimeseriesInteractiveScoringResponse)this.link.receiveJsonResponse(TimeseriesInteractiveScoringResponse.class);
        }
        catch (SocketBlockLinkException e) {
            logger.error((Object)e.getMessage());
            throw this.kernel.maybeRethrowAsProcessDied((IOException)((Object)e.withLogTail((IDSSKernelBase)this.kernel)));
        }
        catch (IOException e) {
            throw this.kernel.maybeRethrowAsProcessDied((IOException)((Object)new SocketBlockLinkIOException("Failed to run kernel computation", (Throwable)e).withLogTail((IDSSKernelBase)this.kernel)));
        }
        if (response.error != null) {
            throw new SocketBlockLinkKernelException("Could not compute " + COMPUTE_COMMAND, response.error).withLogTail((IDSSKernelBase)this.kernel);
        }
        return response.forecasts;
    }

    @NotNull
    private static Map<String, Object> getCallableParams(FullModelId fmi, JsonObject computationParams) throws IOException {
        HashMap<String, Object> callableParams = new HashMap<String, Object>();
        ResolvedCoreParams coreParams = fmi.getResolvedCoreParams();
        callableParams.put("split_desc", fmi.getSplitDesc());
        callableParams.put("core_params", coreParams);
        callableParams.put("model_folder", fmi.getModelFolder().getAbsolutePath());
        callableParams.put("preprocessing_folder", fmi.getPreprocessingFolder().getAbsolutePath());
        callableParams.put("split_folder", fmi.getSplitFolder().getAbsolutePath());
        callableParams.put("computation_params", computationParams);
        return callableParams;
    }

    @Override
    public boolean isAlive() {
        return !this.kernel.isAborted() && !this.kernel.isFinished();
    }

    static class TimeseriesInteractiveScoringResponse {
        public SocketBlockLinkInteraction.SocketBlockLinkKernelError error;
        TimeseriesInteractiveScoringScenarios scenarios;
        TimeseriesEvaluationForecasts.TimeseriesScenariosForecasts forecasts;

        TimeseriesInteractiveScoringResponse() {
        }
    }

    static class ArbitraryCommand {
        String type;
        String params;

        ArbitraryCommand(String type, String params) {
            this.type = type;
            this.params = params;
        }
    }
}

