/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.analysis.ml.timeseries;

import com.dataiku.dip.DKUApp;
import com.dataiku.dip.analysis.coreservices.CacheableKernelService;
import com.dataiku.dip.analysis.ml.FullModelId;
import com.dataiku.dip.analysis.ml.ModelLikeId;
import com.dataiku.dip.analysis.ml.timeseries.TimeseriesInteractiveScoringKernel;
import com.dataiku.dip.analysis.model.prediction.TimeseriesEvaluationForecasts;
import com.dataiku.dip.analysis.model.prediction.TimeseriesInteractiveScoringScenarios;
import com.dataiku.dip.futures.FutureAborter;
import com.dataiku.dip.futures.FuturePayload;
import com.dataiku.dip.futures.FutureProgress;
import com.dataiku.dip.futures.FutureProgressState;
import com.dataiku.dip.futures.FutureResponse;
import com.dataiku.dip.futures.FutureService;
import com.dataiku.dip.futures.SimpleFutureThread;
import com.dataiku.dip.io.AlivenessCheckableAndClosable;
import com.dataiku.dip.resourceusage.ComputeResourceUsageContext;
import com.dataiku.dip.resourceusage.CurrentComputeResourceUsageContext;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.DSSAuthCtx;
import com.dataiku.dip.utils.Pair;
import com.google.gson.JsonObject;
import com.google.gson.reflect.TypeToken;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class TimeseriesInteractiveScoringService
extends CacheableKernelService {
    @Autowired
    FutureService futureService;

    public FutureResponse<TimeseriesInteractiveScoringScenarios> createTimeseriesInteractiveScoring_NT(DSSAuthCtx user, ModelLikeId mle, JsonObject computationParams) throws Exception {
        TimeseriesInteractiveScoringCreationFutureThread thread = new TimeseriesInteractiveScoringCreationFutureThread(user, mle, computationParams);
        return this.futureService.runFuture(thread, 0L, thread.getTypeToken());
    }

    public FutureResponse<TimeseriesEvaluationForecasts.TimeseriesScenariosForecasts> computeTimeseriesInteractiveScoring_NT(DSSAuthCtx user, ModelLikeId mle, JsonObject computationParams) throws Exception {
        TimeseriesInteractiveScoringComputationFutureThread thread = new TimeseriesInteractiveScoringComputationFutureThread(user, mle, computationParams);
        return this.futureService.runFuture(thread, 0L, thread.getTypeToken());
    }

    @Override
    protected int getKernelCacheExpirationTimeInSeconds() {
        return DKUApp.getParams().getIntParam("dku.ml.timeseries_interactive_scoring.kernel.expirationTimeS", Integer.valueOf(600));
    }

    class TimeseriesInteractiveScoringCreationFutureThread
    extends BaseTimeseriesInteractiveScoringFutureThread<TimeseriesInteractiveScoringScenarios> {
        public TimeseriesInteractiveScoringCreationFutureThread(DSSAuthCtx user, ModelLikeId mle, JsonObject computationParams) {
            super(user, mle, computationParams);
        }

        @Override
        protected TimeseriesInteractiveScoringScenarios computeResult(TimeseriesInteractiveScoringKernel kernel, JsonObject computationParams) throws Exception {
            return kernel.create(computationParams);
        }

        @Override
        public TypeToken<FutureResponse<TimeseriesInteractiveScoringScenarios>> getTypeToken() {
            return new TypeToken<FutureResponse<TimeseriesInteractiveScoringScenarios>>(){};
        }
    }

    class TimeseriesInteractiveScoringComputationFutureThread
    extends BaseTimeseriesInteractiveScoringFutureThread<TimeseriesEvaluationForecasts.TimeseriesScenariosForecasts> {
        public TimeseriesInteractiveScoringComputationFutureThread(DSSAuthCtx user, ModelLikeId mle, JsonObject computationParams) {
            super(user, mle, computationParams);
        }

        @Override
        protected TimeseriesEvaluationForecasts.TimeseriesScenariosForecasts computeResult(TimeseriesInteractiveScoringKernel kernel, JsonObject computationParams) throws Exception {
            return kernel.compute(computationParams);
        }

        @Override
        public TypeToken<FutureResponse<TimeseriesEvaluationForecasts.TimeseriesScenariosForecasts>> getTypeToken() {
            return new TypeToken<FutureResponse<TimeseriesEvaluationForecasts.TimeseriesScenariosForecasts>>(){};
        }
    }

    private static class TimeseriesInteractiveModelKernelBuilder
    implements CacheableKernelService.CacheableKernelBuilder {
        private final FullModelId fmi;

        public TimeseriesInteractiveModelKernelBuilder(FullModelId fmi) {
            this.fmi = fmi;
        }

        @Override
        public AlivenessCheckableAndClosable createKernel(AuthCtx authCtx) throws Exception {
            return new TimeseriesInteractiveScoringKernel(authCtx, this.fmi);
        }

        @Override
        public Pair<String, String> getKey(AuthCtx authCtx) {
            return new Pair((Object)authCtx.toString(), (Object)this.fmi.toString());
        }
    }

    abstract class BaseTimeseriesInteractiveScoringFutureThread<T>
    extends SimpleFutureThread<T> {
        protected final ModelLikeId mle;
        protected final JsonObject computationParams;
        protected T result;

        public BaseTimeseriesInteractiveScoringFutureThread(DSSAuthCtx user, ModelLikeId mle, JsonObject computationParams) {
            super((AuthCtx)user);
            this.mle = mle;
            this.computationParams = computationParams;
        }

        @Override
        public T getResult() {
            return this.result;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public T compute() throws Exception {
            TimeseriesInteractiveModelKernelBuilder builder = new TimeseriesInteractiveModelKernelBuilder(this.mle.getUnderlyingModel());
            try (FutureAborter.AutoCloseableAbortHook ignored = FutureAborter.pushAutoCloseableHook(() -> {
                try {
                    ((TimeseriesInteractiveScoringKernel)TimeseriesInteractiveScoringService.this.acquireKernel(this.owner, builder)).killKernel();
                }
                catch (Exception e) {
                    logger.warn((Object)"Error while aborting interactive scoring kernel", (Throwable)e);
                }
            });){
                TimeseriesInteractiveScoringKernel kernel;
                ComputeResourceUsageContext cruContext = this.mle.getUnderlyingModel().getComputeResourceUsageContext(this.owner);
                CurrentComputeResourceUsageContext.setInCurrentThread((ComputeResourceUsageContext)cruContext);
                try {
                    kernel = (TimeseriesInteractiveScoringKernel)TimeseriesInteractiveScoringService.this.acquireKernel(this.owner, builder);
                    kernel.startIfNeeded();
                }
                catch (Exception e) {
                    throw new RuntimeException("Could not start Python kernel", e);
                }
                try (FutureProgress.AutocloseableFutureProgressState ignored1 = FutureProgress.pushAutoCloseableState((String)"Computing", (double)1.0, (FutureProgressState.StateUnit)FutureProgressState.StateUnit.NONE);){
                    this.result = this.computeResult(kernel, this.computationParams);
                }
            }
            finally {
                CurrentComputeResourceUsageContext.clear();
            }
            return this.result;
        }

        protected abstract T computeResult(TimeseriesInteractiveScoringKernel var1, JsonObject var2) throws Exception;

        public FuturePayload getPayload() {
            return this.mle.buildPostComputationFuturePayload();
        }

        @Override
        public double getDangerosity() {
            return 0.0;
        }

        public abstract TypeToken<FutureResponse<T>> getTypeToken();
    }
}

