/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.businessapps;

import com.dataiku.common.server.SerializedError;
import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.DKUApp;
import com.dataiku.dip.DSSTempUtils;
import com.dataiku.dip.ProxySettings;
import com.dataiku.dip.businessapps.BusinessAppCodes;
import com.dataiku.dip.businessapps.BusinessAppInstallService;
import com.dataiku.dip.businessapps.BusinessAppsDAO;
import com.dataiku.dip.businessapps.BusinessAppsService;
import com.dataiku.dip.businessapps.model.BusinessApp;
import com.dataiku.dip.businessapps.model.StoreBusinessAppsList;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.exceptions.CodedException;
import com.dataiku.dip.futures.FuturePayload;
import com.dataiku.dip.futures.FutureResponse;
import com.dataiku.dip.futures.FutureService;
import com.dataiku.dip.futures.FutureThread;
import com.dataiku.dip.futures.SimpleFutureThread;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.DSSAuthCtx;
import com.dataiku.dip.security.PermissionsService;
import com.dataiku.dip.server.DSSUpdateServiceUtils;
import com.dataiku.dip.util.AutoDelete;
import com.dataiku.dip.util.HTTPClientUtils;
import com.dataiku.dip.util.RepeatingListFetcher;
import com.dataiku.dip.utils.DKUFileUtils;
import com.dataiku.dip.utils.DKUtils;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.utils.SmartLogTail;
import com.dataiku.j2ts.annotations.UIModel;
import com.google.common.collect.Maps;
import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class BusinessAppStoreService
extends RepeatingListFetcher<StoreBusinessAppsList> {
    public static final String EXCLUDES_CONFIG = "dku.businessapps.excludes";
    @Autowired
    private BusinessAppsService businessAppsService;
    @Autowired
    private BusinessAppInstallService businessAppInstallService;
    @Autowired
    private FutureService futureService;
    @Autowired
    private PermissionsService permissionsService;
    private static final Logger logger = Logger.getLogger((String)"dku.businessapp.store");

    public static File getBusinessAppArchive(File tmpDir) {
        return new File(tmpDir, "business-application.zip");
    }

    public BusinessAppStoreService() {
        super(DSSUpdateServiceUtils.getBusinessApplicationsListURL(), logger, StoreBusinessAppsList.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void fetchNow(Map<String, String> specialHeaders) {
        SerializedError localFetchException;
        super.fetchNow(specialHeaders);
        BusinessAppStoreService businessAppStoreService = this;
        synchronized (businessAppStoreService) {
            localFetchException = this.fetchException;
        }
        if (localFetchException != null) {
            StoreBusinessAppsList localFetchedList;
            try {
                localFetchedList = (StoreBusinessAppsList)JSON.parseFile((File)DKUApp.getResourceFile((String)"business-apps-list.json"), StoreBusinessAppsList.class);
                this.filterListItems((StoreBusinessAppsList)this.fetchedList);
            }
            catch (IOException e) {
                logger.warn((Object)"Cannot parse Business Applications configuration", (Throwable)e);
                localFetchedList = null;
            }
            businessAppStoreService = this;
            synchronized (businessAppStoreService) {
                this.fetchedList = localFetchedList;
            }
        }
    }

    @Override
    public void filterListItems(StoreBusinessAppsList fetchedList) {
        String excludes = DKUApp.getProperty((String)EXCLUDES_CONFIG, null);
        if (StringUtils.isBlank((String)excludes)) {
            return;
        }
        BusinessAppStoreService.filterList(fetchedList, excludes);
    }

    private static void filterList(StoreBusinessAppsList fetchedList, String excludes) {
        Set<String> names = Set.of(excludes.split(","));
        fetchedList.items = fetchedList.items.stream().filter(item -> {
            if (item.id == null) {
                return true;
            }
            return !names.contains(item.id);
        }).collect(Collectors.toList());
    }

    public void forceFetch(AuthCtx authCtx) {
        this.fetchNow(this.settingsService.getCustomHeadersForTracking(authCtx));
    }

    public List<BusinessAppInfo> getUsableList(AuthCtx authCtx) throws CodedException, IOException {
        if (!this.businessAppsService.areBusinessAppsAllowed()) {
            return new ArrayList<BusinessAppInfo>();
        }
        return this.businessAppsService.list(BusinessAppsDAO.ReadOption.READ_DESCRIPTOR, BusinessAppsDAO.ReadOption.READ_SETTINGS).stream().filter(app -> this.permissionsService.hasBusinessAppPrivilege(authCtx, app.settings, BusinessAppsService.BusinessAppPrivilegeType.USE)).map(app -> new BusinessAppInfo(app.desc.id, app.desc.name)).toList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BusinessAppsStateList getStateList() throws CodedException, IOException {
        StoreBusinessAppsList localFetchList;
        BusinessAppsStateList ret = new BusinessAppsStateList();
        for (BusinessApp installedApp : this.businessAppsService.list(new BusinessAppsDAO.ReadOption[0])) {
            ret.businessApps.add(BusinessAppStateInfo.fromInstalled(installedApp));
        }
        BusinessAppStoreService businessAppStoreService = this;
        synchronized (businessAppStoreService) {
            ret.couldFetch = this.fetchedList != null && this.fetchException == null;
            localFetchList = (StoreBusinessAppsList)this.fetchedList;
            ret.fetchError = this.fetchException;
        }
        if (localFetchList != null) {
            for (StoreBusinessAppsList.StoreBusinessApp fetchedApp : localFetchList.items) {
                boolean isInstalled = false;
                ++ret.businessAppsNumberInStore;
                for (BusinessAppStateInfo stateInfo : ret.businessApps) {
                    if (!stateInfo.id.equals(fetchedApp.id)) continue;
                    stateInfo.addStoreData(fetchedApp);
                    isInstalled = true;
                }
                if (isInstalled) continue;
                ret.businessApps.add(BusinessAppStateInfo.fromStoreData(fetchedApp));
            }
        }
        return ret;
    }

    public BusinessAppStateInfo getMandatory(String businessAppId) throws Exception {
        Optional<StoreBusinessAppsList.StoreBusinessApp> storeBusinessAppDesc = this.getStoreBusinessAppDesc(businessAppId);
        BusinessApp installedApp = this.businessAppsService.getMandatory(businessAppId, new BusinessAppsDAO.ReadOption[0]);
        BusinessAppStateInfo businessAppInfo = BusinessAppStateInfo.fromInstalled(installedApp);
        storeBusinessAppDesc.ifPresent(businessAppInfo::addStoreData);
        return businessAppInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean exists(String businessAppId) {
        StoreBusinessAppsList localFetchList;
        BusinessAppStoreService businessAppStoreService = this;
        synchronized (businessAppStoreService) {
            localFetchList = (StoreBusinessAppsList)this.fetchedList;
        }
        if (localFetchList != null) {
            return localFetchList.items.stream().anyMatch(item -> item.id.equals(businessAppId));
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Optional<StoreBusinessAppsList.StoreBusinessApp> getStoreBusinessAppDesc(String businessAppId) {
        StoreBusinessAppsList localFetchList;
        BusinessAppStoreService businessAppStoreService = this;
        synchronized (businessAppStoreService) {
            localFetchList = (StoreBusinessAppsList)this.fetchedList;
        }
        if (localFetchList != null) {
            return localFetchList.items.stream().filter(item -> item.id.equals(businessAppId)).findFirst();
        }
        return Optional.empty();
    }

    public static FuturePayload buildFutureInstallPayload(String businessAppId, boolean update) {
        FuturePayload fp = new FuturePayload();
        fp.action = "business_app_install";
        fp.targets.add(new FuturePayload.FuturePayloadTarget(businessAppId, "BUSINESS_APP"));
        fp.withExtra("update", (Object)update);
        fp.displayName = (update ? "Updating" : "Installing") + " Business Application";
        return fp;
    }

    private void installAndActivate(File file, AuthCtx user, InstallationResult ret) {
        try {
            if (file.isDirectory()) {
                throw new IOException("Expected a zip file but got a directory: " + file.getAbsolutePath());
            }
            String businessAppId = this.businessAppInstallService.installFromZip(file, user);
            logger.debug((Object)"Installation done");
            ret.businessApp = this.businessAppsService.getMandatory(businessAppId, new BusinessAppsDAO.ReadOption[0]);
            ret.success = true;
            logger.info((Object)("Business Application installation completed: " + businessAppId));
            ret.messages.withSuccess((InfoMessage.MessageCode)BusinessAppCodes.INFO_BUSINESS_APP_INSTALL_OK, "Business Application installation complete " + businessAppId);
        }
        catch (Exception ex) {
            logger.error((Object)"Business Application installation failed", (Throwable)ex);
            ret.success = false;
            ret.installationError = new SerializedError((Throwable)ex, !ApplicationConfigurator.hideErrorStacks(), !ApplicationConfigurator.hideErrorStacks(), !ApplicationConfigurator.hideLogTails());
            ret.errorMessage = "Could not install the Business Application";
        }
    }

    public InstallationResult installUploaded(AuthCtx user, File file) {
        InstallationResult result = new InstallationResult();
        this.installAndActivate(file, user, result);
        return result;
    }

    public FutureResponse<InstallationResult> downloadAndInstall(String businessAppId, AuthCtx authCtx) throws Exception {
        this.businessAppsService.checkBusinessAppsAllowedOrThrow();
        boolean update = this.businessAppsService.exists(businessAppId);
        InstallFromStoreFutureThread ft = new InstallFromStoreFutureThread(businessAppId, (DSSAuthCtx)authCtx, update);
        return this.futureService.runFuture(ft, 50L, new TypeToken<FutureResponse<InstallationResult>>(){});
    }

    public FutureResponse<InstallationResult> startUploadAndInstall(AutoDelete tmpDir, AuthCtx authCtx) throws Exception {
        this.businessAppsService.checkBusinessAppsAllowedOrThrow();
        InstallFromUploadSimpleFutureThread ft = new InstallFromUploadSimpleFutureThread(tmpDir, authCtx);
        return this.futureService.runFuture(ft, 0L, new TypeToken<FutureResponse<InstallationResult>>(){});
    }

    public static class BusinessAppsStateList {
        public List<BusinessAppStateInfo> businessApps = new ArrayList<BusinessAppStateInfo>();
        public boolean couldFetch;
        public SerializedError fetchError;
        public int businessAppsNumberInStore;
    }

    public static class BusinessAppStateInfo {
        public final String id;
        public boolean inStore;
        public StoreBusinessAppsList.StoreBusinessApp storeDesc;
        public final boolean installed;
        public final BusinessApp installedDesc;

        private BusinessAppStateInfo(String id, boolean installed, boolean inStore, BusinessApp installedDesc, StoreBusinessAppsList.StoreBusinessApp storeDesc) {
            this.id = id;
            this.installed = installed;
            this.inStore = inStore;
            this.installedDesc = installedDesc;
            this.storeDesc = storeDesc;
        }

        public static BusinessAppStateInfo fromStoreData(StoreBusinessAppsList.StoreBusinessApp storeDesc) {
            return new BusinessAppStateInfo(storeDesc.id, false, true, null, storeDesc);
        }

        public static BusinessAppStateInfo fromInstalled(BusinessApp installedBusinessAppDesc) {
            return new BusinessAppStateInfo(installedBusinessAppDesc.desc.id, true, false, installedBusinessAppDesc, null);
        }

        public void addStoreData(StoreBusinessAppsList.StoreBusinessApp storeDesc) {
            this.storeDesc = storeDesc;
            this.inStore = true;
        }
    }

    public static class InstallationResult {
        public boolean success;
        public SerializedError installationError;
        public String errorMessage;
        public BusinessApp businessApp;
        public InfoMessage.InfoMessages messages = new InfoMessage.InfoMessages();
    }

    private class InstallFromStoreFutureThread
    extends FutureThread<InstallationResult> {
        private final InstallationResult result;
        private final String businessAppId;
        private final ProxySettings proxySettings;
        private final FuturePayload futurePayload;
        final DKUtils.SmartLogTailBuilder logTailBuilder;

        public InstallFromStoreFutureThread(String businessAppId, DSSAuthCtx authCtx, boolean update) {
            super(authCtx);
            this.result = new InstallationResult();
            this.logTailBuilder = new DKUtils.SmartLogTailBuilder();
            this.businessAppId = businessAppId;
            this.proxySettings = ApplicationConfigurator.getProxySettings();
            this.futurePayload = BusinessAppStoreService.buildFutureInstallPayload(businessAppId, update);
        }

        public FuturePayload getPayload() {
            return this.futurePayload;
        }

        public InstallationResult getResult() {
            return this.result;
        }

        public SmartLogTail getLog() {
            return this.logTailBuilder.get();
        }

        public double getDangerosity() {
            return 0.0;
        }

        public void execute() {
            AutoDelete tempFile;
            InstallationResult ret = this.result;
            Map<String, StoreBusinessAppsList.StoreBusinessApp> latestFetchedBusinessApps = this.getFetchedAsMap();
            try {
                if (!latestFetchedBusinessApps.containsKey(this.businessAppId)) {
                    throw new CodedException((InfoMessage.MessageCode)BusinessAppCodes.ERR_BUSINESS_APP_NOT_INSTALLED, "Business Application has since been removed from the store.");
                }
                logger.info((Object)("Installing from Business Application store: " + this.businessAppId));
                StoreBusinessAppsList.StoreBusinessApp storeBusinessApp = latestFetchedBusinessApps.get(this.businessAppId);
                logger.info((Object)("Downloading from " + storeBusinessApp.downloadURL));
                tempFile = DSSTempUtils.getTempFile((String)"business-app-download", (String)this.businessAppId, (String)"zip");
                HTTPClientUtils.downloadToFile((String)storeBusinessApp.downloadURL, (File)tempFile, BusinessAppStoreService.this.settingsService.getCustomHeadersForTracking(this.owner), (ProxySettings)this.proxySettings);
                logger.info((Object)"Download complete");
            }
            catch (Exception e) {
                ret.success = false;
                ret.installationError = new SerializedError((Throwable)e, !ApplicationConfigurator.hideErrorStacks(), !ApplicationConfigurator.hideErrorStacks(), !ApplicationConfigurator.hideLogTails());
                ret.errorMessage = "Could not fetch the Business Application";
                logger.error((Object)("Could not fetch the Business Application: " + this.businessAppId), (Throwable)e);
                return;
            }
            BusinessAppStoreService.this.installAndActivate((File)tempFile, this.owner, ret);
            try {
                if (tempFile.exists()) {
                    DKUFileUtils.forceDelete((File)tempFile);
                }
            }
            catch (Exception e) {
                logger.warn((Object)"Failed to delete the downloaded Business Application file", (Throwable)e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Map<String, StoreBusinessAppsList.StoreBusinessApp> getFetchedAsMap() {
            StoreBusinessAppsList localFetchedList;
            BusinessAppStoreService businessAppStoreService = BusinessAppStoreService.this;
            synchronized (businessAppStoreService) {
                localFetchedList = (StoreBusinessAppsList)BusinessAppStoreService.this.fetchedList;
            }
            HashMap map = Maps.newHashMap();
            if (localFetchedList != null) {
                for (StoreBusinessAppsList.StoreBusinessApp fetchedBusinessApp : localFetchedList.items) {
                    map.put(fetchedBusinessApp.id, fetchedBusinessApp);
                }
            }
            return map;
        }
    }

    private class InstallFromUploadSimpleFutureThread
    extends SimpleFutureThread<InstallationResult> {
        private final AutoDelete tmpDir;
        private final FuturePayload futurePayload;
        private final DKUtils.SmartLogTailBuilder logTailBuilder;

        InstallFromUploadSimpleFutureThread(AutoDelete tmpDir, AuthCtx authCtx) {
            super(authCtx);
            this.logTailBuilder = new DKUtils.SmartLogTailBuilder();
            this.tmpDir = tmpDir;
            this.futurePayload = BusinessAppStoreService.buildFutureInstallPayload(null, false);
        }

        @Override
        protected InstallationResult compute() {
            return BusinessAppStoreService.this.installUploaded(this.owner, BusinessAppStoreService.getBusinessAppArchive((File)this.tmpDir));
        }

        public FuturePayload getPayload() {
            return this.futurePayload;
        }

        public SmartLogTail getLog() {
            return this.logTailBuilder.get();
        }

        public void postRunCleanup() {
            this.tmpDir.close();
        }
    }

    @UIModel
    public static class BusinessAppInfo {
        public String id;
        public String name;

        public BusinessAppInfo(String id, String name) {
            this.id = id;
            this.name = name;
        }
    }
}

