/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.businessapps;

import com.dataiku.common.server.SerializedError;
import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.businessapps.BusinessAppCodeEnvUtils;
import com.dataiku.dip.businessapps.BusinessAppCodes;
import com.dataiku.dip.businessapps.BusinessAppStoreService;
import com.dataiku.dip.businessapps.BusinessAppsCreateInstanceService;
import com.dataiku.dip.businessapps.BusinessAppsDAO;
import com.dataiku.dip.businessapps.BusinessAppsUpgradeInstanceService;
import com.dataiku.dip.businessapps.model.BusinessApp;
import com.dataiku.dip.businessapps.model.BusinessAppInstanceSettings;
import com.dataiku.dip.businessapps.model.BusinessAppSettings;
import com.dataiku.dip.businessapps.model.CreateOrUpgradeInstanceParams;
import com.dataiku.dip.businessapps.model.CreateOrUpgradeInstanceResult;
import com.dataiku.dip.code.AutomationNodeCodeEnvsService;
import com.dataiku.dip.code.CodeEnvModel;
import com.dataiku.dip.code.DesignNodeCodeEnvsService;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.coremodel.SerializedProject;
import com.dataiku.dip.dao.UsersDAO;
import com.dataiku.dip.exceptions.CodedException;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.futures.FuturePayload;
import com.dataiku.dip.futures.FutureProgress;
import com.dataiku.dip.futures.FutureResponse;
import com.dataiku.dip.futures.FutureService;
import com.dataiku.dip.futures.FutureThread;
import com.dataiku.dip.license.LicenseRestrictionException;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.DSSAuthCtx;
import com.dataiku.dip.security.PermissionsService;
import com.dataiku.dip.security.Privileges;
import com.dataiku.dip.security.trust.FingerprintService;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.server.services.ProjectsService;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.server.services.UsersService;
import com.dataiku.dip.server.services.licensing.LicenseEnforcementService;
import com.dataiku.dip.transactions.ifaces.RWTransaction;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.utils.DKUFileUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.DKUtils;
import com.dataiku.dip.webapps.WebApp;
import com.dataiku.dip.webapps.WebAppsService;
import com.google.common.base.Joiner;
import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Priority;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class BusinessAppsService {
    @Autowired
    private BusinessAppsDAO businessAppsDAO;
    @Autowired
    private PermissionsService permissionsService;
    @Autowired
    private FutureService futureService;
    @Autowired
    private LicenseEnforcementService licenseEnforcementService;
    @Autowired
    private ProjectsService projectsService;
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private BusinessAppsCreateInstanceService businessAppsCreateInstanceService;
    @Autowired
    private BusinessAppsUpgradeInstanceService businessAppsUpgradeInstanceService;
    @Autowired
    private WebAppsService webAppsService;
    @Autowired
    private UsersService usersService;
    @Autowired
    private UsersDAO usersDAO;
    @Autowired
    private FingerprintService fingerprintService;
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.businessapps");

    public List<BusinessApp> list(BusinessAppsDAO.ReadOption ... options) throws CodedException, IOException {
        return this.businessAppsDAO.list(options).stream().filter(Objects::nonNull).toList();
    }

    public boolean exists(String businessAppId) throws Exception {
        return this.businessAppsDAO.getOrNull(businessAppId, BusinessAppsDAO.ReadOption.READ_DESCRIPTOR) != null;
    }

    public BusinessApp getMandatory(String businessAppId, BusinessAppsDAO.ReadOption ... options) throws IOException, CodedException {
        return this.businessAppsDAO.getMandatory(businessAppId, options);
    }

    public BusinessApp getOrNull(String businessAppId, BusinessAppsDAO.ReadOption ... options) throws IOException, CodedException {
        return this.businessAppsDAO.getOrNull(businessAppId, options);
    }

    public void saveSettings(String businessAppId, BusinessAppSettings settings) throws Exception {
        this.businessAppsDAO.saveSettings(businessAppId, settings);
    }

    public FutureResponse<BusinessAppStoreService.InstallationResult> delete(DSSAuthCtx authCtx, String businessAppId, boolean force) throws Exception {
        DeleteFutureThread ft = new DeleteFutureThread(authCtx, businessAppId, force);
        return this.futureService.runFuture(ft, 50L, new TypeToken<FutureResponse<BusinessAppStoreService.InstallationResult>>(){});
    }

    public List<SerializedProject> listInstancesUnsafe(AuthCtx authCtx, String businessAppId) throws IOException {
        return this.listInstancesUnsafe(businessAppId).stream().filter(sp -> this.hasProjectPrivilegeRead(authCtx, (SerializedProject)sp)).toList();
    }

    public FutureResponse<CreateOrUpgradeInstanceResult> createInstance(DSSAuthCtx authCtx, CreateOrUpgradeInstanceParams params) throws Exception {
        this.checkBusinessAppsAllowedOrThrow();
        return this.businessAppsCreateInstanceService.createInstance(authCtx, params);
    }

    public FutureResponse<CreateOrUpgradeInstanceResult> upgradeInstance(DSSAuthCtx authCtx, String businessAppId, String projectKey) throws Exception {
        this.checkBusinessAppsAllowedOrThrow();
        return this.businessAppsUpgradeInstanceService.upgradeInstance(authCtx, businessAppId, projectKey);
    }

    public SaveInstanceSettingsResult saveInstanceSettings(AuthCtx authCtx, String projectKey, BusinessAppInstanceSettings settings) throws Exception {
        SaveInstanceSettingsResult result = new SaveInstanceSettingsResult();
        SerializedProject sp = this.projectsService.getMandatoryUnsafe(projectKey);
        if (StringUtils.isBlank((String)sp.businessAppId) || sp.projectType != SerializedProject.ProjectType.BUSINESS_APP) {
            throw new IllegalArgumentException("The specified project is not a Business Application instance");
        }
        if (StringUtils.isNotBlank((String)sp.businessAppWebAppId)) {
            WebApp webApp = this.webAppsService.getMandatory(projectKey, sp.businessAppWebAppId);
            String runAs = webApp.params.runAs;
            if (!StringUtils.isBlank((String)settings.runAsLogin) && !settings.runAsLogin.equals(runAs)) {
                if (this.usersService.listUsersEnabledOnly_RestrictionCheck_NoLeak(authCtx).stream().noneMatch(u -> u.login.equals(settings.runAsLogin))) {
                    throw new IllegalStateException("The specified runAs user account does not exist, is deactivated or is not visible.");
                }
                webApp.params.runAs = settings.runAsLogin;
                this.webAppsService.save(webApp, false);
                result.modified = true;
                result.webAppId = sp.businessAppWebAppId;
                result.webAppFingerprint = this.computeWebAppFingerprint(webApp);
            }
        }
        return result;
    }

    private String computeWebAppFingerprint(WebApp webApp) throws IOException, DKUSecurityException {
        UsersDAO.User user = this.usersDAO.getMandatoryUnsafe(webApp.params.runAs);
        String fingerprint = this.fingerprintService.computeWebAppFingerprint(webApp, DSSAuthCtx.forUserLogin(user));
        return fingerprint;
    }

    public File getFolder(String businessAppId) {
        return BusinessAppsDAO.getInstalledBusinessAppFolder(businessAppId);
    }

    public void checkBusinessAppsAllowedOrThrow() throws LicenseRestrictionException {
        if (!this.areBusinessAppsAllowed()) {
            throw new LicenseRestrictionException("Your license does not allow you to use Business Applications");
        }
    }

    public boolean areBusinessAppsAllowed() {
        return this.licenseEnforcementService.getFeaturesStatus().businessAppsAllowed;
    }

    private List<SerializedProject> listInstancesUnsafe(String businessAppId) throws IOException {
        if (StringUtils.isBlank((String)businessAppId)) {
            return new ArrayList<SerializedProject>();
        }
        try (Transaction ignored = this.transactionService.retrieveOrBeginRead();){
            List<SerializedProject> list = this.projectsService.listAllUnsafe().stream().filter(sp -> !sp.projectKey.startsWith("__DKU_BUSINESS_APP_UPGRADE_INSTANCE__") && sp.projectType == SerializedProject.ProjectType.BUSINESS_APP && businessAppId.equals(sp.businessAppId)).toList();
            return list;
        }
    }

    private boolean hasProjectPrivilegeRead(AuthCtx authCtx, SerializedProject sp) {
        try {
            return this.permissionsService.hasProjectPrivilege(authCtx, sp, Privileges.ProjectLevelPrivilegeType.READ_CONF);
        }
        catch (DKUSecurityException e) {
            logger.warnV((Throwable)e, "Unable to determine project privilege for '%s' while listing instances of Business Application. Ignoring it.", new Object[]{sp.projectKey});
            return false;
        }
    }

    private static DesignNodeCodeEnvsService designNodeCodeEnvsService() {
        return (DesignNodeCodeEnvsService)SpringUtils.getBean(DesignNodeCodeEnvsService.class);
    }

    private static AutomationNodeCodeEnvsService automationNodeCodeEnvsService() {
        return (AutomationNodeCodeEnvsService)SpringUtils.getBean(AutomationNodeCodeEnvsService.class);
    }

    private class DeleteFutureThread
    extends FutureThread<BusinessAppStoreService.InstallationResult> {
        private final BusinessAppStoreService.InstallationResult result;
        private final String businessAppId;
        private final boolean force;
        private final DSSAuthCtx authCtx;
        private final FuturePayload futurePayload;

        public DeleteFutureThread(DSSAuthCtx authCtx, String businessAppId, boolean force) {
            super(authCtx);
            this.result = new BusinessAppStoreService.InstallationResult();
            this.businessAppId = businessAppId;
            this.force = force;
            this.authCtx = authCtx;
            this.futurePayload = this.buildFuturePayload(businessAppId);
        }

        public FuturePayload getPayload() {
            return this.futurePayload;
        }

        public BusinessAppStoreService.InstallationResult getResult() {
            return this.result;
        }

        public double getDangerosity() {
            return 0.0;
        }

        public void execute() {
            FutureProgress.AutocloseableFutureProgressState ignored;
            BusinessApp installedApp;
            block29: {
                BusinessAppStoreService.InstallationResult ret = this.result;
                try {
                    logger.info((Object)("Looking if Business Application with id " + this.businessAppId + " is installed"));
                    if (!BusinessAppsService.this.exists(this.businessAppId)) {
                        throw new CodedException((InfoMessage.MessageCode)BusinessAppCodes.ERR_BUSINESS_APP_NOT_INSTALLED, "Business Application '" + this.businessAppId + "' is not installed");
                    }
                    logger.infoV("Business Application %s found", new Object[]{this.businessAppId});
                }
                catch (Exception e) {
                    ret.success = false;
                    ret.installationError = new SerializedError((Throwable)e, !ApplicationConfigurator.hideErrorStacks(), !ApplicationConfigurator.hideErrorStacks(), !ApplicationConfigurator.hideLogTails());
                    ret.errorMessage = "Could not check if Business Application is installed";
                    return;
                }
                try {
                    ret.businessApp = installedApp = BusinessAppsService.this.getMandatory(this.businessAppId, new BusinessAppsDAO.ReadOption[0]);
                }
                catch (Exception ex) {
                    ret.success = false;
                    ret.installationError = new SerializedError((Throwable)ex, !ApplicationConfigurator.hideErrorStacks(), !ApplicationConfigurator.hideErrorStacks(), !ApplicationConfigurator.hideLogTails());
                    ret.errorMessage = "Could not load Business Application desc";
                    return;
                }
                try {
                    ignored = FutureProgress.pushAutoCloseableState((String)"Deleting instances");
                    try {
                        List<SerializedProject> instances = BusinessAppsService.this.listInstancesUnsafe(this.businessAppId);
                        if (instances.isEmpty()) break block29;
                        if (!this.force) {
                            throw new IllegalStateException(String.format("Business Application %s has %d instances. Try again with the force option or delete instances first.", this.businessAppId, instances.size()));
                        }
                        logger.infoV("Deleting %d Business Application instances.", new Object[]{instances.size()});
                        for (SerializedProject sp : instances) {
                            RWTransaction rwt = BusinessAppsService.this.transactionService.beginWriteAsLoggedInUser((AuthCtx)this.owner);
                            try {
                                BusinessAppsService.this.projectsService.deleteProject(this.owner, sp.projectKey);
                                rwt.commit("Deleted Business Application instance " + sp.projectKey);
                            }
                            finally {
                                if (rwt == null) continue;
                                rwt.close();
                            }
                        }
                        logger.info((Object)"Deleted all Business Application instances.");
                    }
                    finally {
                        if (ignored != null) {
                            ignored.close();
                        }
                    }
                }
                catch (Exception ex) {
                    ret.success = false;
                    ret.installationError = new SerializedError((Throwable)ex, !ApplicationConfigurator.hideErrorStacks(), !ApplicationConfigurator.hideErrorStacks(), !ApplicationConfigurator.hideLogTails());
                    ret.errorMessage = "Could not delete all instances of the Business Application";
                    logger.error((Object)"Failed to delete a Business Application instance", (Throwable)ex);
                    return;
                }
            }
            if (!StringUtils.isBlank((String)installedApp.desc.codeEnvName) && installedApp.codeEnvExist) {
                this.handleCodeEnvRemoval(installedApp);
            }
            try {
                ignored = FutureProgress.pushAutoCloseableState((String)"Deleting application");
                try {
                    File installedBusinessAppFolder = BusinessAppsDAO.getInstalledBusinessAppFolder(this.businessAppId);
                    DKUFileUtils.forceDelete((File)installedBusinessAppFolder);
                    logger.info((Object)("Removed Business Application directory " + installedBusinessAppFolder.getCanonicalPath()));
                }
                finally {
                    if (ignored != null) {
                        ignored.close();
                    }
                }
            }
            catch (IOException ex) {
                ret.success = false;
                ret.installationError = new SerializedError((Throwable)ex, !ApplicationConfigurator.hideErrorStacks(), !ApplicationConfigurator.hideErrorStacks(), !ApplicationConfigurator.hideLogTails());
                ret.errorMessage = "Could not delete the directory of the Business Application";
                logger.error((Object)"Deletion of Business Application directory failed", (Throwable)ex);
                return;
            }
            ret.success = true;
        }

        private void handleCodeEnvRemoval(BusinessApp installedApp) {
            String codeEnvName = installedApp.desc.codeEnvName;
            CodeEnvModel.EnvLang codeEnvLang = installedApp.codeEnvLang;
            boolean codeEnvExists = false;
            try {
                codeEnvExists = BusinessAppCodeEnvUtils.codeEnvExistsForBusinessApp(codeEnvLang, codeEnvName);
            }
            catch (Exception e) {
                logger.error((Object)"Exception accessing associated code env. Will not try to remove it.", (Throwable)e);
            }
            if (!codeEnvExists) {
                logger.infoV("Code env associated to Business Application %s does not exist or is not managed by the Business Application. Not deleting it.", new Object[]{this.businessAppId});
            } else {
                try {
                    BusinessAppsService.this.permissionsService.checkCodeEnvPrivileges(this.authCtx, codeEnvLang, codeEnvName, Privileges.CodeEnvLevelPrivilegeType.MANAGE_USERS);
                    DKUtils.SmartLogTailBuilder logTailBuilder = new DKUtils.SmartLogTailBuilder();
                    CodeEnvModel.EnvDeletionResult edr = switch (ApplicationConfigurator.getNodeType()) {
                        case ApplicationConfigurator.DSSNodeType.AUTOMATION -> BusinessAppsService.automationNodeCodeEnvsService().doDeleteCodeEnv(codeEnvLang, codeEnvName, this.authCtx, logTailBuilder);
                        case ApplicationConfigurator.DSSNodeType.DESIGN -> BusinessAppsService.designNodeCodeEnvsService().doDeleteCodeEnv(codeEnvLang, codeEnvName, this.authCtx, logTailBuilder);
                        default -> throw new IllegalArgumentException("No code envs on nodes of type " + String.valueOf((Object)ApplicationConfigurator.getNodeType()));
                    };
                    if (!edr.messages.messages.isEmpty()) {
                        edr.messages.summarize();
                        assert (edr.messages.maxSeverity != null);
                        InfoMessage.Severity s = switch (edr.messages.maxSeverity) {
                            default -> throw new IncompatibleClassChangeError();
                            case InfoMessage.Severity.ERROR -> InfoMessage.Severity.ERROR;
                            case InfoMessage.Severity.WARNING -> InfoMessage.Severity.WARNING;
                            case InfoMessage.Severity.INFO -> InfoMessage.Severity.INFO;
                            case InfoMessage.Severity.SUCCESS -> InfoMessage.Severity.SUCCESS;
                        };
                        logger.log((Priority)s.logLevel, (Object)("On deletion of code env associated to Business Application " + this.businessAppId + ":" + edr.messages.report()));
                        String smartLog = Joiner.on((String)"\n").join((Iterable)logTailBuilder.get().getLines());
                        logger.log((Priority)s.logLevel, (Object)("On deletion of code env associated to Business Application " + this.businessAppId + ":" + smartLog));
                    }
                }
                catch (DKUSecurityException e) {
                    logger.warnV((Throwable)e, "Did not have the privileges to remove managed code env %s. Did not remove it.", new Object[]{codeEnvName});
                }
            }
        }

        private FuturePayload buildFuturePayload(String businessAppId) {
            FuturePayload fp = new FuturePayload();
            fp.action = "enterprise_app_delete";
            fp.targets.add(new FuturePayload.FuturePayloadTarget(businessAppId, "BUSINESS_APP"));
            fp.displayName = "Deleting Business Application";
            return fp;
        }
    }

    public static class SaveInstanceSettingsResult {
        public boolean modified;
        public String webAppId;
        public String webAppFingerprint;
    }

    public static enum BusinessAppPrivilegeType {
        USE,
        CREATE;

    }
}

