/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.charts.ai;

import com.dataiku.common.rpc.InternalAPIClient;
import com.dataiku.dip.aigenerations.AIGenerationService;
import com.dataiku.dip.dao.GeneralSettingsDAO;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.futures.FuturePayload;
import com.dataiku.dip.futures.FutureResponse;
import com.dataiku.dip.futures.FutureService;
import com.dataiku.dip.futures.SimpleFutureThread;
import com.dataiku.dip.license.LicenseStatusService;
import com.dataiku.dip.pivot.backend.model.ColumnSummary;
import com.dataiku.dip.pivot.frontend.model.ChartDef;
import com.dataiku.dip.pivot.frontend.model.ChartType;
import com.dataiku.dip.pivot.frontend.model.ChartVariant;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.util.AIFeaturesUtil;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.j2ts.annotations.UIModel;
import com.google.gson.reflect.TypeToken;
import java.io.IOException;
import java.util.List;
import java.util.Locale;
import org.apache.log4j.NDC;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.i18n.LocaleContext;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.stereotype.Service;

@Service
public class AIChartSuggestionService {
    @Autowired
    private FutureService futureService;
    private static final DKULogger logger = DKULogger.getLogger(AIChartSuggestionService.class);

    public FutureResponse<AIChartSuggestionsResponse> startGeneration(AIChartSuggestionsFutureThread futureThread) throws Exception {
        return this.futureService.runFuture(futureThread, 0L, new TypeToken<FutureResponse<AIChartSuggestionsResponse>>(){});
    }

    public static class AIChartSuggestionsFutureThread
    extends SimpleFutureThread<AIChartSuggestionsResponse> {
        private final GeneralSettingsDAO.GeneralSettings generalSettings;
        private final LicenseStatusService.LicensingStatus licensingStatus;
        private final String previousRequestId;
        private final List<ColumnSummary.UsableColumn> usableColumns;
        private final ChartDef existingDef;

        public AIChartSuggestionsFutureThread(AuthCtx owner, LicenseStatusService.LicensingStatus licensingStatus, String previousRequestId, List<ColumnSummary.UsableColumn> usableColumns, ChartDef existingDef, GeneralSettingsDAO.GeneralSettings generalSettings) {
            super(owner);
            this.licensingStatus = licensingStatus;
            this.previousRequestId = previousRequestId;
            this.usableColumns = usableColumns;
            this.existingDef = existingDef;
            this.generalSettings = generalSettings;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected AIChartSuggestionsResponse compute() throws Exception {
            NDC.push((String)"ai-chartsuggestions");
            try {
                AIChartSuggestionsQuery suggestionsQuery = this.createSuggestionsQuery();
                AIChartSuggestionsResponse aIChartSuggestionsResponse = this.requestAIServerBackendSuggestions(suggestionsQuery);
                return aIChartSuggestionsResponse;
            }
            catch (Exception e) {
                logger.error((Object)"Exception while generating AI chart suggestions", (Throwable)e);
                AIChartSuggestionsResponse finalResp = new AIChartSuggestionsResponse();
                finalResp.ok = false;
                AIChartSuggestionsResponse aIChartSuggestionsResponse = finalResp;
                return aIChartSuggestionsResponse;
            }
            finally {
                NDC.pop();
            }
        }

        private AIChartSuggestionsResponse requestAIServerBackendSuggestions(AIChartSuggestionsQuery suggestionsQuery) {
            AIChartSuggestionsResponse aIChartSuggestionsResponse;
            block11: {
                LocaleContext localeContext = LocaleContextHolder.getLocaleContext();
                Locale locale = localeContext != null ? localeContext.getLocale() : null;
                InternalAPIClient apiClient = AIFeaturesUtil.getAiServerAPIClient(this.getOwner(), this.generalSettings, AIFeaturesUtil.CONNECTION_TIMEOUT, AIFeaturesUtil.SOCKET_TIMEOUT);
                try {
                    if (locale != null) {
                        suggestionsQuery.locale = locale.getLanguage();
                    }
                    AIChartSuggestionBackendResponse resp = (AIChartSuggestionBackendResponse)apiClient.postObject("/text2chart/suggestions", AIChartSuggestionBackendResponse.class, (Object)suggestionsQuery);
                    AIChartSuggestionsResponse finalResp = new AIChartSuggestionsResponse();
                    finalResp.ok = true;
                    finalResp.reasoning = resp.reasoning;
                    finalResp.requestId = resp.requestId;
                    finalResp.aborted = resp.aborted;
                    finalResp.suggestions = resp.suggestions;
                    aIChartSuggestionsResponse = finalResp;
                    if (apiClient == null) break block11;
                }
                catch (Throwable resp) {
                    try {
                        if (apiClient != null) {
                            try {
                                apiClient.close();
                            }
                            catch (Throwable throwable) {
                                resp.addSuppressed(throwable);
                            }
                        }
                        throw resp;
                    }
                    catch (IOException e) {
                        logger.error((Object)"Exception while generating AI chart suggestions", (Throwable)e);
                        AIChartSuggestionsResponse finalResp = new AIChartSuggestionsResponse();
                        finalResp.ok = false;
                        return finalResp;
                    }
                    catch (DKUSecurityException e) {
                        logger.error((Object)"Security exception while generating suggestions", (Throwable)e);
                        AIChartSuggestionsResponse finalResp = new AIChartSuggestionsResponse();
                        finalResp.ok = false;
                        return finalResp;
                    }
                    catch (IllegalArgumentException e) {
                        logger.error((Object)"Configuration error while connecting to AI server", (Throwable)e);
                        AIChartSuggestionsResponse finalResp = new AIChartSuggestionsResponse();
                        finalResp.ok = false;
                        return finalResp;
                    }
                }
                apiClient.close();
            }
            return aIChartSuggestionsResponse;
        }

        private AIChartSuggestionsQuery createSuggestionsQuery() {
            AIChartSuggestionsQuery backendQueryBase = new AIChartSuggestionsQuery();
            backendQueryBase.licenseId = this.licensingStatus != null && this.licensingStatus.licenseContent != null ? this.licensingStatus.licenseContent.licenseId : null;
            backendQueryBase.telemetryEnabled = this.generalSettings.aiDrivenAnalyticsSettings.telemetryEnabled;
            backendQueryBase.usableColumns = this.usableColumns.stream().map(col -> new AIGenerationService.AIDatasetSchemaColumnInformation(col.column, col.type, "")).toList();
            backendQueryBase.previousRequestId = this.previousRequestId;
            backendQueryBase.existingDef = this.existingDef;
            return backendQueryBase;
        }

        public FuturePayload getPayload() {
            return FuturePayload.newSimple((String)"ai_chart_suggestions", (String)"AI Chart Suggestions");
        }
    }

    public static class AIChartSuggestionsQuery {
        public String previousRequestId;
        String licenseId;
        List<AIGenerationService.AIDatasetSchemaColumnInformation> usableColumns;
        ChartDef existingDef;
        boolean telemetryEnabled;
        String locale = "en";
    }

    public static class AIChartSuggestionBackendResponse {
        String requestId;
        String query;
        String reasoning;
        List<Suggestion> suggestions;
        boolean aborted;
    }

    @UIModel
    public static class AIChartSuggestionsResponse {
        public boolean ok;
        public boolean aborted;
        public String reasoning;
        public List<Suggestion> suggestions;
        public String requestId;
    }

    public static class Suggestion {
        public SuggestionType suggestionType;
        public ChartType type;
        public ChartVariant variant;
        public String suggestion;

        public static enum SuggestionType {
            DEFAULT,
            CHART_TYPE_RELATED,
            FILTER,
            FORMATTING;

        }
    }
}

