/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.codestudio.template;

import com.dataiku.dip.DKUApp;
import com.dataiku.dip.cluster.ClusterSelector;
import com.dataiku.dip.cluster.ContainerSettings;
import com.dataiku.dip.codestudio.template.CodeStudioTemplate;
import com.dataiku.dip.containers.exec.BaseImagesPusher;
import com.dataiku.dip.containers.exec.ContainerExecRuntimeConfig;
import com.dataiku.dip.containers.exec.ContainerExecUtils;
import com.dataiku.dip.containers.exec.ECRUtils;
import com.dataiku.dip.containers.exec.KubernetesExecUtils;
import com.dataiku.dip.containers.exec.WorkloadType;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.DKUtils;
import com.dataiku.dss.shadelib.com.google.common.collect.Streams;
import com.dataiku.dss.shadelib.org.apache.commons.io.FileUtils;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang.StringUtils;

public class CodeStudioTemplateImagesHandler {
    public static final String WORKDIR = "/opt/dataiku";
    public static final String CONDA_PACKAGES_FILE = "code-env/conda.packages.txt";
    public static final String PIP_PACKAGES_FILE = "code-env/pip.packages.txt";
    public static final String R_PACKAGES_FILE = "code-env/R.packages.txt";
    protected final CodeStudioTemplate template;
    protected final ContainerExecUtils.ContainerBuildConfig containerConfig;
    protected final Set<String> containerExecRuntimeConfigNames;
    protected final String imageName;
    protected final Collection<ContainerExecUtils.ContainerImagePush> pushes;
    private static DKULogger logger = DKULogger.getLogger((String)"dku.containers.imagebuilder");

    public static List<CodeStudioTemplateImagesHandler> getHandlers(CodeStudioTemplate template) throws IOException {
        ContainerSettings containerSettings = new ClusterSelector().selectGlobal().getContainerSettings();
        ArrayList<ContainerExecUtils.ContainerBaseConfig> configurations = new ArrayList<ContainerExecUtils.ContainerBaseConfig>();
        HashMultimap containerConfigNamesPerBuildConfig = HashMultimap.create();
        if (template.allContainerConfs) {
            List<ContainerExecRuntimeConfig> configs = containerSettings.listConfigsForWorkloadType(WorkloadType.USER_CODE);
            configurations.addAll(configs);
            Iterator iterator = configs.iterator();
            while (iterator.hasNext()) {
                configuration = (ContainerExecRuntimeConfig)iterator.next();
                containerConfigNamesPerBuildConfig.put((Object)ContainerExecUtils.ContainerBuildConfig.createFrom(configuration), (Object)configuration.name);
            }
        } else {
            for (String confName : template.containerConfs) {
                configuration = containerSettings.getByNameOrNull(confName);
                if (configuration == null) {
                    logger.warn((Object)("Code Studio template " + template.id + " references container configuration " + confName + " which does not exist"));
                    continue;
                }
                containerConfigNamesPerBuildConfig.put((Object)ContainerExecUtils.ContainerBuildConfig.createFrom(configuration), (Object)configuration.name);
                configurations.add(configuration);
            }
        }
        Map<ContainerExecUtils.ContainerBuildConfig, Collection<ContainerExecUtils.ContainerImagePush>> configMap = ContainerExecUtils.deduplicateContainerBuilds(configurations);
        ArrayList<CodeStudioTemplateImagesHandler> builders = new ArrayList<CodeStudioTemplateImagesHandler>(configMap.size());
        for (Map.Entry<ContainerExecUtils.ContainerBuildConfig, Collection<ContainerExecUtils.ContainerImagePush>> configEntry : configMap.entrySet()) {
            ArrayList<ContainerExecUtils.ContainerImagePush> toPush = new ArrayList<ContainerExecUtils.ContainerImagePush>();
            for (ContainerExecUtils.ContainerImagePush push : configEntry.getValue()) {
                if (!StringUtils.isNotBlank((String)push.repositoryURL)) continue;
                toPush.add(push);
            }
            builders.add(new CodeStudioTemplateImagesHandler(template, configEntry.getKey(), containerConfigNamesPerBuildConfig.get((Object)configEntry.getKey()), toPush));
        }
        return builders;
    }

    public static String getCodeStudioImageName(CodeStudioTemplate template) {
        return CodeStudioTemplateImagesHandler.getCodeStudioImageName(template.id);
    }

    public static String getCodeStudioImageName(String templateId) {
        return KubernetesExecUtils.sanitizeName(String.format("dku-kub-%s", templateId), false);
    }

    public CodeStudioTemplateImagesHandler(CodeStudioTemplate template, ContainerExecUtils.ContainerBuildConfig containerConfig, Set<String> containerExecRuntimeConfigNames, Collection<ContainerExecUtils.ContainerImagePush> pushes) {
        this.template = template;
        this.containerConfig = containerConfig;
        this.containerExecRuntimeConfigNames = containerExecRuntimeConfigNames;
        this.pushes = pushes;
        this.imageName = CodeStudioTemplateImagesHandler.getCodeStudioImageName(template);
    }

    public CodeStudioTemplateBuildResult build(String buildId, File buildDir, DKUtils.SmartLogTailBuilder logTailBuilder, File log, String dockerfile, boolean withNoCache) throws IOException, InterruptedException {
        CodeStudioTemplateBuildResult ret = new CodeStudioTemplateBuildResult();
        logTailBuilder.appendLine("Building docker image");
        String imageTagToBuild = this.imageName + ":dss-" + DKUApp.getDSSVersionTag() + "-" + buildId;
        ret.imageBuilt = imageTagToBuild;
        logger.infoV("Will build image " + imageTagToBuild + (withNoCache ? " with no cache" : ""), new Object[0]);
        FileUtils.writeStringToFile((File)new File(buildDir, "Dockerfile"), (String)dockerfile, (Charset)StandardCharsets.UTF_8);
        ArrayList<String> command = new ArrayList<String>(Arrays.asList("docker", "build", "-t", imageTagToBuild, "--force-rm", buildDir.getAbsolutePath()));
        if (withNoCache) {
            command.add("--no-cache");
        }
        ProcessBuilder pb = new ProcessBuilder(command);
        for (ContainerExecUtils.ContainerImagePush push : this.pushes) {
            pb.command().add("-t");
            pb.command().add(push.repositoryURL + "/" + imageTagToBuild);
        }
        File dockerLogFile = new File(buildDir, "docker.log");
        this.execDockerCommand(pb, buildDir, logTailBuilder, dockerLogFile);
        for (ContainerExecUtils.ContainerImagePush push : this.pushes) {
            logTailBuilder.appendLine("Pushing docker image to " + push.repositoryURL + ", prePushMode=" + String.valueOf((Object)push.prePushMode));
            switch (push.prePushMode) {
                case NONE: {
                    break;
                }
                case ECR: {
                    String region = ECRUtils.getRegionFromRepositoryURL(push.repositoryURL);
                    logTailBuilder.appendLine("EKS Pre-push script. Detected region: " + region);
                    pb = new ProcessBuilder(imageTagToBuild.split(":"));
                    pb.command().add(0, DKUApp.getInstallFile((String[])new String[]{"resources", "container-exec", "kubernetes", "aws-ecr-prepush.sh"}).getAbsolutePath());
                    pb.command().add(1, push.repositoryURL);
                    pb.command().add(2, region);
                    this.execDockerCommand(pb, buildDir, logTailBuilder, dockerLogFile);
                    break;
                }
                case ACR: {
                    logTailBuilder.appendLine("ACR Pre-push script");
                    pb = new ProcessBuilder(imageTagToBuild.split(":"));
                    pb.command().add(0, DKUApp.getInstallFile((String[])new String[]{"resources", "container-exec", "kubernetes", "azure-acr-prepush.sh"}).getAbsolutePath());
                    pb.command().add(1, push.repositoryURL);
                    this.execDockerCommand(pb, buildDir, logTailBuilder, dockerLogFile);
                    break;
                }
                case GCR: {
                    logTailBuilder.appendLine("GAR Pre-push script");
                    pb = new ProcessBuilder(imageTagToBuild.split(":"));
                    pb.command().add(0, DKUApp.getInstallFile((String[])new String[]{"resources", "container-exec", "kubernetes", "gcloud-gcr-prepush.sh"}).getAbsolutePath());
                    pb.command().add(1, push.repositoryURL);
                    this.execDockerCommand(pb, buildDir, logTailBuilder, dockerLogFile);
                    break;
                }
                case CUSTOM: {
                    if (!StringUtils.isNotBlank((String)push.prePushScript)) break;
                    logTailBuilder.appendLine("Custom Pre-push script, mode=" + String.valueOf((Object)push.prePushMode));
                    pb = new ProcessBuilder(imageTagToBuild.split(":"));
                    pb.command().add(0, push.prePushScript);
                    pb.command().add(1, push.repositoryURL);
                    this.execDockerCommand(pb, buildDir, logTailBuilder, dockerLogFile);
                }
            }
            pb = new ProcessBuilder("docker", "push", push.repositoryURL + "/" + imageTagToBuild);
            this.execDockerCommand(pb, buildDir, logTailBuilder, dockerLogFile);
            ret.pushed.add(new BaseImagesPusher.ImagePushState(imageTagToBuild, this.containerConfig.dockerHost, push.repositoryURL, true, null));
        }
        return ret;
    }

    public List<String> delete() throws IOException, InterruptedException {
        logger.infoV("Will delete image " + this.imageName, new Object[0]);
        ProcessBuilder getImages = new ProcessBuilder("docker", "images", "--format", "{{.Repository}}:{{.Tag}}");
        this.enrichDockerEnv(getImages);
        DKUtils.ExecutionResults res = DKUtils.execAndGetOutputAndErrors((ProcessBuilder)getImages);
        String[] allImages = res.out.split("\n");
        Stream imagesToPurge = Arrays.stream(allImages).filter(i -> i.startsWith(this.imageName + ":"));
        for (ContainerExecUtils.ContainerImagePush push : this.pushes) {
            imagesToPurge = Streams.concat((Stream[])new Stream[]{imagesToPurge, Arrays.stream(allImages).filter(i -> i.startsWith(push.repositoryURL + "/" + this.imageName + ":"))});
        }
        ProcessBuilder purgeImages = new ProcessBuilder("docker", "rmi", "--force");
        List<String> deletedImages = imagesToPurge.collect(Collectors.toList());
        purgeImages.command().addAll(deletedImages);
        this.enrichDockerEnv(purgeImages);
        DKUtils.execAndLogThrows((ProcessBuilder)purgeImages);
        return deletedImages;
    }

    private void execDockerCommand(ProcessBuilder pb, File buildDir, DKUtils.SmartLogTailBuilder logTailBuilder, File log) throws IOException, InterruptedException {
        logTailBuilder.appendLine("$ " + StringUtils.join(pb.command(), (char)' '));
        pb.directory(buildDir);
        this.enrichDockerEnv(pb);
        DKUtils.execAndLogThrowsMirror((ProcessBuilder)pb, (DKUtils.SmartLogTailBuilder)logTailBuilder, (File)log);
    }

    private void enrichDockerEnv(ProcessBuilder pb) {
        if (!ContainerExecUtils.ContainerBuildConfig.isImageBuiltLocally(this.containerConfig)) {
            ContainerExecUtils.enrichDockerEnv(this.containerConfig, pb.environment());
        }
    }

    public static class CodeStudioTemplateBuildResult {
        public String imageBuilt;
        public List<BaseImagesPusher.ImagePushState> pushed = Lists.newArrayList();
    }
}

