/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.connections;

import com.dataiku.dip.connections.AbstractLLMConnection;
import com.dataiku.dip.connections.ConnectionWithBasicCredential;
import com.dataiku.dip.connections.HuggingFaceLocalConnection;
import com.dataiku.dip.dao.GeneralSettingsDAO;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.llm.LLMStructuredRef;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.PasswordEncryptionService;
import com.dataiku.dip.security.model.ICredentialsService;
import com.dataiku.dip.server.services.ConnectionsTestService;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.variables.VariablesContext;
import java.io.IOException;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.List;

public class HuggingFaceInferenceAPIConnection
extends AbstractLLMConnection<HFAPIModel, HardcodedHFAPIModel, AbstractLLMConnection.CustomModel<HFAPIModel>> {
    public static final String connectionType = "HuggingFaceInferenceAPI";
    public HuggingFaceInferenceAPIConnectionParams params = new HuggingFaceInferenceAPIConnectionParams();
    private static final DKULogger logger = DKULogger.getLogger((String)"dip.connections.hfapiinference");

    @Override
    public void expandParametersInPlaceAtDAOLevelUsingGlobalContextOnly(VariablesContext vc) {
    }

    @Override
    protected <T> T getFullyResolvedCredentials_internal(ConnectionWithBasicCredential.CredentialResolutionContext ctx, Class<T> clazz) throws DKUSecurityException, IOException, SQLException {
        assert (clazz.isAssignableFrom(ICredentialsService.BasicCredential.class));
        ICredentialsService.BasicCredential creds = new ICredentialsService.BasicCredential("", this.params.apiKey);
        return clazz.cast(creds);
    }

    @Override
    public String getType() {
        return connectionType;
    }

    @Override
    protected void encryptLocalFields(PasswordEncryptionService cryptoService, GeneralSettingsDAO.SecuritySettings securitySettings) {
        this.params.apiKey = cryptoService.encryptIfNotEncryptedOrEmpty(this.params.apiKey);
    }

    @Override
    protected void decryptLocalFields(PasswordEncryptionService cryptoService) {
        this.params.apiKey = cryptoService.decryptIfEncrypted(this.params.apiKey);
    }

    @Override
    public AbstractLLMConnection.AbstractLLMConnectionParams getLLMConnectionParams() {
        return this.params;
    }

    @Override
    protected DKULogger getLogger() {
        return logger;
    }

    @Override
    protected List<HardcodedHFAPIModel> listRawHardcodedModels() {
        return Arrays.asList(HardcodedHFAPIModel.values());
    }

    @Override
    protected HFAPIModel loadRawHardcodedModel(HardcodedHFAPIModel hardcodedModel) {
        HFAPIModel model = hardcodedModel.toModel();
        this.loadDefaultHardcodedModelSettings(hardcodedModel, model);
        return model;
    }

    @Override
    public ConnectionsTestService.ConnectionTestResult testConnection(AuthCtx authCtx, ConnectionsTestService connectionsTestService) throws Exception {
        return connectionsTestService.testHuggingFace(authCtx, this);
    }

    public static class HuggingFaceInferenceAPIConnectionParams
    extends AbstractLLMConnection.AbstractLLMConnectionParams {
        public String apiKey;
        public int maxParallelism = 2;
    }

    public static enum HardcodedHFAPIModel implements AbstractLLMConnection.IHardcodedConnectionModel<HFAPIModel>
    {
        GPT2("gpt2", "GPT-2"),
        PYTHIA("EleutherAI/pythia-70m", "Pythia Scaling Suite 70M parameter model");

        public final String id;
        public final String displayName;

        private HardcodedHFAPIModel(String id, String displayName) {
            this.id = id;
            this.displayName = displayName;
        }

        @Override
        public HFAPIModel toModel() {
            HFAPIModel model = new HFAPIModel();
            model.id = this.id;
            model.displayName = this.displayName;
            return model;
        }
    }

    public static class HFAPIModel
    extends AbstractLLMConnection.BaseModel {
        @Override
        public AbstractLLMConnection.ModelCapabilities getModelCapabilities() {
            AbstractLLMConnection.ModelCapabilities capabilities = new AbstractLLMConnection.ModelCapabilities();
            capabilities.temperatureRange = HuggingFaceLocalConnection.TEMPERATURE_RANGE;
            capabilities.topKRange = HuggingFaceLocalConnection.TOP_K_RANGE;
            return capabilities;
        }

        @Override
        public LLMStructuredRef asStructuredRef(String connection) {
            return LLMStructuredRef.forHuggingFaceAPIConnection(connection, this.getId());
        }
    }
}

