/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.connections;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.CodedRuntimeException;
import com.dataiku.dip.ProxySettings;
import com.dataiku.dip.connections.AWSCredentialsProviders;
import com.dataiku.dip.connections.AbstractSQLConnection;
import com.dataiku.dip.connections.AzureConnection;
import com.dataiku.dip.connections.ConnectionCredentialUtils;
import com.dataiku.dip.connections.ConnectionWithAWSAuthCredentials;
import com.dataiku.dip.connections.ConnectionWithAzureAuthCredentials;
import com.dataiku.dip.connections.ConnectionWithBasicCredential;
import com.dataiku.dip.connections.ConnectionWithEncryptedFields;
import com.dataiku.dip.connections.ConnectionWithGoogleAuthCredentials;
import com.dataiku.dip.connections.ConnectionWithPerUserOAuth2Credentials;
import com.dataiku.dip.connections.ConnectionsDAO;
import com.dataiku.dip.connections.CredentialsRemoteFetchConfigurationProvider;
import com.dataiku.dip.connections.DSSConnection;
import com.dataiku.dip.connections.EC2Connection;
import com.dataiku.dip.connections.GCSConnection;
import com.dataiku.dip.connections.iceberg.IcebergCatalogHandler;
import com.dataiku.dip.connections.iceberg.IcebergCatalogHandlers;
import com.dataiku.dip.connections.iceberg.IcebergDSSAuthManager;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.dao.GeneralSettingsDAO;
import com.dataiku.dip.datasets.fs.AzureBlobModel;
import com.dataiku.dip.datasets.fs.S3DatasetHandler;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.hadoop.HadoopFlavorUtils;
import com.dataiku.dip.logging.MainLoggingConfigurator;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.PasswordEncryptionService;
import com.dataiku.dip.security.model.ICredentialsService;
import com.dataiku.dip.security.model.OAuth2Client;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.server.connections.ConnectionCodes;
import com.dataiku.dip.server.services.ConnectionsTestService;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.utils.NotImplementedException;
import com.dataiku.dip.variables.VariablesContext;
import com.dataiku.dip.variables.VariablesService;
import com.dataiku.dss.shadelib.com.nimbusds.oauth2.sdk.ParseException;
import com.dataiku.dss.shadelib.org.apache.commons.io.FileUtils;
import com.dataiku.dss.shadelib.org.apache.iceberg.catalog.Catalog;
import com.dataiku.dss.shadelib.org.apache.iceberg.hadoop.Configurable;
import com.dataiku.dss.shadelibgcp.com.google.auth.oauth2.AccessToken;
import com.dataiku.dss.shadelibgcp.com.google.auth.oauth2.GoogleCredentials;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URISyntaxException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Base64;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.conf.Configuration;

public class IcebergConnection
extends DSSConnection
implements ConnectionWithEncryptedFields,
ConnectionWithBasicCredential,
ConnectionWithPerUserOAuth2Credentials {
    public static final String connectionType = "iceberg";
    public Params params = new Params();
    private static DKULogger logger = DKULogger.getLogger((String)"dip.iceberg");

    @Override
    public String getType() {
        return connectionType;
    }

    public Params getParams() {
        return this.params;
    }

    @Override
    public boolean isFSLike() {
        return false;
    }

    @Override
    public boolean isFS() {
        return false;
    }

    @Override
    public boolean isProperSQL() {
        return false;
    }

    @Override
    public void expandParametersInPlaceAtDAOLevelUsingGlobalContextOnly(VariablesContext vc) {
    }

    @Override
    public void encryptLocalFields(PasswordEncryptionService cryptoService, GeneralSettingsDAO.SecuritySettings securitySettings) {
        this.params.password = cryptoService.encryptIfNotEncryptedOrEmpty(this.params.password);
        this.params.privateKey = cryptoService.encryptIfNotEncryptedOrEmpty(this.params.privateKey);
        this.params.privateKeyPassword = cryptoService.encryptIfNotEncryptedOrEmpty(this.params.privateKeyPassword);
    }

    @Override
    public void decryptLocalFields(PasswordEncryptionService cryptoService) {
        this.params.password = cryptoService.decryptIfEncrypted(this.params.password);
        this.params.privateKey = cryptoService.decryptIfEncrypted(this.params.privateKey);
        this.params.privateKeyPassword = cryptoService.decryptIfEncrypted(this.params.privateKeyPassword);
    }

    @Override
    protected <T> T getFullyResolvedCredentials_internal(ConnectionWithBasicCredential.CredentialResolutionContext ctx, Class<T> clazz) throws DKUSecurityException, IOException, SQLException {
        assert (clazz.isAssignableFrom(SerializableIcebergCredentials.class));
        SerializableIcebergCredentials creds = new SerializableIcebergCredentials();
        creds.catalogType = this.params.icebergCatalogType;
        creds.authType = this.params.authType;
        if (creds.catalogType.usesCreds) {
            switch (creds.authType) {
                case PASSWORD: {
                    ICredentialsService.BasicCredential basicCreds = ConnectionCredentialUtils.getDecryptedBasicCredential_autoTXN(this, ctx.authCtx);
                    creds.user = basicCreds.user;
                    creds.password = basicCreds.password;
                    break;
                }
                case OAUTH2_APP: {
                    creds.oauth2AppId = this.params.appId;
                    creds.oauth2AppSecret = this.params.appSecret;
                    creds.oauth2Scope = this.params.scope;
                    if (StringUtils.isEmpty((String)this.params.authorizationEndpoint) && StringUtils.isEmpty((String)this.params.tokenEndpoint)) {
                        IcebergCatalogHandler catalogHandler = IcebergCatalogHandlers.getCatalogHandler(this);
                        creds.oauth2AuthorizationEndpoint = catalogHandler.guessOauth2Endpoint(false);
                        creds.oauth2TokenEndpoint = catalogHandler.guessOauth2Endpoint(true);
                    } else {
                        creds.oauth2AuthorizationEndpoint = this.params.authorizationEndpoint;
                        creds.oauth2TokenEndpoint = this.params.tokenEndpoint;
                    }
                    OAuth2Client.AccessTokenResult tokens = this.getAccessToken(ctx.authCtx, this.getProxySettings());
                    if (this.credentialsMode == DSSConnection.CredentialsMode.PER_USER) {
                        creds.oauth2RefreshToken = tokens.getRefreshToken();
                    }
                    creds.oauth2AccessToken = tokens.getAccessToken();
                    break;
                }
                case KEY_PAIR: {
                    creds.user = this.params.user;
                    creds.privateKeyPassword = this.params.privateKeyPassword;
                    if (StringUtils.isNotEmpty((String)this.params.privateKeyFile)) {
                        File keyFile = new File(this.params.privateKeyFile);
                        if (!keyFile.exists() || !keyFile.canRead()) {
                            throw new FileNotFoundException("Cannot read private key file");
                        }
                        creds.privateKeyB64 = Base64.getEncoder().encodeToString(FileUtils.readFileToByteArray((File)keyFile));
                        break;
                    }
                    creds.privateKeyB64 = Base64.getEncoder().encodeToString(this.params.privateKey.getBytes());
                    break;
                }
                case SIG_V4: {
                    creds.signingName = this.params.signingName;
                    creds.signingRegion = this.params.signingRegion;
                }
            }
        }
        return clazz.cast(creds);
    }

    @Override
    public boolean actuallyHasPerUserOAuth2Credential() {
        return this.params.icebergCatalogType.usesCreds && this.credentialsMode == DSSConnection.CredentialsMode.PER_USER && this.params.authType == AuthType.OAUTH2_APP;
    }

    @Override
    public boolean hasRefreshTokenRotation() {
        return this.params.refreshTokenRotation;
    }

    @Override
    public boolean mustResolveOnDSSHost() {
        return this.params.icebergCatalogType.usesCreds && this.params.authType == AuthType.KEY_PAIR && StringUtils.isNotEmpty((String)this.params.privateKeyFile);
    }

    @Override
    public boolean mustResolveOnBackend() {
        return this.hasRefreshTokenRotation() || super.mustResolveOnBackend();
    }

    @Override
    public boolean actuallyHasBasicCredential() {
        return this.params.icebergCatalogType.usesCreds && this.params.authType == AuthType.PASSWORD;
    }

    @Override
    public ICredentialsService.BasicCredential getGlobalCredential() {
        return new ICredentialsService.BasicCredential(this.params.user, this.params.password);
    }

    @Override
    public List<AbstractSQLConnection.CustomDatabaseProperty> getDkuPropertiesInternal() {
        return this.params.dkuProperties;
    }

    @Override
    public OAuth2Client buildOAuth2Client(ProxySettings proxySettings, AuthCtx authCtx) throws DKUSecurityException {
        String tokenEndpoint;
        String authorizationEndpoint;
        VariablesService variablesService = (VariablesService)SpringUtils.getBean(VariablesService.class);
        VariablesContext vc = variablesService.getForConnectionAndUser(this, authCtx);
        String scope = vc.expand(this.params.scope);
        String appId = vc.expand(this.params.appId);
        String appSecret = vc.expand(this.params.appSecret);
        if (StringUtils.isEmpty((String)this.params.authorizationEndpoint) && StringUtils.isEmpty((String)this.params.tokenEndpoint)) {
            IcebergCatalogHandler catalogHandler = IcebergCatalogHandlers.getCatalogHandler(this);
            authorizationEndpoint = catalogHandler.guessOauth2Endpoint(false);
            tokenEndpoint = catalogHandler.guessOauth2Endpoint(true);
        } else {
            authorizationEndpoint = vc.expand(this.params.authorizationEndpoint);
            tokenEndpoint = vc.expand(this.params.tokenEndpoint);
        }
        logger.info((Object)("Using OAuth2 authorize endpoint: " + authorizationEndpoint));
        logger.info((Object)("Using OAuth2 token endpoint: " + tokenEndpoint));
        boolean useCache = this.getDkuPropertiesAsParams().getBoolParam("dku.connection.oauth.enableCache", true);
        return new OAuth2Client.Builder().authorizationEndpoint(authorizationEndpoint).tokenEndpoint(tokenEndpoint).clientId(appId).clientSecret(appSecret).scope(scope).usePkce(true).proxy(proxySettings).useAccessTokenCache(useCache).build();
    }

    @Override
    public ICredentialsService.OAuth2Credential getResolvedOAuth2Credential(AuthCtx authCtx) {
        return new ICredentialsService.OAuth2Credential(this.getAccessToken(authCtx, this.getProxySettings()).getAccessToken());
    }

    public OAuth2Client.AccessTokenResult getAccessToken(AuthCtx authCtx, ProxySettings proxySettings) {
        PasswordEncryptionService cryptoService = (PasswordEncryptionService)SpringUtils.getBean(PasswordEncryptionService.class);
        this.decryptFields(cryptoService);
        boolean useCache = this.getDkuPropertiesAsParams().getBoolParam("dku.connection.oauth.enableCache", true);
        logger.info((Object)"Exchanging user's refresh token for an access token");
        try {
            OAuth2Client oAuth2Client = this.buildOAuth2Client(proxySettings, authCtx);
            if (this.credentialsMode == DSSConnection.CredentialsMode.PER_USER) {
                return this.getAccessTokenFromRefreshTokenAndUpdateIfNeeded(authCtx, oAuth2Client, false);
            }
            return oAuth2Client.acquireAccessTokenResultWithClientCredentialsGrant(useCache);
        }
        catch (DKUSecurityException e) {
            throw new CodedRuntimeException(e.getCode(), "Failed to get OAuth2 access token", (Throwable)e);
        }
        catch (ParseException | IOException | URISyntaxException e) {
            throw new CodedRuntimeException((InfoMessage.MessageCode)ConnectionCodes.ERR_CONNECTION_INVALID_CONFIG, "Failed to get OAuth2 access token", e);
        }
    }

    public Catalog getIcebergCatalog(AuthCtx authCtx, String projectKey) throws IOException, DKUSecurityException {
        IcebergCatalogHandler catalogHandler = IcebergCatalogHandlers.getCatalogHandler(this);
        catalogHandler.checkConfiguration();
        List<AbstractSQLConnection.CustomDatabaseProperty> properties = this.getIcebergCatalogInitProperties(authCtx, projectKey);
        List<AbstractSQLConnection.CustomDatabaseProperty> hadoopConf = this.getIcebergCatalogHadoopConfiguration(authCtx, projectKey);
        String catalogName = StringUtils.defaultIfBlank((String)this.params.catalogName, (String)this.name);
        Catalog catalog = catalogHandler.newCatalog();
        if (catalog instanceof org.apache.hadoop.conf.Configurable) {
            org.apache.hadoop.conf.Configurable hadoopConfigurable = (org.apache.hadoop.conf.Configurable)catalog;
            logger.info((Object)"Catalog is hadoop Configurable, setting hadoop conf");
            Configuration conf = new Configuration();
            for (AbstractSQLConnection.CustomDatabaseProperty prop : hadoopConf) {
                conf.set(prop.name, prop.value);
            }
            hadoopConfigurable.setConf(conf);
        } else if (catalog instanceof Configurable) {
            Configurable hadoopConfigurable = (Configurable)catalog;
            logger.info((Object)"Catalog is iceberg Configurable, setting hadoop conf");
            Configuration conf = new Configuration();
            for (AbstractSQLConnection.CustomDatabaseProperty prop : hadoopConf) {
                conf.set(prop.name, prop.value);
            }
            hadoopConfigurable.setConf((Object)conf);
        }
        catalog.initialize(catalogName, properties.stream().collect(Collectors.toMap(p -> p.name, p -> StringUtils.defaultString((String)p.value), (first, second) -> first)));
        return catalog;
    }

    private List<AbstractSQLConnection.CustomDatabaseProperty> getIcebergCatalogHadoopConfiguration(AuthCtx authCtx, String projectKey) throws IOException, DKUSecurityException {
        ArrayList<AbstractSQLConnection.CustomDatabaseProperty> conf = new ArrayList<AbstractSQLConnection.CustomDatabaseProperty>();
        IcebergCatalogHandler catalogHandler = IcebergCatalogHandlers.getCatalogHandler(this);
        conf.addAll(catalogHandler.getHadoopProperties());
        if (catalogHandler.addCredentialsHadoopProperties()) {
            if (StringUtils.isNotBlank((String)this.params.s3Connection)) {
                String s3ConnectionName = this.params.s3Connection;
                EC2Connection s3Connection = ((ConnectionsDAO)SpringUtils.getBean(ConnectionsDAO.class)).getMandatoryConnectionAs(authCtx, s3ConnectionName, EC2Connection.class);
                conf.addAll(s3Connection.getHadoopConfigForS3Access(authCtx, null));
            }
            if (StringUtils.isNotBlank((String)this.params.gcsConnection)) {
                String gcsConnectionName = this.params.gcsConnection;
                GCSConnection gcsConnection = ((ConnectionsDAO)SpringUtils.getBean(ConnectionsDAO.class)).getMandatoryConnectionAs(authCtx, gcsConnectionName, GCSConnection.class);
                conf.addAll(gcsConnection.getHadoopConfigForGCSAccess(authCtx));
            }
            if (StringUtils.isNotBlank((String)this.params.azureConnection)) {
                String azureConnectionName = this.params.azureConnection;
                AzureConnection azureConnection = ((ConnectionsDAO)SpringUtils.getBean(ConnectionsDAO.class)).getMandatoryConnectionAs(authCtx, azureConnectionName, AzureConnection.class);
                conf.addAll(azureConnection.getHadoopConfigForAzureAccess(authCtx));
            }
        }
        return conf;
    }

    private List<AbstractSQLConnection.CustomDatabaseProperty> getIcebergCatalogInitProperties(AuthCtx authCtx, String projectKey) throws IOException, DKUSecurityException {
        ArrayList<AbstractSQLConnection.CustomDatabaseProperty> properties = new ArrayList<AbstractSQLConnection.CustomDatabaseProperty>();
        properties.addAll(this.params.properties);
        SerializableIcebergCredentials creds = this.getFullyResolvedCredentials_fsLike(new ConnectionWithBasicCredential.CredentialResolutionContext(authCtx, projectKey), SerializableIcebergCredentials.class);
        IcebergCatalogHandler catalogHandler = IcebergCatalogHandlers.getCatalogHandler(this);
        properties.addAll(catalogHandler.getCatalogProperties(creds));
        if (StringUtils.isNotBlank((String)this.params.s3Connection)) {
            if (ApplicationConfigurator.getProcessType() == MainLoggingConfigurator.ProcessType.UNKNOWN) {
                properties.add(new AbstractSQLConnection.CustomDatabaseProperty("client.credentials-provider", "com.dataiku.dip.spark.aws.RemoteFetchCredentialsProvider", false));
            } else {
                properties.add(new AbstractSQLConnection.CustomDatabaseProperty("client.credentials-provider", AWSCredentialsProviders.SerializableAWSCredentialHadoopProvider.class.getName(), false));
            }
            String s3ConnectionName = this.params.s3Connection;
            EC2Connection s3Connection = ((ConnectionsDAO)SpringUtils.getBean(ConnectionsDAO.class)).getMandatoryConnectionAs(authCtx, s3ConnectionName, EC2Connection.class);
            ConnectionWithAWSAuthCredentials.SerializableAWSCredential s3Creds = s3Connection.getFullyResolvedCredentials_fsLike(new ConnectionWithBasicCredential.CredentialResolutionContext(authCtx, projectKey), ConnectionWithAWSAuthCredentials.SerializableAWSCredential.class);
            properties.add(new AbstractSQLConnection.CustomDatabaseProperty("client.credentials-provider.access.key", s3Creds.accessKey, false));
            properties.add(new AbstractSQLConnection.CustomDatabaseProperty("client.credentials-provider.secret.key", s3Creds.secretKey, true));
            if (StringUtils.isNotBlank((String)s3Creds.sessionToken)) {
                properties.add(new AbstractSQLConnection.CustomDatabaseProperty("client.credentials-provider.session.token", s3Creds.sessionToken, true));
                properties.add(new AbstractSQLConnection.CustomDatabaseProperty("client.credentials-provider.session.expirationTime", Long.toString(s3Creds.expirationTime), false));
            }
            properties.add(new AbstractSQLConnection.CustomDatabaseProperty("client.credentials-provider.dku.connectionName", s3ConnectionName, false));
            properties.add(new AbstractSQLConnection.CustomDatabaseProperty("client.credentials-provider.dku.projectKey", StringUtils.defaultIfBlank((String)projectKey, (String)"__DKU_ANY_PROJECT__"), false));
            MainLoggingConfigurator.ProcessType rmiTo = CredentialsRemoteFetchConfigurationProvider.getCredentialsRemoteProvider(this);
            CredentialsRemoteFetchConfigurationProvider.CredentialsRemoteFetchInfo fetchInfo = new CredentialsRemoteFetchConfigurationProvider.CredentialsRemoteFetchInfo(rmiTo);
            properties.add(new AbstractSQLConnection.CustomDatabaseProperty("client.credentials-provider.dku.fetchInfo", JSON.json((Object)fetchInfo), false));
            if (StringUtils.isNotBlank((String)s3Connection.params.regionOrEndpoint) && !s3Connection.params.regionOrEndpoint.contains("://")) {
                properties.add(new AbstractSQLConnection.CustomDatabaseProperty("client.region", s3Connection.params.regionOrEndpoint, false));
            }
            if (this.params.cloudStorageProperties) {
                if (s3Connection.params.usePathMode) {
                    properties.add(new AbstractSQLConnection.CustomDatabaseProperty("s3.path-style-access", "true", false));
                }
                if (StringUtils.isNotBlank((String)s3Connection.params.regionOrEndpoint)) {
                    if (s3Connection.params.regionOrEndpoint.contains("://")) {
                        properties.add(new AbstractSQLConnection.CustomDatabaseProperty("s3.endpoint", s3Connection.params.regionOrEndpoint, false));
                    } else if (s3Connection.params.regionOrEndpoint.matches("^\\w+-\\w+-\\w+$")) {
                        properties.add(new AbstractSQLConnection.CustomDatabaseProperty("client.region", s3Connection.params.regionOrEndpoint, false));
                    }
                }
                properties.add(new AbstractSQLConnection.CustomDatabaseProperty("s3.use-arn-region-enabled", "true", false));
                properties.add(new AbstractSQLConnection.CustomDatabaseProperty("s3.cross-region-access-enabled", "true", false));
                if (s3Connection.params.encryptionMode == S3DatasetHandler.EncryptionMode.SSE_S3) {
                    properties.add(new AbstractSQLConnection.CustomDatabaseProperty("s3.sse.type", "s3", false));
                }
                if (s3Connection.params.encryptionMode == S3DatasetHandler.EncryptionMode.SSE_KMS && HadoopFlavorUtils.isAtLeast(2, 9)) {
                    properties.add(new AbstractSQLConnection.CustomDatabaseProperty("s3.sse.type", "kms", false));
                    if (StringUtils.isNotBlank((String)s3Connection.params.encryptionKeyId)) {
                        properties.add(new AbstractSQLConnection.CustomDatabaseProperty("s3.sse.key", s3Connection.params.encryptionKeyId, false));
                    }
                }
            }
        }
        if (StringUtils.isNotBlank((String)this.params.gcsConnection)) {
            String gcsConnectionName = this.params.gcsConnection;
            GCSConnection gcsConnection = ((ConnectionsDAO)SpringUtils.getBean(ConnectionsDAO.class)).getMandatoryConnectionAs(authCtx, gcsConnectionName, GCSConnection.class);
            properties.add(new AbstractSQLConnection.CustomDatabaseProperty("gcs.project-id", gcsConnection.params.projectId, false));
            ConnectionWithGoogleAuthCredentials.SerializableGoogleAuthCredentials gcsCreds = gcsConnection.getFullyResolvedCredentials_fsLike(new ConnectionWithBasicCredential.CredentialResolutionContext(authCtx, projectKey), ConnectionWithGoogleAuthCredentials.SerializableGoogleAuthCredentials.class);
            GoogleCredentials gcpCreds = gcsCreds.toGoogleCredentials(new ConnectionWithBasicCredential.CredentialResolutionContext(authCtx, projectKey), gcsConnection);
            AccessToken accessToken = gcpCreds.getAccessToken();
            if (accessToken == null) {
                gcpCreds = gcpCreds.createScoped(new String[]{"https://www.googleapis.com/auth/devstorage.read_write"});
                accessToken = gcpCreds.refreshAccessToken();
            }
            if (accessToken != null) {
                properties.add(new AbstractSQLConnection.CustomDatabaseProperty("gcs.oauth2.token", accessToken.getTokenValue(), false));
                properties.add(new AbstractSQLConnection.CustomDatabaseProperty("gcs.oauth2.token-expires-at", Long.toString(accessToken.getExpirationTime().getTime()), false));
                try (CredentialsRemoteFetchConfigurationProvider.FetchAsAuthCtx fetchAs = CredentialsRemoteFetchConfigurationProvider.fetchAs(authCtx);){
                    MainLoggingConfigurator.ProcessType rmiTo = CredentialsRemoteFetchConfigurationProvider.getCredentialsRemoteProvider(this);
                    properties.add(new AbstractSQLConnection.CustomDatabaseProperty("gcs.oauth2.refresh-credentials-enabled", "true", false));
                    CredentialsRemoteFetchConfigurationProvider.CredentialsRemoteFetchInfo fetchInfo = new CredentialsRemoteFetchConfigurationProvider.CredentialsRemoteFetchInfo(rmiTo);
                    String endpoint = fetchInfo.apiURL + "/connections/refresh-access-token-for-iceberg?name=" + gcsConnectionName + "&projectKey=" + projectKey + "&onBehalf=" + this.name;
                    if (StringUtils.isNotBlank((String)fetchInfo.executionId)) {
                        endpoint = endpoint + "&executionId=" + fetchInfo.executionId;
                    }
                    properties.add(new AbstractSQLConnection.CustomDatabaseProperty("gcs.oauth2.refresh-credentials-endpoint", endpoint, false));
                    properties.add(new AbstractSQLConnection.CustomDatabaseProperty("gcs.oauth2.refresh-credentials-fetch-info", JSON.json((Object)fetchInfo), true));
                    properties.add(0, new AbstractSQLConnection.CustomDatabaseProperty("rest.auth.type", IcebergDSSAuthManager.class.getName(), false));
                }
            }
            if (this.params.cloudStorageProperties && StringUtils.isNotBlank((String)gcsConnection.params.pscEndpointId)) {
                properties.add(new AbstractSQLConnection.CustomDatabaseProperty("fs.gs.storage.root.url", String.format("https://storage-%s.p.googleapis.com/", gcsConnection.params.pscEndpointId), false));
            }
        }
        if (StringUtils.isNotBlank((String)this.params.azureConnection)) {
            String azureConnectionName = this.params.azureConnection;
            AzureConnection azureConnection = ((ConnectionsDAO)SpringUtils.getBean(ConnectionsDAO.class)).getMandatoryConnectionAs(authCtx, azureConnectionName, AzureConnection.class);
            ConnectionWithAzureAuthCredentials.SerializableAzureAuthCredentials azureCreds = azureConnection.getFullyResolvedCredentials_fsLike(new ConnectionWithBasicCredential.CredentialResolutionContext(authCtx, projectKey), ConnectionWithAzureAuthCredentials.SerializableAzureAuthCredentials.class);
            if (azureCreds.authType == ConnectionWithAzureAuthCredentials.AuthType.KEY) {
                properties.add(new AbstractSQLConnection.CustomDatabaseProperty("adls.auth.shared-key.account.name", azureConnection.params.storageAccount, false));
                properties.add(new AbstractSQLConnection.CustomDatabaseProperty("adls.auth.shared-key.account.key", azureCreds.key, true));
            } else if (azureCreds.authType == ConnectionWithAzureAuthCredentials.AuthType.OAUTH2_APP) {
                if (StringUtils.isBlank((String)this.params.azureContainer)) {
                    logger.warn((Object)"No container specified, can't generate a SAS token. Reverting to default authentication");
                } else {
                    AzureBlobModel.BlobServiceAccountHolder blobClient = azureConnection.getAzureBlobClient(authCtx, true);
                    AzureBlobModel.BlobContainerHolder containerClient = blobClient.getContainerReference(this.params.azureContainer);
                    String sasToken = containerClient.generateSAS(blobClient.generateDelegationKey(azureCreds.oauth2AccessTokenExpiresOn));
                    for (MainLoggingConfigurator.ProcessType suffix : new MainLoggingConfigurator.ProcessType[]{"", ".dfs.core.windows.net", ".blob.core.windows.net"}) {
                        properties.add(new AbstractSQLConnection.CustomDatabaseProperty("adls.sas-token." + azureConnection.params.storageAccount + (String)suffix, sasToken, true));
                        properties.add(new AbstractSQLConnection.CustomDatabaseProperty("adls.sas-token-expires-at-ms." + azureConnection.params.storageAccount + (String)suffix, Long.toString(azureCreds.oauth2AccessTokenExpiresOn), false));
                    }
                    try (CredentialsRemoteFetchConfigurationProvider.FetchAsAuthCtx fetchAs = CredentialsRemoteFetchConfigurationProvider.fetchAs(authCtx);){
                        MainLoggingConfigurator.ProcessType rmiTo = CredentialsRemoteFetchConfigurationProvider.getCredentialsRemoteProvider(this);
                        properties.add(new AbstractSQLConnection.CustomDatabaseProperty("adls.refresh-credentials-enabled", "true", false));
                        CredentialsRemoteFetchConfigurationProvider.CredentialsRemoteFetchInfo fetchInfo = new CredentialsRemoteFetchConfigurationProvider.CredentialsRemoteFetchInfo(rmiTo);
                        String endpoint = fetchInfo.apiURL + "/connections/refresh-access-token-for-iceberg?name=" + azureConnectionName + "&projectKey=" + projectKey + "&onBehalf=" + this.name;
                        if (StringUtils.isNotBlank((String)fetchInfo.executionId)) {
                            endpoint = endpoint + "&executionId=" + fetchInfo.executionId;
                        }
                        properties.add(new AbstractSQLConnection.CustomDatabaseProperty("adls.refresh-credentials-endpoint", endpoint, false));
                        properties.add(new AbstractSQLConnection.CustomDatabaseProperty("adls.refresh-credentials-fetch-info", JSON.json((Object)fetchInfo), true));
                        properties.add(0, new AbstractSQLConnection.CustomDatabaseProperty("rest.auth.type", IcebergDSSAuthManager.class.getName(), false));
                    }
                }
            } else if (StringUtils.isNotBlank((String)azureConnection.params.sasToken)) {
                for (String suffix : new String[]{"", ".dfs.core.windows.net", ".blob.core.windows.net"}) {
                    properties.add(new AbstractSQLConnection.CustomDatabaseProperty("adls.sas-token." + azureConnection.params.storageAccount + suffix, azureConnection.params.sasToken, true));
                }
            }
        }
        if (properties.stream().noneMatch(p -> "rest.client.connection-timeout-ms".equals(p.name))) {
            properties.add(new AbstractSQLConnection.CustomDatabaseProperty("rest.client.connection-timeout-ms", "30000", false));
        }
        if (properties.stream().noneMatch(p -> "rest.client.socket-timeout-ms".equals(p.name))) {
            properties.add(new AbstractSQLConnection.CustomDatabaseProperty("rest.client.socket-timeout-ms", "60000", false));
        }
        return properties;
    }

    public List<AbstractSQLConnection.CustomDatabaseProperty> getSparkConfForCatalog(AuthCtx authCtx, String projectKey) throws IOException, DKUSecurityException {
        ArrayList<AbstractSQLConnection.CustomDatabaseProperty> ret = new ArrayList<AbstractSQLConnection.CustomDatabaseProperty>();
        String catalogName = this.makeSparkCatalogName();
        String prefix = "spark.sql.catalog." + catalogName;
        ret.add(new AbstractSQLConnection.CustomDatabaseProperty(prefix, "org.apache.iceberg.spark.SparkCatalog", false));
        List<AbstractSQLConnection.CustomDatabaseProperty> properties = this.getIcebergCatalogInitProperties(authCtx, projectKey);
        List<AbstractSQLConnection.CustomDatabaseProperty> hadoopConf = this.getIcebergCatalogHadoopConfiguration(authCtx, projectKey);
        ret.addAll(IcebergCatalogHandlers.getCatalogHandler(this).getSparkProperties(prefix));
        for (AbstractSQLConnection.CustomDatabaseProperty customDatabaseProperty : properties) {
            ret.add(new AbstractSQLConnection.CustomDatabaseProperty(prefix + "." + customDatabaseProperty.name, customDatabaseProperty.value, customDatabaseProperty.secret));
        }
        for (AbstractSQLConnection.CustomDatabaseProperty customDatabaseProperty : hadoopConf) {
            ret.add(new AbstractSQLConnection.CustomDatabaseProperty("spark.hadoop." + customDatabaseProperty.name, customDatabaseProperty.value, customDatabaseProperty.secret));
        }
        if (properties.stream().noneMatch(p -> "cache.case-sensitive".equals(p.name))) {
            ret.add(new AbstractSQLConnection.CustomDatabaseProperty(prefix + ".cache.case-sensitive", "true", false));
        }
        HashMap<String, String> translations = new HashMap<String, String>();
        translations.put(IcebergDSSAuthManager.class.getName(), "com.dataiku.dip.security.UnshadedIcebergDSSAuthManager");
        translations.put(AWSCredentialsProviders.SerializableAWSCredentialHadoopProvider.class.getName(), "com.dataiku.dip.spark.aws.RemoteFetchCredentialsProvider");
        for (AbstractSQLConnection.CustomDatabaseProperty customDatabaseProperty : ret) {
            if (!translations.containsKey(customDatabaseProperty.value)) continue;
            customDatabaseProperty.value = (String)translations.get(customDatabaseProperty.value);
        }
        Pattern pattern = Pattern.compile("^com\\.dataiku\\.dss\\.shadelib[a-zA-Z0-9]*\\.(.*)$");
        for (AbstractSQLConnection.CustomDatabaseProperty p3 : ret) {
            Matcher matcher;
            if (p3.value == null || !(matcher = pattern.matcher(p3.value)).matches()) continue;
            p3.value = matcher.group(1);
        }
        HashSet<String> hashSet = new HashSet<String>();
        ArrayList<AbstractSQLConnection.CustomDatabaseProperty> unicized = new ArrayList<AbstractSQLConnection.CustomDatabaseProperty>();
        for (AbstractSQLConnection.CustomDatabaseProperty p4 : ret) {
            if (hashSet.contains(p4.name)) continue;
            unicized.add(p4);
            hashSet.add(p4.name);
        }
        return unicized;
    }

    public String makeSparkCatalogName() {
        for (AbstractSQLConnection.CustomDatabaseProperty prop : this.params.dkuProperties) {
            if (!"spark.catalog.name".equals(prop.name)) continue;
            return prop.value;
        }
        String baseName = StringUtils.defaultIfBlank((String)this.params.catalogName, (String)this.name);
        Object catalogName = baseName.replaceAll("[^a-zA-Z0-9_]", "_");
        if (!((String)catalogName).equals(baseName)) {
            catalogName = (String)catalogName + baseName.hashCode() % 10000;
        }
        return catalogName;
    }

    public com.dataiku.dip.utils.Params getDkuPropertiesAsParams() {
        return AbstractSQLConnection.CustomDatabaseProperty.toParams(this.getParams().dkuProperties);
    }

    public JsonObject makeLoadCredentialsResponse(AuthCtx authCtx, String projectKey, Object rawCreds, DSSConnection conn) throws IOException, DKUSecurityException {
        JsonObject icebergCred = new JsonObject();
        JsonObject icebergCredConfig = new JsonObject();
        icebergCred.add("config", (JsonElement)icebergCredConfig);
        if (conn instanceof ConnectionWithGoogleAuthCredentials) {
            ConnectionWithGoogleAuthCredentials.SerializableGoogleAuthCredentials googleCreds = (ConnectionWithGoogleAuthCredentials.SerializableGoogleAuthCredentials)rawCreds;
            GoogleCredentials gcpCreds = googleCreds.toGoogleCredentials(new ConnectionWithBasicCredential.CredentialResolutionContext(authCtx, projectKey), conn);
            AccessToken accessToken = gcpCreds.getAccessToken();
            if (accessToken == null) {
                gcpCreds = gcpCreds.createScoped(new String[]{"https://www.googleapis.com/auth/devstorage.read_write"});
                accessToken = gcpCreds.refreshAccessToken();
            }
            icebergCredConfig.addProperty("gcs.oauth2.token", accessToken.getTokenValue());
            icebergCredConfig.addProperty("gcs.oauth2.token-expires-at", Long.toString(accessToken.getExpirationTime().getTime()));
            icebergCred.addProperty("prefix", "gs://whatever");
        } else if (conn instanceof ConnectionWithAzureAuthCredentials) {
            AzureConnection azureConnection = (AzureConnection)conn;
            ConnectionWithAzureAuthCredentials.SerializableAzureAuthCredentials azureCreds = (ConnectionWithAzureAuthCredentials.SerializableAzureAuthCredentials)rawCreds;
            AzureBlobModel.BlobServiceAccountHolder blobClient = azureConnection.getAzureBlobClient(authCtx, true);
            AzureBlobModel.BlobContainerHolder containerClient = blobClient.getContainerReference(this.params.azureContainer);
            String sasToken = containerClient.generateSAS(blobClient.generateDelegationKey(azureCreds.oauth2AccessTokenExpiresOn));
            for (String suffix : new String[]{"", ".dfs.core.windows.net", ".blob.core.windows.net"}) {
                icebergCredConfig.addProperty("adls.sas-token." + azureConnection.params.storageAccount + suffix, sasToken);
                icebergCredConfig.addProperty("adls.sas-token-expires-at-ms." + azureConnection.params.storageAccount + suffix, Long.toString(azureCreds.oauth2AccessTokenExpiresOn));
            }
            icebergCred.addProperty("prefix", "abfss://container@" + azureConnection.params.storageAccount + ".dfs.core.windows.net/");
        } else {
            throw new NotImplementedException("No generic token refresh for connection of type " + conn.getClass().getCanonicalName());
        }
        JsonArray icebergCreds = new JsonArray();
        icebergCreds.add((JsonElement)icebergCred);
        JsonObject icebergResp = new JsonObject();
        icebergResp.add("storage-credentials", (JsonElement)icebergCreds);
        return icebergResp;
    }

    public List<String> getKnownDriverJars() {
        return IcebergCatalogHandlers.getCatalogHandler(this).getAdditionalSparkDriverJars();
    }

    @Override
    public ConnectionsTestService.ConnectionTestResult testConnection(AuthCtx authCtx, ConnectionsTestService connectionsTestService) throws Exception {
        return connectionsTestService.testIceberg(null, this);
    }

    public JsonObject getResolvedParams(AuthCtx authCtx, @Nullable String projectKey) throws IOException, DKUSecurityException {
        ArrayList<AbstractSQLConnection.CustomDatabaseProperty> ret = new ArrayList<AbstractSQLConnection.CustomDatabaseProperty>();
        ret.addAll(this.getIcebergCatalogInitProperties(authCtx, projectKey));
        ret.addAll(this.getIcebergCatalogHadoopConfiguration(authCtx, projectKey));
        if (ret.stream().noneMatch(p -> "cache.case-sensitive".equals(p.name))) {
            ret.add(new AbstractSQLConnection.CustomDatabaseProperty("cache.case-sensitive", "true", false));
        }
        HashSet<String> translations = new HashSet<String>();
        translations.add(IcebergDSSAuthManager.class.getName());
        translations.add(AWSCredentialsProviders.SerializableAWSCredentialHadoopProvider.class.getName());
        List<AbstractSQLConnection.CustomDatabaseProperty> cleaned = ret.stream().filter(p -> !translations.contains(p.value)).toList();
        HashSet<String> keys = new HashSet<String>();
        ArrayList<AbstractSQLConnection.CustomDatabaseProperty> unicized = new ArrayList<AbstractSQLConnection.CustomDatabaseProperty>();
        for (AbstractSQLConnection.CustomDatabaseProperty p2 : cleaned) {
            if (keys.contains(p2.name)) continue;
            unicized.add(p2);
            keys.add(p2.name);
        }
        JsonObject resolved = new JsonObject();
        resolved.add("catalogProperties", (JsonElement)JSON.toJsonArray(unicized));
        return resolved;
    }

    public static class Params
    extends DSSConnection.DkuConnectionParams {
        public List<AbstractSQLConnection.CustomDatabaseProperty> properties = new ArrayList<AbstractSQLConnection.CustomDatabaseProperty>();
        public List<AbstractSQLConnection.CustomDatabaseProperty> dkuProperties = new ArrayList<AbstractSQLConnection.CustomDatabaseProperty>();
        public IcebergCatalogType icebergCatalogType = IcebergCatalogType.REST;
        public JsonObject icebergCatalogParams = new JsonObject();
        public AuthType authType = AuthType.PASSWORD;
        public String user;
        public String password;
        public String appId;
        public String appSecret;
        public String authorizationEndpoint;
        public String tokenEndpoint;
        public String scope;
        public boolean refreshTokenRotation;
        public String privateKey;
        public String privateKeyFile;
        public String privateKeyPassword;
        public String signingName;
        public String signingRegion;
        public String s3Connection;
        public String gcsConnection;
        public String azureConnection;
        public String azureContainer;
        public boolean cloudStorageProperties = true;
        public String catalogName;
        public String defaultNamespace;
        public boolean autoCreateNamespace;
        public String tableNameDatasetNamePrefix;
        public String tableNameDatasetNameSuffix;
        public String defaultNamespaceInManagedDatasetCreation;
        public boolean canOverrideDefaultNamespaceInManagedDatasetCreation;
        public String associatedTrinoConnection;
        public String associatedTrinoCatalog;
        public boolean isAthena;
        public boolean purgeOnDrop = true;
    }

    public static class SerializableIcebergCredentials
    implements ICredentialsService.BasicCredentialConvertible {
        public IcebergCatalogType catalogType;
        public AuthType authType;
        public String oauth2AppId;
        public String oauth2AppSecret;
        public String oauth2AuthorizationEndpoint;
        public String oauth2TokenEndpoint;
        public String oauth2Scope;
        public String oauth2RefreshToken;
        public String oauth2AccessToken;
        public String user;
        public String password;
        public String privateKeyB64;
        public String privateKeyPassword;
        public String signingName;
        public String signingRegion;

        @Override
        public ICredentialsService.BasicCredential toBasicCredential() {
            return new ICredentialsService.BasicCredential(this.user, this.password);
        }
    }

    public static enum IcebergCatalogType {
        REST(true),
        GLUE(false),
        SNOWFLAKE(true),
        JDBC(true),
        HADOOP(false),
        HIVE(false),
        NESSIE(true);

        private final boolean usesCreds;

        private IcebergCatalogType(boolean usesCreds) {
            this.usesCreds = usesCreds;
        }
    }

    public static enum AuthType {
        PASSWORD,
        OAUTH2_APP,
        KEY_PAIR,
        SIG_V4;

    }
}

