/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.connections;

import com.dataiku.dip.connections.AbstractSQLConnection;
import com.dataiku.dip.connections.ConnectionUtils;
import com.dataiku.dip.connections.ConnectionWithEncryptedFields;
import com.dataiku.dip.connections.SimpleSQLDSSConnectionWithBasicCredential;
import com.dataiku.dip.dao.GeneralSettingsDAO;
import com.dataiku.dip.plugin.CustomSQLDialect;
import com.dataiku.dip.security.PasswordEncryptionService;
import com.dataiku.dip.security.model.ICredentialsService;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.sql.CustomJavaDialect;
import com.dataiku.dip.sql.CustomJavaDialectDesc;
import com.dataiku.dip.sql.CustomJavaDialectsService;
import com.dataiku.dip.sql.CustomSQLDialectsRegistry;
import com.dataiku.dip.sql.DummySQLDialect;
import com.dataiku.dip.sql.SQLDialect;
import com.dataiku.dip.utils.ErrorContext;
import com.dataiku.dip.variables.VariablesContext;
import org.apache.commons.lang.StringUtils;

public class JdbcConnection
extends SimpleSQLDSSConnectionWithBasicCredential
implements ConnectionWithEncryptedFields {
    public Params params = new Params();
    public static final String connectionType = "JDBC";

    @Override
    public Params getParams() {
        return this.params;
    }

    @Override
    public String getType() {
        return connectionType;
    }

    @Override
    public SQLDialect getDialect() {
        String dialectName = this.params.dialectName;
        if (StringUtils.isBlank((String)dialectName)) {
            dialectName = DummySQLDialect.class.getSimpleName();
        }
        try {
            if (CustomSQLDialectsRegistry.hasDialect(dialectName)) {
                CustomJavaDialectDesc dialectDesc = CustomSQLDialectsRegistry.getDialect(dialectName).getDesc();
                String fullClassName = dialectDesc.dialectClass;
                ClassLoader classLoader = ((CustomJavaDialectsService)SpringUtils.getBean(CustomJavaDialectsService.class)).getClassloader(dialectName);
                Class<?> dialectClass = classLoader.loadClass(fullClassName);
                if (CustomSQLDialect.class.isAssignableFrom(dialectClass)) {
                    CustomSQLDialect customSQLDialect = (CustomSQLDialect)dialectClass.newInstance();
                    return new CustomJavaDialect(customSQLDialect, dialectDesc);
                }
                if (SQLDialect.class.isAssignableFrom(dialectClass)) {
                    return (SQLDialect)dialectClass.newInstance();
                }
                throw ErrorContext.iae((String)("SQL dialect class not found: " + dialectName));
            }
            String fullClassName = "com.dataiku.dip.sql." + dialectName;
            Class<?> dialectClass = ConnectionUtils.class.getClassLoader().loadClass(fullClassName);
            if (!SQLDialect.class.isAssignableFrom(dialectClass)) {
                throw ErrorContext.iae((String)("SQL dialect class not found: " + dialectName));
            }
            Object dialect = dialectClass.newInstance();
            assert (dialect instanceof SQLDialect);
            return (SQLDialect)dialect;
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to init SQL dialect: " + dialectName, e);
        }
    }

    @Override
    String getDriver() {
        return this.params.driver;
    }

    @Override
    String getJdbcUrl() {
        return this.params.jdbcurl;
    }

    @Override
    String getDisplayableJdbcUrl() {
        return StringUtils.isNotBlank((String)this.params.displayedUrl) ? this.params.displayedUrl : this.getJdbcUrl();
    }

    @Override
    public ICredentialsService.BasicCredential getGlobalCredential() {
        return new ICredentialsService.BasicCredential(this.params.user, this.params.password);
    }

    @Override
    protected void encryptLocalFields(PasswordEncryptionService cryptoService, GeneralSettingsDAO.SecuritySettings unused) {
        this.params.password = cryptoService.encryptIfNotEncryptedOrEmpty(this.params.password);
        this.encryptCustomFields(cryptoService);
    }

    @Override
    protected void decryptLocalFields(PasswordEncryptionService cryptoService) {
        this.params.password = cryptoService.decryptIfEncrypted(this.params.password);
        this.decryptCustomFields(cryptoService);
    }

    public static class Params
    extends AbstractSQLConnection.AbstractSQLParams {
        public String driver;
        public String jdbcurl;
        public String displayedUrl;
        public String dialectName;
        public String user;
        public String password;
        public boolean supportsBrowsingCatalogs;

        @Override
        public void expandInPlaceAtDAOLevelUsingGlobalContextOnly(VariablesContext vc) {
            super.expandInPlaceAtDAOLevelUsingGlobalContextOnly(vc);
            this.driver = vc.expand(this.driver);
            this.dialectName = vc.expand(this.dialectName);
        }
    }
}

