/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.connections;

import com.dataiku.dip.ProxySettings;
import com.dataiku.dip.connections.AbstractSQLConnection;
import com.dataiku.dip.connections.ConnectionWithBasicCredential;
import com.dataiku.dip.connections.ConnectionWithGoogleAuthCredentials;
import com.dataiku.dip.connections.DSSConnection;
import com.dataiku.dip.dao.GeneralSettingsDAO;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.externalinfras.ExternalInfrasUtils;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.PasswordEncryptionService;
import com.dataiku.dip.server.services.ConnectionsTestService;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.variables.VariablesContext;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import org.apache.commons.lang.StringUtils;

public class VertexAIModelDeploymentConnection
extends DSSConnection
implements ConnectionWithGoogleAuthCredentials {
    public static final String VERTEX_AIMODEL_DEPLOYMENT_CONNECTION_TYPE = "VertexAIModelDeployment";
    public Params params = new Params();
    private static DKULogger logger = DKULogger.getLogger((String)"dku.vertexai");

    public VertexAIModelDeploymentConnection() {
        this.allowWrite = false;
        this.allowManagedDatasets = false;
        this.allowManagedFolders = false;
    }

    @Override
    @Nonnull
    public ConnectionWithGoogleAuthCredentials.GoogleAuth2Params getGoogleAuth2NonResolvedParams() {
        return this.params;
    }

    @Override
    public ProxySettings getProxySettingsFromConnection() {
        return ExternalInfrasUtils.getProxy(this);
    }

    @Override
    public boolean mustResolveOnDSSHost() {
        return this.mustResolveGoogleAuthOnDSSHost();
    }

    @Override
    public boolean mustResolveOnBackend() {
        return this.hasRefreshTokenRotation() || super.mustResolveOnBackend();
    }

    @Override
    protected <T> T getFullyResolvedCredentials_internal(ConnectionWithBasicCredential.CredentialResolutionContext ctx, Class<T> clazz) throws DKUSecurityException, IOException, SQLException {
        assert (clazz.isAssignableFrom(ConnectionWithGoogleAuthCredentials.SerializableGoogleAuthCredentials.class));
        ConnectionWithGoogleAuthCredentials.SerializableGoogleAuthCredentials creds = this.getResolvedCredential(ctx.authCtx);
        return clazz.cast(creds);
    }

    @Override
    public String getType() {
        return VERTEX_AIMODEL_DEPLOYMENT_CONNECTION_TYPE;
    }

    @Override
    public void expandParametersInPlaceAtDAOLevelUsingGlobalContextOnly(VariablesContext vc) {
        this.params.appSecretContent = vc.expand(this.params.appSecretContent);
    }

    @Override
    protected List<AbstractSQLConnection.CustomDatabaseProperty> getDkuPropertiesInternal() {
        return this.params.dkuProperties;
    }

    @Override
    public boolean actuallyHasPerUserOAuth2Credential() {
        return this.credentialsMode == DSSConnection.CredentialsMode.PER_USER && this.params.authType == ConnectionWithGoogleAuthCredentials.AuthType.OAUTH;
    }

    @Override
    public boolean isADataStoringConnection() {
        return false;
    }

    @Override
    protected void decryptLocalFields(PasswordEncryptionService cryptoService) {
        this.params.oauth2ClientSecret = cryptoService.decryptIfEncrypted(this.params.oauth2ClientSecret);
        this.params.appSecretContent = cryptoService.decryptIfEncrypted(this.params.appSecretContent);
    }

    @Override
    protected void encryptLocalFields(PasswordEncryptionService cryptoService, GeneralSettingsDAO.SecuritySettings unused) {
        this.params.oauth2ClientSecret = cryptoService.encryptIfNotEncryptedOrEmpty(this.params.oauth2ClientSecret);
        if (StringUtils.isNotBlank((String)this.params.appSecretContent) && ConnectionWithGoogleAuthCredentials.isJson(this.params.appSecretContent)) {
            this.params.appSecretContent = cryptoService.encryptIfNotEncryptedOrEmpty(this.params.appSecretContent);
        }
    }

    @Override
    public ConnectionsTestService.ConnectionTestResult testConnection(AuthCtx authCtx, ConnectionsTestService connectionsTestService) throws Exception {
        return connectionsTestService.testVertexAIModelDeployment(this, authCtx);
    }

    public static class Params
    extends ConnectionWithGoogleAuthCredentials.GoogleAuth2Params {
        public List<AbstractSQLConnection.CustomDatabaseProperty> dkuProperties = new ArrayList<AbstractSQLConnection.CustomDatabaseProperty>();

        public Params() {
        }

        public Params(Params other) {
            super(other);
            this.dkuProperties = other.dkuProperties;
        }

        @Override
        public String getDefaultOauth2Scope() {
            return "https://www.googleapis.com/auth/cloud-platform";
        }
    }
}

