/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dashboards.export.model;

import com.dataiku.dip.dashboards.export.DashboardsExportService;
import com.dataiku.dip.graphicsexport.model.BaseExport;
import com.dataiku.dip.graphicsexport.model.ExportFormat;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.Range;

public class DashboardExport
extends BaseExport {
    public static final Range<Integer> SCREEN_RANGE_W = Range.between((Comparable)Integer.valueOf(960), (Comparable)Integer.valueOf(7200));
    public static final Range<Integer> SCREEN_RANGE_H = Range.between((Comparable)Integer.valueOf(540), (Comparable)Integer.valueOf(10000));
    public final List<Target> dashboards;
    public final DashboardsExportService.ScenarioContext context;

    public DashboardExport(String projectKey, Target dashboard) {
        this(projectKey, dashboard, null);
    }

    public DashboardExport(String projectKey, Target dashboard, DashboardsExportService.ScenarioContext context) {
        this(projectKey, Collections.singletonList(dashboard), context);
    }

    public DashboardExport(String projectKey, ExportFormat exportFormat, Target dashboard) {
        this(projectKey, exportFormat, Collections.singletonList(dashboard), null);
    }

    public DashboardExport(String projectKey, ExportFormat exportFormat, List<Target> dashboards) {
        this(projectKey, exportFormat, dashboards, null);
    }

    public DashboardExport(String projectKey, List<Target> dashboards) {
        this(projectKey, dashboards, null);
    }

    public static ExportFormat getBaseExportFormat(List<Target> dashboards) {
        ExportFormat defaultExportFormat = new ExportFormat();
        defaultExportFormat.paperSize = ExportFormat.PaperSize.CUSTOM;
        defaultExportFormat.height = 1080;
        defaultExportFormat.width = 1920;
        if (dashboards == null || dashboards.isEmpty()) {
            return defaultExportFormat;
        }
        ExportFormat format = dashboards.get((int)0).exportFormat;
        return format != null ? format : defaultExportFormat;
    }

    public DashboardExport(String projectKey, List<Target> dashboards, DashboardsExportService.ScenarioContext context) {
        this(projectKey, DashboardExport.getBaseExportFormat(dashboards), dashboards, context);
    }

    public DashboardExport(String projectKey, ExportFormat format, List<Target> dashboards, DashboardsExportService.ScenarioContext context) {
        super(projectKey, format);
        this.dashboards = dashboards;
        this.context = context;
    }

    public static class Target {
        public static final Integer ALL_SLIDES = null;
        public String dashboardId;
        public List<String> filtersBySlide;
        public ExportFormat exportFormat;
        public Integer slideIndex;

        public Target() {
        }

        public Target(String dashboardId, ExportFormat exportFormat) {
            this(dashboardId, null, ALL_SLIDES, exportFormat);
        }

        public Target(String dashboardId, Integer slideIndex, ExportFormat exportFormat) {
            this(dashboardId, null, slideIndex, exportFormat);
        }

        public Target(String dashboardId, List<String> filtersBySlide, ExportFormat exportFormat) {
            this(dashboardId, filtersBySlide, ALL_SLIDES, exportFormat);
        }

        public Target(String dashboardId, List<String> filtersBySlide, Integer slideIndex, ExportFormat exportFormat) {
            this.dashboardId = dashboardId;
            this.filtersBySlide = filtersBySlide;
            this.slideIndex = slideIndex;
            this.exportFormat = exportFormat;
        }
    }
}

