/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dataflow;

import com.dataiku.dip.coremodel.Partitionable;
import com.dataiku.dip.dao.DatasetsDAO;
import com.dataiku.dip.dataflow.RecipeRunnableSubgraph;
import com.dataiku.dip.dataflow.graph.FlowComputable;
import com.dataiku.dip.dataflow.graph.FlowPartitionable;
import com.dataiku.dip.dataflow.pdep.DimensionDependencyEvaluator;
import com.dataiku.dip.dataflow.pdep.DimensionDependencySpec;
import com.dataiku.dip.dataflow.pdep.EvaluatorFactory;
import com.dataiku.dip.partitioning.DimensionValue;
import com.dataiku.dip.partitioning.Partition;
import com.dataiku.dip.partitioning.PartitioningScheme;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.utils.ErrorContext;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.utils.LazyHashMap;
import com.dataiku.dip.variables.VariablesService;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;

public class ComputeImpactedInputPartitions {
    @Autowired
    private VariablesService variablesService;
    @Autowired
    private DatasetsDAO dao;
    private final RecipeRunnableSubgraph subgraph;
    private final AuthCtx authCtx;
    private final Map<String, List<Partition>> datasetPartitionsCache;
    Map<String, List<Partition>> requiredPartitions = Maps.newHashMap();
    Map<String, Partitionable> partitionables = Maps.newHashMap();
    Map<DimensionDependencySpec, PreparedSpecInfo> specInfos = Maps.newHashMap();
    private static Logger logger = Logger.getLogger((String)"dku.flow.compute.ip");

    public ComputeImpactedInputPartitions(AuthCtx authCtx, RecipeRunnableSubgraph subgraph, Map<String, List<Partition>> datasetPartitionsCache) {
        SpringUtils.getInstance().autowire((Object)this);
        this.subgraph = subgraph;
        this.authCtx = authCtx;
        this.datasetPartitionsCache = datasetPartitionsCache;
    }

    public void prepare_T() throws Exception {
        for (DimensionDependencySpec spec : this.subgraph.getPartitionDeps()) {
            logger.info((Object)("Preparing dependency " + JSON.log((Object)spec)));
            PreparedSpecInfo specInfo = new PreparedSpecInfo();
            this.specInfos.put(spec, specInfo);
            FlowComputable srcComputable = this.subgraph.getSourcesMap().get(spec.inputDataset);
            specInfo.srcObj = ((FlowPartitionable)((Object)srcComputable)).getPartitioned(this.dao);
            PartitioningScheme srcScheme = specInfo.srcObj.getPartitioningSchema();
            if (!srcScheme.isPartitioned()) {
                throw ErrorContext.iaef((String)"Invalid partition dependency, source %s is not partitioned", (Object)srcComputable.getFullId(), (Object[])new Object[0]);
            }
            specInfo.pdepHasOutputDataset = false;
            FlowComputable targetComputable = this.subgraph.getTargetsMap().get(spec.outputDataset);
            if (spec.outputDataset != null && null != targetComputable && targetComputable.isPartitionable()) {
                specInfo.pdepHasOutputDataset = true;
            }
            if (!specInfo.pdepHasOutputDataset) {
                switch (spec.function) {
                    case "values": 
                    case "latest_available": 
                    case "all_available": 
                    case "time_range": {
                        break;
                    }
                    default: {
                        throw ErrorContext.iaef((String)"Dependency %s needs a dataset as output(recipe: %s)", (Object)spec.function, (Object[])new Object[]{this.subgraph.getRecipe().getName()});
                    }
                }
            }
            if (specInfo.pdepHasOutputDataset) {
                assert (targetComputable != null && targetComputable.isPartitionable());
                specInfo.targetObj = ((FlowPartitionable)((Object)targetComputable)).getPartitioned(this.dao);
                PartitioningScheme targetScheme = specInfo.targetObj.getPartitioningSchema();
                if (!targetScheme.isPartitioned()) {
                    switch (spec.function) {
                        case "values": 
                        case "latest_available": 
                        case "all_available": 
                        case "time_range": {
                            break;
                        }
                        default: {
                            throw ErrorContext.iaef((String)"Invalid partition dependency, target %s is not partitioned", (Object)specInfo.targetObj.getFullName(), (Object[])new Object[0]);
                        }
                    }
                }
                if (spec.outputDimension != null && targetScheme.getDimension(spec.outputDimension) == null) {
                    throw ErrorContext.iaef((String)"Invalid partition dependency, target %s has no dimension %s", (Object)specInfo.targetObj.getFullName(), (Object[])new Object[]{spec.outputDimension});
                }
                if (srcScheme.getDimension(spec.inputDimension) == null) {
                    throw ErrorContext.iaef((String)"Invalid partition dependency, source %s has no dimension %s", (Object)specInfo.srcObj.getFullName(), (Object[])new Object[]{spec.inputDimension});
                }
                specInfo.targetPartition = this.subgraph.getTargetPartition(targetComputable);
                assert (specInfo.targetPartition != null);
                specInfo.dep = EvaluatorFactory.build(this.authCtx, this.subgraph.getRecipe().getProjectKey(), this.variablesService, specInfo.srcObj, spec, this.subgraph.isAllTargetPartitions());
                continue;
            }
            specInfo.dep = EvaluatorFactory.build(this.authCtx, this.subgraph.getRecipe().getProjectKey(), this.variablesService, specInfo.srcObj, spec, this.subgraph.isAllTargetPartitions());
        }
        for (FlowPartitionable source : this.subgraph.getPartitionedSources()) {
            Partitionable sourcePartitioned = source.getPartitioned(this.dao);
            this.partitionables.put(source.getFullName(), sourcePartitioned);
        }
    }

    public void work_NT() throws Exception {
        LazyHashMap srcDatasetsMap = new LazyHashMap(SrcDatasetRequiredValues.class);
        for (DimensionDependencySpec dimensionDependencySpec : this.subgraph.getPartitionDeps()) {
            logger.info((Object)("Processing dependency " + JSON.log((Object)dimensionDependencySpec)));
            PreparedSpecInfo specInfo = this.specInfos.get(dimensionDependencySpec);
            SrcDatasetRequiredValues datasetRequiredValues = (SrcDatasetRequiredValues)srcDatasetsMap.getOrCreate((Object)specInfo.srcObj.getFullName());
            PartitioningScheme srcScheme = specInfo.srcObj.getPartitioningSchema();
            if (specInfo.pdepHasOutputDataset) {
                DimensionValue dimensionValue = dimensionDependencySpec.outputDimension != null ? (DimensionValue)specInfo.targetPartition.getDimensionValues().get(dimensionDependencySpec.outputDimension) : null;
                datasetRequiredValues.required.put(dimensionDependencySpec.inputDimension, new ArrayList());
                for (DimensionValue newRequiredValue : specInfo.dep.getDependent(dimensionValue, srcScheme.getDimension(dimensionDependencySpec.inputDimension), this.datasetPartitionsCache)) {
                    datasetRequiredValues.addRequiredValue(dimensionDependencySpec.inputDimension, newRequiredValue);
                }
                continue;
            }
            datasetRequiredValues.required.put(dimensionDependencySpec.inputDimension, new ArrayList());
            for (DimensionValue newRequiredValue : specInfo.dep.getDependent(null, srcScheme.getDimension(dimensionDependencySpec.inputDimension), this.datasetPartitionsCache)) {
                datasetRequiredValues.addRequiredValue(dimensionDependencySpec.inputDimension, newRequiredValue);
            }
        }
        block8: for (FlowPartitionable flowPartitionable : this.subgraph.getPartitionedSources()) {
            SrcDatasetRequiredValues datasetRequiredValues = (SrcDatasetRequiredValues)srcDatasetsMap.get((Object)flowPartitionable.getFullName());
            PartitioningScheme srcScheme = this.partitionables.get(flowPartitionable.getFullName()).getPartitioningSchema();
            if (datasetRequiredValues == null) {
                logger.info((Object)("0 dependency for " + flowPartitionable.getFullName()));
                assert (srcScheme != null);
                if (!srcScheme.isPartitioned()) {
                    logger.info((Object)("source " + flowPartitionable.getFullName() + " is not partitioned, including the global partition"));
                    this.requiredPartitions.put(flowPartitionable.getFullName(), Lists.newArrayList((Object[])new Partition[]{new Partition(null)}));
                    continue;
                }
                throw ErrorContext.iae((String)("for partitioned source " + flowPartitionable.getFullName() + ", don't have enough dependency information to compute required partitions"));
            }
            for (Map.Entry entry : datasetRequiredValues.required.entrySet()) {
                if (((List)entry.getValue()).size() != 0) continue;
                logger.info((Object)("0 required values for dimension " + (String)entry.getKey() + " --> Not adding dependencies on " + flowPartitionable.getFullName()));
                continue block8;
            }
            List<Partition> out = this.cartesianProduct(srcScheme, datasetRequiredValues.required);
            for (Partition p : out) {
                if (p.isComplete()) continue;
                throw new IllegalArgumentException("List of partitions to compute is incomplete: " + String.valueOf(p) + " - scheme is " + StringUtils.join((Collection)p.getScheme().getDimensionNames(), (String)"-"));
            }
            this.requiredPartitions.put(flowPartitionable.getFullName(), out);
        }
        for (FlowComputable flowComputable : this.subgraph.getSources()) {
            switch (flowComputable.getType()) {
                case DATASET: 
                case MANAGED_FOLDER: 
                case MODEL_EVALUATION_STORE: 
                case RETRIEVABLE_KNOWLEDGE: {
                    break;
                }
                case SAVED_MODEL: {
                    if (srcDatasetsMap.containsKey((Object)flowComputable.getFullId())) break;
                    this.requiredPartitions.put(flowComputable.getFullId(), Lists.newArrayList((Object[])new Partition[]{new Partition(null)}));
                    break;
                }
                case STREAMING_ENDPOINT: {
                    break;
                }
            }
        }
    }

    public List<Partition> cartesianProduct(PartitioningScheme scheme, Map<String, List<DimensionValue>> vals) {
        ArrayList<Partition> out = new ArrayList<Partition>();
        int totalNbPartitions = 1;
        for (List<DimensionValue> values : vals.values()) {
            totalNbPartitions *= values.size();
        }
        for (int i = 0; i < totalNbPartitions; ++i) {
            out.add(new Partition(scheme));
        }
        int alreadyHandledProduct = 1;
        for (Map.Entry<String, List<DimensionValue>> le : vals.entrySet()) {
            int repeatValue = alreadyHandledProduct;
            int patternSize = le.getValue().size() * repeatValue;
            int repeatPattern = totalNbPartitions / patternSize;
            for (int p = 0; p < repeatPattern; ++p) {
                int patternBase = p * patternSize;
                for (int valIdx = 0; valIdx < le.getValue().size(); ++valIdx) {
                    for (int repeatIdx = 0; repeatIdx < repeatValue; ++repeatIdx) {
                        int offset = patternBase + valIdx * repeatValue + repeatIdx;
                        ((Partition)out.get(offset)).setDimensionValue(le.getKey(), le.getValue().get(valIdx));
                    }
                }
            }
            alreadyHandledProduct *= le.getValue().size();
        }
        return out;
    }

    public void compute_NT() throws Exception {
        this.work_NT();
        this.subgraph.getSourcePartitions().putAll(this.requiredPartitions);
    }

    public void compute() throws Exception {
        this.prepare_T();
        this.compute_NT();
    }

    private static class PreparedSpecInfo {
        Partitionable srcObj;
        Partitionable targetObj;
        DimensionDependencyEvaluator dep;
        boolean pdepHasOutputDataset;
        Partition targetPartition;

        private PreparedSpecInfo() {
        }
    }

    public static class SrcDatasetRequiredValues {
        Map<String, List<DimensionValue>> required = Maps.newHashMap();

        void addRequiredValue(String dimension, DimensionValue value) {
            List<DimensionValue> alreadyRequired = this.required.get(dimension);
            if (alreadyRequired == null) {
                alreadyRequired = new ArrayList<DimensionValue>();
                this.required.put(dimension, alreadyRequired);
            }
            if (!alreadyRequired.contains(value)) {
                alreadyRequired.add(value);
            }
        }
    }
}

