/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dataflow.exec.autofeaturegeneration;

import com.dataiku.dip.analysis.ml.shared.FeatureGuessUtils;
import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.Schema;
import com.dataiku.dip.coremodel.SchemaColumn;
import com.dataiku.dip.coremodel.SerializedDataset;
import com.dataiku.dip.coremodel.SerializedRecipe;
import com.dataiku.dip.dao.DatasetsDAO;
import com.dataiku.dip.dataflow.JobActivity;
import com.dataiku.dip.dataflow.exec.autofeaturegeneration.AutoFeatureGenerationRecipePayloadParams;
import com.dataiku.dip.dataflow.exec.autofeaturegeneration.AutoFeatureGenerationRecipeSchemaComputer;
import com.dataiku.dip.dataflow.exec.autofeaturegeneration.AutoFeatureGenerationRecipeStatusComputer;
import com.dataiku.dip.dataflow.exec.autofeaturegeneration.FeatureQueryVisitor;
import com.dataiku.dip.dataflow.exec.autofeaturegeneration.RelationshipGraph;
import com.dataiku.dip.dataflow.exec.autofeaturegeneration.TimeWindowQueryVisitor;
import com.dataiku.dip.dataflow.exec.autofeaturegeneration.VariableType;
import com.dataiku.dip.dataflow.exec.join.JoinRecipePayloadParams;
import com.dataiku.dip.dataflow.exec.join.JoinRecipeService;
import com.dataiku.dip.dataflow.exec.joinlike.JoinLikeRecipeUtils;
import com.dataiku.dip.dataflow.exec.joinlike.MatchingConditionBase;
import com.dataiku.dip.dataflow.graph.FlowRecipe;
import com.dataiku.dip.datalayer.memimpl.MemColumn;
import com.dataiku.dip.datalayer.memimpl.MemTable;
import com.dataiku.dip.datasets.DatasetUtils;
import com.dataiku.dip.partitioning.Partition;
import com.dataiku.dip.partitioning.PartitioningScheme;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.server.recipes.GenericRecipesValidationService;
import com.dataiku.dip.server.recipes.ServiceUtils;
import com.dataiku.dip.shaker.model.SerializedShakerScript;
import com.dataiku.dip.shaker.server.DataService;
import com.dataiku.dip.shaker.server.MemScriptRunner;
import com.dataiku.dip.shaker.types.AbstractGeometryMeaning;
import com.dataiku.dip.sql.SQLDialect;
import com.dataiku.dip.sql.SQLUtils;
import com.dataiku.dip.util.AnyLoc;
import com.dataiku.dip.util.DatasetLocUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.ErrorContext;
import com.dataiku.dip.utils.ExceptionUtils;
import com.dataiku.dip.utils.JSON;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;

public class AutoFeatureGenerationRecipeHelper {
    @Autowired
    protected DatasetsDAO datasetsDAO;
    @Autowired
    private GenericRecipesValidationService validationService;
    @Autowired
    private DataService dataService;
    Map<String, SQLUtils.SQLTable> sqlTablesMap;
    Map<String, Dataset> datasetsMap;
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.recipes.autofeaturegeneration");

    public AutoFeatureGenerationRecipeHelper() {
        SpringUtils.getInstance().autowire((Object)this);
    }

    public static AutoFeatureGenerationRecipePayloadParams loadParams(String payload, SerializedRecipe sr) {
        AutoFeatureGenerationRecipePayloadParams params = (AutoFeatureGenerationRecipePayloadParams)JSON.parse((String)payload, AutoFeatureGenerationRecipePayloadParams.class);
        Preconditions.checkNotNull((Object)params, (Object)"Empty parameters");
        return AutoFeatureGenerationRecipeHelper.resolveDatasetNames(params, sr);
    }

    public void initInputDatasets(JobActivity activity, AutoFeatureGenerationRecipePayloadParams params, SQLDialect dialect) throws IOException {
        Preconditions.checkNotNull((Object)params, (Object)"No params");
        Preconditions.checkNotNull((Object)params.virtualInputs, (Object)"No inputs");
        params.validate();
        this.sqlTablesMap = new HashMap<String, SQLUtils.SQLTable>();
        this.initDatasetsConfigurations(activity, params);
        for (String inputName : this.datasetsMap.keySet()) {
            Dataset source = this.datasetsMap.get(inputName);
            logger.trace(() -> "Register dataset " + inputName + " : " + JSON.log((Object)source));
            SQLUtils.SQLTable table = DatasetUtils.getResolvedTableWithSparkSQLFallback(source, dialect, params.engineParams);
            this.sqlTablesMap.put(inputName, table);
        }
    }

    public void initDatasetsConfigurations(JobActivity activity, AutoFeatureGenerationRecipePayloadParams params) throws IOException {
        this.datasetsMap = new HashMap<String, Dataset>();
        Preconditions.checkNotNull((Object)params, (Object)"No params");
        Preconditions.checkNotNull((Object)params.virtualInputs, (Object)"No inputs");
        for (AutoFeatureGenerationRecipePayloadParams.InputDesc vi : params.virtualInputs) {
            Dataset source = ServiceUtils.getDataset(activity, this.datasetsDAO, vi.name);
            this.datasetsMap.put(vi.name, source);
        }
    }

    public static AutoFeatureGenerationRecipePayloadParams resolveDatasetNames(AutoFeatureGenerationRecipePayloadParams params, SerializedRecipe sr) {
        AnyLoc loc;
        ArrayList<String> datasets = new ArrayList<String>(sr.getFlatInputs().size());
        for (SerializedRecipe.RecipeInput in : sr.getFlatInputs()) {
            loc = AnyLoc.resolveSmart(sr.projectKey, in.ref);
            datasets.add(loc.getFullName());
        }
        for (int i = 0; i < params.virtualInputs.size(); ++i) {
            AutoFeatureGenerationRecipePayloadParams.InputDesc vi = (AutoFeatureGenerationRecipePayloadParams.InputDesc)params.virtualInputs.get(i);
            if (vi.index < 0 || vi.index >= datasets.size()) {
                throw ErrorContext.iae((String)("Recipes inputs are incorrect. Input index: " + vi.index));
            }
            loc = DatasetLocUtils.resolveFull((String)datasets.get(vi.index));
            vi.name = loc.getFullName();
            vi.alias = ((DatasetLocUtils.DatasetLoc)loc).getName();
        }
        return params;
    }

    public static boolean isGeo(MemColumn column) {
        return column != null && column.selectedType != null && column.selectedType.type instanceof AbstractGeometryMeaning;
    }

    private static VariableType getVariableType(SchemaColumn sc, MemColumn column) {
        if (AutoFeatureGenerationRecipeHelper.isGeo(column) || sc.getType().isGeo()) {
            return null;
        }
        if (sc.getType().isTemporal()) {
            return VariableType.DATE;
        }
        if (sc.getType().isNumeric()) {
            return VariableType.NUMERIC;
        }
        if (FeatureGuessUtils.isText(column)) {
            return VariableType.TEXT;
        }
        return VariableType.CATEGORY;
    }

    public static VariableType getFallbackVariableType(SchemaColumn sc) {
        if (sc.getType().isGeo()) {
            return null;
        }
        if (sc.getType().isTemporal()) {
            return VariableType.DATE;
        }
        if (sc.getType().isNumeric()) {
            return VariableType.NUMERIC;
        }
        return VariableType.CATEGORY;
    }

    private MemTable createSampleFromDataset(AuthCtx authCtx, String projectKey, Dataset inputDataset) {
        SerializedShakerScript shakerScript = new SerializedShakerScript();
        shakerScript.contextProjectKey = projectKey;
        try {
            MemScriptRunner.TableWithReport result = this.dataService.get_NOTRANSACTION(inputDataset, shakerScript, null, null, true, authCtx);
            return result.table;
        }
        catch (Exception e) {
            logger.warn((Object)String.format("Unable to infer variable types on dataset %s", inputDataset.getName()), (Throwable)e);
            return new MemTable();
        }
    }

    public List<AutoFeatureGenerationRecipePayloadParams.Column> getDefaultColumns_NT(AuthCtx authCtx, String projectKey, Dataset inputDataset) {
        MemTable table = this.createSampleFromDataset(authCtx, projectKey, inputDataset);
        ArrayList<AutoFeatureGenerationRecipePayloadParams.Column> columnsToCompute = new ArrayList<AutoFeatureGenerationRecipePayloadParams.Column>();
        for (SchemaColumn sc : inputDataset.getSchema().columns) {
            String name = sc.getName();
            VariableType variableType = table.columns.get(name) != null ? AutoFeatureGenerationRecipeHelper.getVariableType(sc, table.columns.get(name)) : AutoFeatureGenerationRecipeHelper.getFallbackVariableType(sc);
            if (variableType == null) continue;
            columnsToCompute.add(new AutoFeatureGenerationRecipePayloadParams.Column(name, variableType));
        }
        return columnsToCompute;
    }

    public List<AutoFeatureGenerationRecipePayloadParams.Column> suggestDefaultColumnsForComputation_NT(Dataset inputDataset, SerializedRecipe sr, String payloadData, AuthCtx authCtx, String projectKey) {
        AutoFeatureGenerationRecipePayloadParams params = AutoFeatureGenerationRecipeHelper.loadParams(payloadData, sr);
        for (AutoFeatureGenerationRecipePayloadParams.InputDesc virtualInput : params.virtualInputs) {
            if (!Objects.equals(inputDataset.getFullName(), virtualInput.name)) continue;
            return virtualInput.selectedColumns;
        }
        return this.getDefaultColumns_NT(authCtx, projectKey, inputDataset);
    }

    public SqlQueryCollection generateSqlQueries(AuthCtx authCtx, JobActivity activity, SQLDialect dialect, AutoFeatureGenerationRecipePayloadParams params) throws Exception {
        return this.generateSqlQueries(authCtx, activity, dialect, params, new HashMap<String, PartitioningScheme>(), new HashMap<String, List<Partition>>(), new PartitioningScheme());
    }

    private SqlQueryCollection generateSqlQueries(AuthCtx authCtx, JobActivity activity, SQLDialect dialect, AutoFeatureGenerationRecipePayloadParams params, Map<String, PartitioningScheme> sourcePartitionSchemes, Map<String, List<Partition>> sourcePartitions, PartitioningScheme targetPartitionScheme) throws Exception {
        Schema outputSchema = AutoFeatureGenerationRecipeHelper.inferOutputSchema(authCtx, activity, params);
        Dataset targetDataset = activity.getSubgraph().getSingleTargetDataset().getOrNull(this.datasetsDAO);
        if (targetDataset == null) {
            targetDataset = new Dataset();
        }
        targetDataset.setSchema(outputSchema);
        ArrayList<String> preSelectQueries = new ArrayList<String>();
        ArrayList<String> postSelectQueries = new ArrayList<String>();
        HashMap<Integer, String> viewNameByDataset = new HashMap<Integer, String>();
        RelationshipGraph graph = new RelationshipGraph(params, this.datasetsMap);
        if (params.cutoffTime.mode != null && params.cutoffTime.mode != AutoFeatureGenerationRecipePayloadParams.CutoffTime.CutoffTimeMode.NONE) {
            TimeWindowQueryVisitor timeWindowQueryVisitor = new TimeWindowQueryVisitor(params, dialect, viewNameByDataset, this.datasetsMap, this.sqlTablesMap, graph.cutoffColumn);
            graph.makeTimeWindowFilterJoins(timeWindowQueryVisitor);
            preSelectQueries.addAll(timeWindowQueryVisitor.getPreSelectQueries());
            postSelectQueries.addAll(timeWindowQueryVisitor.getPostSelectQueries());
        }
        FeatureQueryVisitor featureQueryVisitor = new FeatureQueryVisitor(params, dialect, viewNameByDataset, this.datasetsMap, this.sqlTablesMap, targetDataset);
        graph.makeFeatures(featureQueryVisitor);
        preSelectQueries.addAll(featureQueryVisitor.getPreSelectQueries());
        postSelectQueries.addAll(0, featureQueryVisitor.getPostSelectQueries());
        return new SqlQueryCollection(AutoFeatureGenerationRecipeHelper.convertToArray(preSelectQueries), featureQueryVisitor.getSelectQuery(), AutoFeatureGenerationRecipeHelper.convertToArray(postSelectQueries));
    }

    private static String[] convertToArray(List<String> values) {
        return values.toArray(new String[0]);
    }

    private static Schema inferOutputSchema(AuthCtx authCtx, JobActivity activity, AutoFeatureGenerationRecipePayloadParams params) throws Exception {
        AutoFeatureGenerationRecipeSchemaComputer schemaComputer = new AutoFeatureGenerationRecipeSchemaComputer(authCtx, activity);
        schemaComputer.setParams(params);
        return schemaComputer.getSchema();
    }

    public List<JoinRecipePayloadParams.MatchingCondition> suggestRelationshipConditions_T(SerializedRecipe sr, String payload) throws Exception {
        Schema schema2;
        FlowRecipe fr = new FlowRecipe(sr);
        JobActivity activity = new JobActivity(this.validationService.getSampleSubgraph(fr));
        AutoFeatureGenerationRecipePayloadParams params = AutoFeatureGenerationRecipeHelper.loadParams(payload, sr);
        AutoFeatureGenerationRecipePayloadParams.RelationshipDesc relationship = params.relationships.get(params.relationships.size() - 1);
        int table1 = relationship.table1;
        int table2 = relationship.table2;
        String datasetFullName1 = ((AutoFeatureGenerationRecipePayloadParams.InputDesc)params.virtualInputs.get((int)table1)).name;
        String datasetFullName2 = ((AutoFeatureGenerationRecipePayloadParams.InputDesc)params.virtualInputs.get((int)table2)).name;
        Dataset dataset1 = ServiceUtils.getDataset(activity, this.datasetsDAO, datasetFullName1);
        Dataset dataset2 = ServiceUtils.getDataset(activity, this.datasetsDAO, datasetFullName2);
        Schema schema1 = dataset1.getSchema();
        List<JoinRecipePayloadParams.MatchingCondition> suggestions = JoinRecipeService.computeSuggestions(table1, table2, schema1, schema2 = dataset2.getSchema(), true);
        if (suggestions.isEmpty()) {
            suggestions = JoinRecipeService.computeSuggestions(table1, table2, schema1, schema2, false);
        }
        return suggestions;
    }

    public static JoinLikeRecipeUtils.InputReplacementTestResult testVirtualInputReplacement(SerializedRecipe sr, String payload, int virtualInputIndex, SerializedDataset newInput) {
        AutoFeatureGenerationRecipePayloadParams params = AutoFeatureGenerationRecipeHelper.loadParams(payload, sr);
        Preconditions.checkNotNull((Object)params, (Object)"No params");
        Preconditions.checkNotNull((Object)params.virtualInputs, (Object)"No inputs");
        JoinLikeRecipeUtils.InputReplacementTestResult ret = new JoinLikeRecipeUtils.InputReplacementTestResult();
        try {
            Schema newSchema = newInput.getSchema();
            if (JoinLikeRecipeUtils.checkSchemaEmptiness(newSchema)) {
                ret.warn("Dataset schema is empty");
                return ret;
            }
            AutoFeatureGenerationRecipeHelper.checkRelationshipsForReplacement(virtualInputIndex, params.relationships, ret, newSchema);
            AutoFeatureGenerationRecipePayloadParams.InputDesc replacedInput = (AutoFeatureGenerationRecipePayloadParams.InputDesc)params.virtualInputs.get(virtualInputIndex);
            AutoFeatureGenerationRecipeHelper.checkColumnsForReplacement(replacedInput, ret, newSchema);
            if (params.cutoffTime.mode != null) {
                AutoFeatureGenerationRecipeHelper.checkTimeSettingsForReplacement(replacedInput, virtualInputIndex, ret, newSchema);
            }
        }
        catch (Exception e) {
            ret.warn("Failed to complete check: " + ExceptionUtils.getMessageWithCauses((Throwable)e));
        }
        return ret;
    }

    public static void checkRelationshipsForReplacement(int virtualInputIndex, List<AutoFeatureGenerationRecipePayloadParams.RelationshipDesc> relationships, JoinLikeRecipeUtils.InputReplacementTestResult ret, Schema newSchema) {
        for (AutoFeatureGenerationRecipePayloadParams.RelationshipDesc relationship : relationships) {
            if (relationship.table2 == virtualInputIndex) {
                for (MatchingConditionBase matchingConditionBase : relationship.getJoinConditions()) {
                    if (newSchema.hasColumn(matchingConditionBase.column2.name)) continue;
                    ret.warn("Dataset has no column '" + matchingConditionBase.column2.name + "' (used in join condition)");
                }
            }
            if (relationship.table1 != virtualInputIndex) continue;
            for (MatchingConditionBase matchingConditionBase : relationship.getJoinConditions()) {
                if (newSchema.hasColumn(matchingConditionBase.column1.name)) continue;
                ret.warn("Dataset has no column '" + matchingConditionBase.column1.name + "' (used in join condition)");
            }
        }
    }

    public static void checkColumnsForReplacement(AutoFeatureGenerationRecipePayloadParams.InputDesc virtualInput, JoinLikeRecipeUtils.InputReplacementTestResult ret, Schema newSchema) {
        for (AutoFeatureGenerationRecipePayloadParams.Column column : virtualInput.selectedColumns) {
            SchemaColumn newColumn = newSchema.getColumn(column.name);
            if (newColumn == null) {
                ret.warn("Dataset has no column '" + column.name + "' (used in columns for computation)");
                continue;
            }
            if (AutoFeatureGenerationRecipeStatusComputer.checkVariableTypeMatchesStorageType(column, newColumn)) continue;
            ret.warn("The column '" + column.name + "' of the replacement dataset is not compatible with the variable type '" + String.valueOf((Object)column.variableType) + "' (selected in columns for computation)");
        }
    }

    public static void checkTimeSettingsForReplacement(AutoFeatureGenerationRecipePayloadParams.InputDesc virtualInput, int virtualInputIndex, JoinLikeRecipeUtils.InputReplacementTestResult ret, Schema newSchema) {
        if (!StringUtils.isBlank((String)virtualInput.timeIndexColumn)) {
            SchemaColumn newColumn = newSchema.getColumn(virtualInput.timeIndexColumn);
            String columnLabel = AutoFeatureGenerationRecipeHelper.getTimeIndexLabel(virtualInputIndex);
            if (newColumn == null) {
                ret.warn("Dataset has no column '" + virtualInput.timeIndexColumn + "' (used as the " + columnLabel + ")");
            } else if (!newColumn.getType().isTemporal()) {
                ret.warn("The column '" + virtualInput.timeIndexColumn + "' of the replacement dataset is not of type 'datetime with tz', 'date only' or 'datetime no tz' so it cannot be used as a " + columnLabel);
            }
        }
    }

    public static String getTimeIndexLabel(int virtualInputIndex) {
        if (virtualInputIndex == 0) {
            return "cutoff time column";
        }
        return "time index column";
    }

    public static class SqlQueryCollection {
        public static final String STATUS_QUERY_SEPARATOR = "\n\n-- DKU_END_STATEMENT\n\n";
        protected final String[] preSelectQueries;
        protected final String selectQuery;
        protected final String[] postSelectQueries;

        public SqlQueryCollection(String[] preSelectQueries, String selectQuery, String[] postSelectQueries) {
            this.preSelectQueries = preSelectQueries;
            this.selectQuery = selectQuery;
            this.postSelectQueries = postSelectQueries;
        }

        public String combineQueries() {
            ArrayList<String> allQueries = new ArrayList<String>(Arrays.asList(this.preSelectQueries));
            allQueries.add(this.selectQuery);
            allQueries.addAll(Arrays.asList(this.postSelectQueries));
            return String.join((CharSequence)STATUS_QUERY_SEPARATOR, allQueries);
        }
    }
}

