/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dataflow.exec.geojoin;

import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.coremodel.Schema;
import com.dataiku.dip.coremodel.SchemaColumn;
import com.dataiku.dip.coremodel.SerializedRecipe;
import com.dataiku.dip.dataflow.JobActivity;
import com.dataiku.dip.dataflow.exec.VisualSQLRecipePayloadParams;
import com.dataiku.dip.dataflow.exec.computedcolumn.ComputedColumn;
import com.dataiku.dip.dataflow.exec.geojoin.GeoJoinRecipeHelper;
import com.dataiku.dip.dataflow.exec.geojoin.GeoJoinRecipePayloadParams;
import com.dataiku.dip.dataflow.exec.geojoin.GeoJoinRecipeService;
import com.dataiku.dip.dataflow.exec.geojoin.GeoJoinRecipeStatusComputer;
import com.dataiku.dip.dataflow.exec.join.JoinRecipeSchemaComputer;
import com.dataiku.dip.dataflow.exec.joinlike.ColumnDesc;
import com.dataiku.dip.dataflow.exec.joinlike.ConditionsMode;
import com.dataiku.dip.dataflow.exec.joinlike.JoinInputDescBase;
import com.dataiku.dip.dataflow.exec.joinlike.JoinLikeRecipeSchemaComputer;
import com.dataiku.dip.datasets.SchemaUtils;
import com.dataiku.dip.datasets.Type;
import com.dataiku.dip.recipes.RecipeSchemaComputer;
import com.dataiku.dip.recipes.visualsql.VisualSQLRecipesBaseService;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.server.recipes.RecipeSchemaService;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.sql.SQLDialect;
import com.dataiku.dip.sql.queries.ExpressionUtils;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.util.AnyLoc;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.ErrorContext;
import com.dataiku.dip.utils.JSON;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;

public class GeoJoinRecipeSchemaComputer
extends JoinLikeRecipeSchemaComputer
implements RecipeSchemaComputer.RecipeSchemaComputerWithPayload {
    static DKULogger logger = DKULogger.getLogger((String)"dku.recipes.geojoin.schema");
    @Autowired
    private GeoJoinRecipeService service;
    @Autowired
    private VisualSQLRecipesBaseService visualRecipesService;
    @Autowired
    private TransactionService transactionService;
    private final GeoJoinRecipeHelper helper = new GeoJoinRecipeHelper();
    private GeoJoinRecipePayloadParams params;
    private GeoJoinRecipeStatusComputer statusComputer;

    public GeoJoinRecipeSchemaComputer(AuthCtx authCtx, JobActivity activity) {
        super(authCtx, activity);
    }

    @Override
    public void setPayload(String payload) {
        this.params = this.service.loadParams(payload, this.recipe);
        this.statusComputer = new GeoJoinRecipeStatusComputer(this.recipe, payload);
        SpringUtils.getInstance().autowire((Object)this.statusComputer);
    }

    public void setParams(GeoJoinRecipePayloadParams params) {
        this.params = params;
    }

    @Override
    public List<Schema> getSchemasForOutputRole_NT(String role) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            Preconditions.checkArgument((boolean)role.equals("main"), (Object)("Recipe only has output role 'main', got: " + role));
            this.recipesValidationService.checkComplianceWithRecipeDesc(this.authCtx, this.recipe);
            ArrayList arrayList = Lists.newArrayList((Object[])new Schema[]{this.getSchema()});
            return arrayList;
        }
    }

    public Schema getSchema() throws Exception {
        VisualSQLRecipesBaseService.SQLBasedEngineStatus selectedEngine = this.visualRecipesService.getEngine(this.authCtx, this.activity, this.params, this.params.engineType);
        boolean lowerCase = this.visualRecipesService.mustLowerCaseColumnsNames((VisualSQLRecipePayloadParams)this.params, selectedEngine);
        Schema schema = this.getSchemaWithoutComputedColumns();
        if (lowerCase) {
            SchemaUtils.lowerCase(schema);
        }
        return schema;
    }

    public Schema getSchemaWithoutComputedColumns() throws Exception {
        VisualSQLRecipesBaseService.SQLBasedEngineStatus selectedEngine = this.visualRecipesService.getEngine(this.authCtx, this.activity, this.params, this.params.engineType);
        boolean mustLowerCaseColumnsNames = this.visualRecipesService.mustLowerCaseColumnsNames((VisualSQLRecipePayloadParams)this.params, selectedEngine);
        SQLDialect dialect = this.visualRecipesService.getDialect(this.authCtx, this.activity, selectedEngine);
        boolean caseInsensitive = mustLowerCaseColumnsNames || dialect != null && dialect.hasCaseInsensitiveColumns();
        this.helper.initInputDatasets(this.activity, this.params, null, caseInsensitive);
        this.helper.initAliases(this.params, mustLowerCaseColumnsNames);
        if (this.statusComputer != null) {
            GeoJoinRecipeStatusComputer.GeoJoinRecipeStatus status = new GeoJoinRecipeStatusComputer.GeoJoinRecipeStatus();
            status.params = this.params;
            this.statusComputer.checkJoins(status, this.helper);
            InfoMessage.InfoMessages statusMessages = status.gatherAllMessages();
            if (statusMessages.anyFatal()) {
                throw statusMessages.firstFatal().asCodedException();
            }
        }
        HashSet<String> usedColumnNames = new HashSet<String>();
        Schema outputSchema = new Schema();
        for (ColumnDesc cd : this.params.getSelectedColumns()) {
            String alias;
            JoinInputDescBase inputDesc = (JoinInputDescBase)this.params.virtualInputs.get(cd.table);
            Dataset dataset = this.helper.datasetsMap.get(inputDesc.name);
            if (dataset == null) {
                throw ErrorContext.iaef((String)"Dataset not found in inputs: \"%s\"", (Object)inputDesc.name, (Object[])new Object[0]);
            }
            String string = alias = mustLowerCaseColumnsNames ? cd.alias.toLowerCase() : cd.alias;
            if (usedColumnNames.contains(alias)) {
                throw ErrorContext.iaef((String)"Output schema contains duplicate column name \"%s\"", (Object)(mustLowerCaseColumnsNames ? "(lower case) " + alias : alias), (Object[])new Object[0]);
            }
            usedColumnNames.add(alias);
            if (cd.name == null || cd.name.isEmpty()) continue;
            SchemaColumn col = ExpressionUtils.getSchemaColumn(cd.name, dataset.getSchema(), inputDesc.computedColumns);
            outputSchema.addColumn(SchemaColumn.copyWithNewName((String)alias, (SchemaColumn)col));
        }
        return outputSchema;
    }

    @Override
    public boolean canUpdateRecipe() {
        return true;
    }

    @Override
    public RecipeSchemaService.RecipeSchemaAutoupdateResult updateRecipe_NT(JsonObject optionsObj) throws Exception {
        logger.info((Object)("Update recipe options=" + JSON.log((Object)optionsObj)));
        JoinRecipeSchemaComputer.JoinRecipeUpdateOptions options = optionsObj == null ? new JoinRecipeSchemaComputer.JoinRecipeUpdateOptions() : (JoinRecipeSchemaComputer.JoinRecipeUpdateOptions)JSON.parse((JsonElement)optionsObj, JoinRecipeSchemaComputer.JoinRecipeUpdateOptions.class);
        RecipeSchemaService.RecipeSchemaAutoupdateResult ret = new RecipeSchemaService.RecipeSchemaAutoupdateResult();
        List<Schema> inputSchemas = this.getInputSchemasTransaction();
        if (options.removeMissingJoinConditions) {
            this.removeMissingJoinConditions(ret, inputSchemas);
        }
        if (options.removeMissingJoinValues) {
            this.removeMissingValues(ret, inputSchemas);
        }
        if (!options.newSelectedColumns.isEmpty()) {
            this.updateSelectedColumns(options, ret, inputSchemas, this.params);
        }
        if (!ret.recipeChanges.isEmpty()) {
            ret.updatedRecipe = this.recipe;
            ret.updatedPayload = JSON.pretty((Object)this.params);
        }
        return ret;
    }

    private void removeMissingValues(RecipeSchemaService.RecipeSchemaAutoupdateResult ret, List<Schema> inputSchemas) {
        ArrayList columnsToRemove = Lists.newArrayList();
        for (int i = 0; i < this.params.virtualInputs.size(); ++i) {
            JoinInputDescBase inputDesc = (JoinInputDescBase)this.params.virtualInputs.get(i);
            if (inputDesc.outputColumnsSelectionMode == JoinInputDescBase.OutputColumnsSelectionMode.AUTO_NON_CONFLICTING || inputDesc.outputColumnsSelectionMode == JoinInputDescBase.OutputColumnsSelectionMode.ALL) continue;
            Schema schema = inputSchemas.get(i);
            for (ColumnDesc column : this.params.selectedColumns) {
                if (column.table != i || schema.getColumn(column.name) != null) continue;
                columnsToRemove.add(column);
                ret.recipeChanges.add(String.format("Removed selected column %s", column.name));
            }
        }
        this.params.selectedColumns.removeAll(columnsToRemove);
    }

    private void removeMissingJoinConditions(RecipeSchemaService.RecipeSchemaAutoupdateResult ret, List<Schema> inputSchemas) {
        for (GeoJoinRecipePayloadParams.JoinDesc join : this.params.joins) {
            if (join.conditionsMode == ConditionsMode.CUSTOM) continue;
            Schema schema1 = inputSchemas.get(join.table1);
            Schema schema2 = inputSchemas.get(join.table2);
            ArrayList conditionsToRemove = Lists.newArrayList();
            for (GeoJoinRecipePayloadParams.MatchingCondition condition : join.on) {
                if (schema1.getColumn(condition.column1.name) == null) {
                    conditionsToRemove.add(condition);
                    ret.recipeChanges.add(String.format("Removed join condition using %s", condition.column1.name));
                    continue;
                }
                if (schema2.getColumn(condition.column2.name) != null) continue;
                conditionsToRemove.add(condition);
                ret.recipeChanges.add(String.format("Removed join condition using %s", condition.column2.name));
            }
            join.on.removeAll(conditionsToRemove);
        }
    }

    private List<Schema> getInputSchemasTransaction() throws IOException {
        ArrayList inputSchemas = Lists.newArrayList();
        try (Transaction t = this.transactionService.beginRead();){
            List<SerializedRecipe.RecipeInput> recipeInputs = this.recipe.getInputsForRole("main");
            for (JoinInputDescBase inputDesc : this.params.virtualInputs) {
                SerializedRecipe.RecipeInput input = recipeInputs.get(inputDesc.index);
                AnyLoc inputLoc = input.getLoc(this.recipe.projectKey);
                Dataset inputDataset = this.datasetAccessService.getMandatory(inputLoc);
                Schema inputSchema = inputDataset.getSchema();
                if (inputDesc.computedColumns != null) {
                    for (ComputedColumn cc : inputDesc.computedColumns) {
                        inputSchema.addColumn(cc.name, Type.forName((String)cc.type));
                    }
                }
                inputSchemas.add(inputSchema);
            }
        }
        return inputSchemas;
    }
}

