/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dataflow.exec.sort;

import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.SerializedRecipe;
import com.dataiku.dip.dataflow.JobActivity;
import com.dataiku.dip.dataflow.exec.sort.SortRecipePayloadParams;
import com.dataiku.dip.dataflow.exec.sort.SortRecipeSchemaComputer;
import com.dataiku.dip.dataflow.graph.FlowRecipe;
import com.dataiku.dip.datalayer.utils.RecipeCreationUtils;
import com.dataiku.dip.recipes.ManagedDatasetsCreationService;
import com.dataiku.dip.recipes.RecipeMeta;
import com.dataiku.dip.recipes.common.RecipeCreator;
import com.dataiku.dip.recipes.common.SISORecipeCreator;
import com.dataiku.dip.recipes.common.SingleOutputDatasetRecipeCreator;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.server.recipes.SortRecipeService;
import com.dataiku.dip.utils.JSON;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;

public class SortRecipeCreator
extends SISORecipeCreator {
    private SortRecipeService service = new SortRecipeService();

    public SortRecipeCreator(AuthCtx authCtx, RecipeMeta meta) {
        super(authCtx, meta);
        SpringUtils.getInstance().autowire((Object)this.service);
    }

    @Override
    protected void setOutputSchema(SerializedRecipe recipe, String payload, Dataset outputDataset) throws Exception {
        FlowRecipe fr = new FlowRecipe(recipe);
        JobActivity activity = new JobActivity(this.recipesValidationService.getSampleSubgraph(fr));
        SortRecipeSchemaComputer schemaComputer = (SortRecipeSchemaComputer)this.meta.buildSchemaComputer(this.authCtx, activity);
        schemaComputer.setPayload(payload);
        outputDataset.setSchema(schemaComputer.getSchema());
    }

    @Override
    protected String makeInitialPayload(SerializedRecipe recipe, Dataset inputDataset, Dataset outputDataset, JsonObject data) {
        SortRecipePayloadParams params = new SortRecipePayloadParams();
        RecipeCreationUtils.setupAllEnginesCreationParams(this.authCtx, recipe.projectKey, params.engineParams);
        RecipeCreationUtils.switchToHiveserverForHiveDataset(inputDataset, params.engineParams);
        params.engineParams.lowerCaseSchemaIfEngineRequiresIt = true;
        return JSON.json((Object)params);
    }

    @Override
    public RecipeCreator.CreationResult create_NT(SerializedRecipe recipe, JsonObject creationData) throws Exception {
        SingleOutputDatasetRecipeCreator.SingleOutputRecipeCreationSettings settings = (SingleOutputDatasetRecipeCreator.SingleOutputRecipeCreationSettings)JSON.parse((JsonElement)creationData, SingleOutputDatasetRecipeCreator.SingleOutputRecipeCreationSettings.class);
        if (settings.outputDatasetSettings == null) {
            settings.outputDatasetSettings = new ManagedDatasetsCreationService.ManagedDatasetCreationSettings();
        }
        settings.outputDatasetSettings.preserveOrder = true;
        return super.create_NT(recipe, JSON.toJsonObject((Object)settings, (String[])new String[0]));
    }
}

