/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dataflow.exec.sync;

import com.dataiku.dip.connections.DatabricksConnection;
import com.dataiku.dip.connections.SQLConnectionProvider;
import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.dataflow.exec.FlowRunnable;
import com.dataiku.dip.dataflow.exec.SISORecipeExecutor;
import com.dataiku.dip.dataflow.exec.sync.CloudBlobSupport;
import com.dataiku.dip.dataflow.exec.sync.CloudToDatabricks;
import com.dataiku.dip.dataflow.exec.sync.DatabricksSupport;
import com.dataiku.dip.dataflow.exec.sync.FastpathUtils;
import com.dataiku.dip.datasets.Type;
import com.dataiku.dip.datasets.fs.BlobLikeDatasetHandler;
import com.dataiku.dip.datasets.sql.AbstractSQLDatasetHandler;
import com.dataiku.dip.exceptions.CodedException;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.output.Output;
import com.dataiku.dip.partitioning.FilePartitioner;
import com.dataiku.dip.partitioning.Partition;
import com.dataiku.dip.partitioning.PartitioningScheme;
import com.dataiku.dip.sql.SQLDialect;
import com.dataiku.dip.sql.SQLUtils;
import com.dataiku.dip.sql.queries.ExpressionBuilder;
import com.dataiku.dip.sql.queries.ExpressionUtils;
import com.dataiku.dip.util.SecretKeyGenerator;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.JSON;
import java.io.IOException;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;

public abstract class DatabricksToCloud<T extends BlobLikeDatasetHandler<?>>
extends SISORecipeExecutor {
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.recipes.sync.databrickstocloud");

    public boolean isAppendMode() {
        return this.originalWriteMode == Output.WriteMode.APPEND;
    }

    @Override
    public List<FlowRunnable> getRunnables() {
        return Collections.emptyList();
    }

    protected static CloudBlobSupport.CopyMode getCopyMode(Dataset outputDS) throws IOException, DKUSecurityException {
        return DatabricksToCloud.getCopyMode_internal(outputDS, false);
    }

    protected static CloudBlobSupport.CopyMode getCopyModeNoHadoop(Dataset outputDS) throws IOException, DKUSecurityException {
        return DatabricksToCloud.getCopyMode_internal(outputDS, true);
    }

    protected static CloudBlobSupport.CopyMode getCopyMode_internal(Dataset outputDS, boolean noHadoop) throws IOException, DKUSecurityException {
        switch (outputDS.getFormatType()) {
            case "csv": {
                return CloudBlobSupport.getCsvToDatabricks(outputDS, true);
            }
            case "parquet": {
                if (noHadoop) {
                    throw new CloudBlobSupport.CloudBlobToSQLImpossibleException("Input file format not supported: " + outputDS.getFormatType());
                }
                return CloudBlobSupport.getParquetToDatabricks(outputDS);
            }
            case "orcfile": {
                if (noHadoop) {
                    throw new CloudBlobSupport.CloudBlobToSQLImpossibleException("Input file format not supported: " + outputDS.getFormatType());
                }
                return CloudBlobSupport.getOrcToDatabricks(outputDS);
            }
            case "avro": {
                return CloudBlobSupport.getAvroToDatabricks(outputDS);
            }
        }
        throw new CloudBlobSupport.CloudBlobToSQLImpossibleException("Input file format not supported: " + outputDS.getFormatType());
    }

    protected void executeDropTable(Statement stmt, String outputTableName) throws SQLException {
        String drop = "DROP TABLE IF EXISTS %s";
        stmt.execute(String.format(drop, outputTableName));
    }

    private String getWhereClause(SQLDialect dialect, SQLConnectionProvider.SQLConnectionData connData) {
        ExpressionBuilder partitionClause;
        Object whereClause = "";
        if (FastpathUtils.hasInputPartitions(this.inputPartitions) && (partitionClause = ExpressionUtils.getPartitionFilterClause(this.inputDS.getPartitioningSchema(), this.inputDS, (List<Partition>)this.inputPartitions, connData.getDialect())) != null) {
            whereClause = " WHERE " + partitionClause.toSQL(connData.getDialect());
        }
        return whereClause;
    }

    private void unloadToCloud(Dataset inputDS, SQLUtils.SQLTable inputTable, SQLUtils.SQLTable outputTable, String outputPath, CloudBlobSupport.CopyMode mode, SQLConnectionProvider.SQLConnectionWrapper connWrapper, Statement stmt, CloudToDatabricks.DisplayableSQLChunk tableCredentials) throws SQLException {
        String sql = "%s USING %s %s LOCATION '%s' %s";
        Dataset temporaryDS = (Dataset)JSON.deepCopy((Object)inputDS);
        temporaryDS.getParamsAs(AbstractSQLDatasetHandler.AbstractSQLConfig.class).table = outputTable.getTable();
        temporaryDS.getParamsAs(AbstractSQLDatasetHandler.AbstractSQLConfig.class).schema = outputTable.getSchemaNullIfBlank();
        temporaryDS.getParamsAs(AbstractSQLDatasetHandler.AbstractSQLConfig.class).catalog = outputTable.getCatalog();
        SQLDialect dialect = connWrapper.getDialect();
        String fullyQuotedOutputTable = dialect.getQuotedTableFullName(outputTable);
        String creationSQL = dialect.getCreateTableStatementSQL(connWrapper.getConnectionData().getConnection(), temporaryDS, new InfoMessage.InfoMessages(), false);
        String formatOptions = DatabricksSupport.generateFormatOption(mode);
        String options = StringUtils.isBlank((String)formatOptions) ? "" : String.format("OPTIONS ( %s )", formatOptions);
        String cmd = String.format(sql, creationSQL, DatabricksSupport.generateFormat(mode), options, outputPath, tableCredentials.sql);
        String displayableCmd = String.format(sql, creationSQL, DatabricksSupport.generateFormat(mode), options, outputPath, tableCredentials.displayedSql);
        logger.info((Object)("Create output table with: \n" + displayableCmd));
        stmt.execute(cmd);
        this.fillTemporaryTable(connWrapper, dialect, inputTable.getCatalog(), inputTable.getSchemaNullIfBlank(), inputTable.getTable(), fullyQuotedOutputTable);
    }

    private void fillTemporaryTable(SQLConnectionProvider.SQLConnectionWrapper conn, SQLDialect dialect, String catalog, String schema, String inputTableId, String fullyQuotedOutputTable) throws SQLException {
        logger.info((Object)"Filling temporary Databricks table from INSERT SELECT");
        String sql = this.createInsertSelectSqlRequest(dialect, catalog, schema, inputTableId, fullyQuotedOutputTable);
        SQLUtils.safeExec(conn, sql, true);
    }

    private String createInsertSelectSqlRequest(SQLDialect dialect, String catalog, String schema, String sourceTableId, String fullyQuotedOutputTable) {
        StringBuilder request = new StringBuilder();
        request.append("INSERT INTO ").append(fullyQuotedOutputTable);
        request.append("\n");
        request.append("SELECT ").append(String.join((CharSequence)",", this.getColumnNamesAndReplaceDates(this.inputDS, dialect)));
        request.append("\n");
        request.append("FROM ").append(dialect.getQuotedTableFullName(catalog, schema, sourceTableId));
        PartitioningScheme scheme = this.outputPartition.getScheme();
        if (scheme != null && scheme.isPartitioned()) {
            request.append("\n");
            request.append("WHERE ").append(dialect.getPartitionFilterClause(this.inputDS, this.outputPartition));
        }
        return request.toString();
    }

    private List<String> getColumnNamesAndReplaceDates(Dataset dataset, SQLDialect dialect) {
        String assumedTz = dataset.getParamsAs(AbstractSQLDatasetHandler.AbstractSQLConfig.class).getAssumedJavaTzForUnknownTz();
        Set dimensionSet = dataset.getPartitioningSchema().getDimensionNamesSet();
        return dataset.getSchema().getColumns().stream().map(input -> {
            String quotedName = dialect.quoteIdentifier(input.getName());
            return input.getType() == Type.DATE ? String.format(this.getDateReplacementQueryTemplate(assumedTz, input.originalType, dataset.isManaged()), quotedName, quotedName) : dialect.quoteIdentifier(input.getName()) + " as " + quotedName;
        }).collect(Collectors.toList());
    }

    private boolean hasTimeZoneInformation(String originalType) {
        return "TIMESTAMP".equalsIgnoreCase(originalType);
    }

    protected String getDateReplacementQueryTemplate(String assumedTz, String originalType, boolean isManaged) {
        if (isManaged || this.hasTimeZoneInformation(originalType)) {
            return "CONVERT_TIMEZONE('UTC', %s) as %s";
        }
        return "CONVERT_TIMEZONE('" + assumedTz + "', 'UTC', %s) as %s";
    }

    protected void cleanup(Statement stmt, String outputTable) throws SQLException {
        try {
            this.executeDropTable(stmt, outputTable);
        }
        catch (Exception e) {
            logger.warn((Object)"Failed to cleanup table used for unloading", (Throwable)e);
        }
    }

    protected void executeCopyStatementFromCloud(Statement stmt, String fullyQuotedOutputTable, String fullyQuotedInputTable, String outputPath, CloudBlobSupport.CopyMode mode, SQLConnectionProvider.SQLConnectionWrapper connWrapper, CloudToDatabricks.DisplayableSQLChunk tableCredentials) throws SQLException {
        String sql = "CREATE TABLE %s USING %s %s LOCATION '%s' %s AS  SELECT * FROM %s %s";
        String formatOptions = DatabricksSupport.generateFormatOption(mode);
        String options = StringUtils.isBlank((String)formatOptions) ? "" : String.format("OPTIONS ( %s )", formatOptions);
        String whereClause = this.getWhereClause(connWrapper.getDialect(), connWrapper.getConnectionData());
        String cmd = String.format(sql, fullyQuotedOutputTable, DatabricksSupport.generateFormat(mode), options, outputPath, tableCredentials.sql, fullyQuotedInputTable, whereClause);
        String displayableCmd = String.format(sql, fullyQuotedOutputTable, DatabricksSupport.generateFormat(mode), options, outputPath, tableCredentials.displayedSql, fullyQuotedInputTable, whereClause);
        SQLUtils.execute(connWrapper, stmt, cmd, displayableCmd, true, true);
    }

    abstract CloudToDatabricks.DisplayableSQLChunk getCredentials(T var1, SQLConnectionProvider.SQLConnectionData var2) throws SQLException, IOException, DKUSecurityException;

    abstract String getStorageCredentials(T var1, SQLConnectionProvider.SQLConnectionData var2);

    abstract void setUpCredentials(T var1, SQLConnectionProvider.SQLConnectionData var2, Statement var3) throws SQLException, IOException, DKUSecurityException;

    abstract String getRoot(T var1) throws CodedException, IOException, DKUSecurityException;

    boolean containsTemporalColumn(Dataset dataset) {
        return dataset.getSchema().columns.stream().anyMatch(schemaColumn -> schemaColumn.getType().isTemporal());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void executeCopy(SQLConnectionProvider.SQLConnectionWrapper connWrapper, T blobHandler, CloudBlobSupport.CopyMode mode, SQLUtils.SQLTable inputTable) throws SQLException, IOException, DKUSecurityException, CodedException {
        SQLDialect dialect = connWrapper.getDialect();
        Object rootPath = this.getRoot(blobHandler);
        PartitioningScheme scheme = this.outputPartition.getScheme();
        if (scheme != null && scheme.isPartitioned()) {
            while (((String)rootPath).endsWith("/")) {
                rootPath = ((String)rootPath).substring(0, ((String)rootPath).length() - 1);
            }
            rootPath = (String)rootPath + "/" + FilePartitioner.computePartitionRelPathAsFolder(this.outputPartition, scheme);
        }
        DatabricksConnection databricksConnection = (DatabricksConnection)connWrapper.getConnectionData().getConnection();
        String targetCatalog = DatabricksSupport.getCatalog(inputTable, databricksConnection, "main");
        String targetSchema = DatabricksSupport.getSchema(inputTable, databricksConnection, "default");
        String tempTable = "tmp_unload_" + SecretKeyGenerator.generate((int)10);
        try (Statement stmt = connWrapper.createStatement();){
            SQLUtils.SQLTable outputTable;
            CloudToDatabricks.DisplayableSQLChunk tableCredentials = this.getCredentials(blobHandler, connWrapper.getConnectionData());
            if (tableCredentials == null) {
                try {
                    this.setUpCredentials(blobHandler, connWrapper.getConnectionData(), stmt);
                }
                catch (SQLException exc) {
                    if (databricksConnection.params.suspectSQLWarehouse()) {
                        throw new SQLException("Error while setting up credentials. If you are running a SQL Warehouse cluster, you need to define storage credentials.", exc);
                    }
                    throw exc;
                }
                tableCredentials = new CloudToDatabricks.DisplayableSQLChunk("");
                String catalog = this.isUnityCatalogEnabled(stmt) ? targetCatalog : null;
                outputTable = new SQLUtils.SQLTable(catalog, targetSchema, tempTable);
            } else if (StringUtils.isBlank((String)tableCredentials.sql)) {
                String catalog = this.isUnityCatalogEnabled(stmt) ? targetCatalog : null;
                outputTable = new SQLUtils.SQLTable(catalog, targetSchema, tempTable);
            } else {
                outputTable = new SQLUtils.SQLTable(targetCatalog, targetSchema, tempTable);
            }
            this.executeDropTable(stmt, dialect.getQuotedTableFullName(outputTable));
            try {
                if (this.isAppendMode() || this.containsTemporalColumn(this.inputDS)) {
                    this.unloadToCloud(this.inputDS, inputTable, outputTable, (String)rootPath, mode, connWrapper, stmt, tableCredentials);
                } else {
                    this.executeCopyStatementFromCloud(stmt, dialect.getQuotedTableFullName(outputTable), dialect.getQuotedTableFullName(inputTable), (String)rootPath, mode, connWrapper, tableCredentials);
                }
            }
            finally {
                this.cleanup(stmt, dialect.getQuotedTableFullName(outputTable));
            }
        }
    }

    private boolean isUnityCatalogEnabled(Statement stmt) {
        String checkUnityEnableSQL = "DESCRIBE CATALOG `main`";
        logger.info((Object)("Checking whether Unity Catalog is enabled on this cluster: " + checkUnityEnableSQL));
        try {
            stmt.execute(checkUnityEnableSQL);
            logger.info((Object)"Unity Catalog is enabled on this cluster");
        }
        catch (SQLException e) {
            if (e.getMessage().contains("[UC_NOT_ENABLED]")) {
                logger.info((Object)"Unity Catalog is not enabled on this cluster");
                return false;
            }
            logger.warn((Object)"Unable to check whether Unity catalog is enabled on this cluster. Considering it is enabled.", (Throwable)e);
        }
        return true;
    }
}

