/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dataflow.exec.sync;

import com.dataiku.dip.connections.DatabricksConnection;
import com.dataiku.dip.connections.SQLConnectionProvider;
import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.dataflow.exec.sync.CloudBlobSupport;
import com.dataiku.dip.dataflow.exec.sync.CloudToDatabricks;
import com.dataiku.dip.dataflow.exec.sync.FastPathDatasetTypeStraightener;
import com.dataiku.dip.datasets.DatasetHandler;
import com.dataiku.dip.datasets.fs.DatabricksVolumeDatasetHandler;
import com.dataiku.dip.datasets.sql.AbstractSQLTableDatasetHandler;
import com.dataiku.dip.datasets.sql.BuiltinSQLDatasets;
import com.dataiku.dip.exceptions.CodedException;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.input.DatasetHandlerFactory;
import com.dataiku.dip.output.Output;
import com.dataiku.dip.recipes.common.RecipeEngineStatus;
import com.dataiku.dip.sql.SQLUtils;
import com.dataiku.dip.utils.DKULogger;
import java.io.IOException;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.commons.lang.StringUtils;

public class DatabricksVolumeToDatabricks
extends CloudToDatabricks<DatabricksVolumeDatasetHandler> {
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.recipes.sync.dbvolumetodatabricks");

    public static void setCompatible(Dataset inputDS, Dataset outputDS, RecipeEngineStatus status) throws IOException, DKUSecurityException {
        DatasetHandler.DatasetMeta<?, ?> outputMeta = DatasetHandlerFactory.getMeta(outputDS);
        status.isSelectable = true;
        if (!new FastPathDatasetTypeStraightener().isEquivalentTo(inputDS, "DatabricksVolume")) {
            status.markAsNonSelectable("Input dataset is not in Databricks volume", RecipeEngineStatus.WarningLevel.ERROR);
            return;
        }
        if (outputMeta != BuiltinSQLDatasets.DATABRICKS_META) {
            status.markAsNonSelectable("Output dataset is not in Databricks", RecipeEngineStatus.WarningLevel.ERROR);
            return;
        }
        try {
            DatabricksVolumeToDatabricks.getCopyModeNoHadoop(inputDS);
        }
        catch (CloudBlobSupport.CloudBlobToSQLImpossibleException e) {
            status.markAsNonSelectable(e.getMessage(), RecipeEngineStatus.WarningLevel.ERROR);
        }
    }

    @Override
    void setUpCredentials(DatabricksVolumeDatasetHandler blobHandler, SQLConnectionProvider.SQLConnectionData connData, Statement stmt) throws SQLException {
    }

    @Override
    String getRoot(DatabricksVolumeDatasetHandler blobHandler) throws CodedException, IOException, DKUSecurityException {
        return blobHandler.getInformationalRootPath();
    }

    @Override
    CloudToDatabricks.DisplayableSQLChunk getCredentials(DatabricksVolumeDatasetHandler blobDShandler, SQLConnectionProvider.SQLConnectionData connData) throws DKUSecurityException, IOException {
        String volume = blobDShandler.getVolume();
        String storageCredential = ((DatabricksConnection)connData.getConnection()).params.getStorageCredentials(volume);
        if (storageCredential == null) {
            return new CloudToDatabricks.DisplayableSQLChunk("");
        }
        if (StringUtils.isBlank((String)storageCredential)) {
            return new CloudToDatabricks.DisplayableSQLChunk("");
        }
        return new CloudToDatabricks.DisplayableSQLChunk(String.format("WITH ( CREDENTIAL `%s` )", storageCredential));
    }

    @Override
    public void run() throws Exception {
        try (AbstractSQLTableDatasetHandler vti = (AbstractSQLTableDatasetHandler)DatasetHandlerFactory.build(this.authCtx, this.outputDS);
             DatabricksVolumeDatasetHandler sdh = (DatabricksVolumeDatasetHandler)new FastPathDatasetTypeStraightener().getDatasetHandler(this.authCtx, this.inputDS);){
            SQLConnectionProvider.SQLConnectionData connData = vti.getConnectionData();
            SQLUtils.SQLTable outputTable = vti.getResolvedTable();
            CloudBlobSupport.CopyMode copyMode = DatabricksVolumeToDatabricks.getCopyMode(this.inputDS);
            boolean isAppendMode = this.originalWriteMode == Output.WriteMode.APPEND;
            SQLConnectionProvider.SQLConnectionWrapper connection = vti.newConnection();
            try {
                SQLUtils.executePreWriteStatements(connData, connection, this.outputDS);
                this.prepareOutputTable(connection, connData);
                this.executeCopy(connData, connection, sdh, copyMode, this.outputDS, outputTable, isAppendMode);
                SQLUtils.executePostWriteStatements(connData, connection, this.outputDS);
                connection.close();
            }
            catch (Exception e) {
                logger.error((Object)"Databricks load failed", (Throwable)e);
                SQLUtils.unsafeRollbackAndClose(connection);
                throw e;
            }
        }
    }
}

