/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dataflow.exec.window;

import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.Schema;
import com.dataiku.dip.coremodel.SchemaColumn;
import com.dataiku.dip.coremodel.SerializedRecipe;
import com.dataiku.dip.dataflow.exec.window.WindowRecipePayloadParams;
import com.dataiku.dip.datalayer.utils.RecipeCreationUtils;
import com.dataiku.dip.datasets.DatasetInspector;
import com.dataiku.dip.recipes.RecipeMeta;
import com.dataiku.dip.recipes.common.SISORecipeCreator;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.server.recipes.WindowRecipeService;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.JSON;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.gson.JsonObject;
import java.util.HashSet;

public class WindowRecipeCreator
extends SISORecipeCreator {
    private WindowRecipeService service = new WindowRecipeService();
    protected static final DKULogger logger = DKULogger.getLogger((String)"dku.recipes.window.creator");

    public WindowRecipeCreator(AuthCtx authCtx, RecipeMeta meta) {
        super(authCtx, meta);
        SpringUtils.getInstance().autowire((Object)this.service);
    }

    @Override
    protected void setOutputSchema(SerializedRecipe recipe, String payload, Dataset outputDataset) throws Exception {
        Dataset inputDataset = this.getInputDataset(recipe);
        WindowRecipePayloadParams params = this.service.loadParams(payload, recipe);
        Schema outputSchema = this.service.getOutputSchemaAfterOverride(inputDataset, params, false, null);
        outputDataset.setSchema(outputSchema);
    }

    @Override
    protected String makeInitialPayload(SerializedRecipe recipe, Dataset inputDataset, Dataset outputDataset, JsonObject data) {
        WindowRecipePayloadParams params = new WindowRecipePayloadParams();
        params.windows = Lists.newArrayList((Object[])new WindowRecipePayloadParams.WindowDesc[]{new WindowRecipePayloadParams.WindowDesc()});
        RecipeCreationUtils.setupAllEnginesCreationParams(this.authCtx, recipe.projectKey, params.engineParams);
        RecipeCreationUtils.switchToHiveserverForHiveDataset(inputDataset, params.engineParams);
        params.engineParams.lowerCaseSchemaIfEngineRequiresIt = true;
        params.legacyUnboundedWindowStreamBehavior = false;
        HashSet excludedFromInput = Sets.newHashSet();
        if (outputDataset.getPartitioningSchema() != null && outputDataset.getPartitioningSchema().isPartitioned() && DatasetInspector.arePartitioningColumnsForbiddenInSchema(outputDataset)) {
            excludedFromInput.addAll(outputDataset.getPartitioningSchema().getDimensionNames());
        }
        params.retrievedColumnsSelectionMode = excludedFromInput.isEmpty() ? WindowRecipePayloadParams.RetrievedColumnsSelectionMode.ALL : WindowRecipePayloadParams.RetrievedColumnsSelectionMode.EXPLICIT;
        for (SchemaColumn col : inputDataset.getSchema().getColumns()) {
            WindowRecipePayloadParams.WindowValue cc = new WindowRecipePayloadParams.WindowValue();
            cc.column = col.getName();
            cc.value = !excludedFromInput.contains(cc.column);
            params.values.add(cc);
        }
        return JSON.json((Object)params);
    }
}

