/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dataflow.streaming;

import com.dataiku.dip.DKUApp;
import com.dataiku.dip.connections.AbstractSQLConnection;
import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.Schema;
import com.dataiku.dip.coremodel.SchemaColumn;
import com.dataiku.dip.coremodel.SerializedDataset;
import com.dataiku.dip.coremodel.SerializedRecipe;
import com.dataiku.dip.dao.DatasetsDAO;
import com.dataiku.dip.dao.StreamingEndpointsDAO;
import com.dataiku.dip.dataflow.JobActivity;
import com.dataiku.dip.dataflow.RecipeRunnableSubgraph;
import com.dataiku.dip.dataflow.RunnableSubgraph;
import com.dataiku.dip.dataflow.graph.FlowComputable;
import com.dataiku.dip.dataflow.jobrunner.ActivityRunner;
import com.dataiku.dip.dataflow.jobrunner.JobContext;
import com.dataiku.dip.dataflow.kernel.slave.KernelSession;
import com.dataiku.dip.dataflow.streaming.DatasetWriteRequest;
import com.dataiku.dip.dataflow.streaming.DatasetWriter;
import com.dataiku.dip.dataflow.streaming.slave.CAKernelSession;
import com.dataiku.dip.datalayer.Column;
import com.dataiku.dip.datalayer.ColumnFactory;
import com.dataiku.dip.datalayer.Row;
import com.dataiku.dip.datalayer.RowFactory;
import com.dataiku.dip.datalayer.streamimpl.StreamColumnFactory;
import com.dataiku.dip.datalayer.streamimpl.StreamRowFactory;
import com.dataiku.dip.datasets.DatasetHandler;
import com.dataiku.dip.datasets.SchemaUtils;
import com.dataiku.dip.datasets.Type;
import com.dataiku.dip.datasets.streamwrite.StreamWriter;
import com.dataiku.dip.datasets.streamwrite.StreamWriterFactory;
import com.dataiku.dip.input.DatasetHandlerFactory;
import com.dataiku.dip.input.formats.csv.RFC4180CSVParser;
import com.dataiku.dip.input.stream.InputStreamLineReader;
import com.dataiku.dip.input.stream.LineReader;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.streaming.endpoints.StreamingEndpointSimpleWriter;
import com.dataiku.dip.streaming.endpoints.StreamingEndpointsRegistry;
import com.dataiku.dip.streaming.endpoints.model.StreamingEndpoint;
import com.dataiku.dip.util.AnyLoc;
import com.dataiku.dip.util.DatasetLocUtils;
import com.dataiku.dip.util.SecretKeyGenerator;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.warnings.WarningsContext;
import com.google.common.base.Preconditions;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;

class DatasetWriteSession {
    private static final Pattern DATETIMENOTZ_EXTRACTOR = Pattern.compile("([0-9]{4}-[0-9]{2}-[0-9]{2}).([0-9]{2}:[0-9]{2}:[0-9]{2})(\\.[0-9]+)?.*");
    private static final String HEARTBEAT_FREQUENCY_PROP = "dku.writesession.heartbeatInSeconds";
    private final String id;
    private final DatasetWriteRequest writeRequest;
    private int heartbeatFrequency;
    private final KernelSession jekKernelSession;
    private final CAKernelSession caKernelSession;
    private WarningsContext warningsContext;
    private State state = State.INITIALIZED;
    private Throwable error;
    private long writtenRows;
    AuthCtx authCtx;
    private volatile boolean closed;
    private Dataset targetDataset;
    private StreamingEndpoint targetSE;
    @Autowired
    private DatasetsDAO datasetsDAO;
    @Autowired
    private StreamingEndpointsDAO streamingEndpointsDAO;
    private DatasetHandler datasetHandler;
    private StreamWriter datasetStreamWriter;
    private ColumnFactory columnFactory = new StreamColumnFactory();
    private RowFactory rowFactory = new StreamRowFactory();
    private StreamingEndpointSimpleWriter streamWriteProcessor;
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.datasets");

    DatasetWriteSession(AuthCtx authCtx, DatasetWriteRequest writeRequest, KernelSession jekKernelSession, CAKernelSession caKernelSession) throws Exception {
        SpringUtils.getInstance().autowire((Object)this);
        this.authCtx = authCtx;
        this.writeRequest = (DatasetWriteRequest)Preconditions.checkNotNull((Object)writeRequest);
        this.id = SecretKeyGenerator.generate((int)10);
        this.heartbeatFrequency = DKUApp.getParams().getIntParam(HEARTBEAT_FREQUENCY_PROP, Integer.valueOf(3600));
        logger.info((Object)("Write session has heartbeat frequency set to " + this.heartbeatFrequency + " seconds"));
        this.jekKernelSession = jekKernelSession;
        this.caKernelSession = caKernelSession;
        switch (writeRequest.targetType) {
            case DATASET: {
                DatasetLocUtils.DatasetLoc loc = DatasetLocUtils.resolveFull(writeRequest.fullDatasetName);
                SerializedDataset sd = (SerializedDataset)this.datasetsDAO.getMandatory(loc);
                this.targetDataset = Dataset.fromSerialized(sd);
                this.sanityChecks();
                break;
            }
            case STREAMING_ENDPOINT: {
                AnyLoc loc = AnyLoc.resolveFull(writeRequest.fullStreamingEndpointId);
                this.targetSE = (StreamingEndpoint)this.streamingEndpointsDAO.getMandatory(loc);
                break;
            }
            case MANAGED_FOLDER: 
            case SAVED_MODEL: 
            case MODEL_EVALUATION_STORE: 
            case RETRIEVABLE_KNOWLEDGE: {
                throw new Error("unreachable");
            }
        }
        if (writeRequest.method == DatasetWriteRequest.Method.STREAM_CONTINUOUS) {
            logger.info((Object)"Initializing stuff for continuous streaming");
            if (writeRequest.targetType == FlowComputable.FCType.DATASET) {
                this.datasetHandler = DatasetHandlerFactory.build(authCtx, this.targetDataset);
                this.datasetStreamWriter = StreamWriterFactory.build(authCtx, this.datasetHandler, writeRequest.sourceId, writeRequest.splitId);
                this.datasetStreamWriter.setColumnFactory(this.columnFactory);
            } else if (writeRequest.targetType == FlowComputable.FCType.STREAMING_ENDPOINT) {
                this.streamWriteProcessor = StreamingEndpointsRegistry.getMeta(this.targetSE).getSimpleWriter(authCtx, this.targetSE, this.columnFactory, this.warningsContext);
                this.streamWriteProcessor.init();
            }
        }
    }

    public void setWarningsContext(WarningsContext warningsContext) {
        this.warningsContext = warningsContext;
    }

    public synchronized long getWrittenRows() {
        return this.writtenRows;
    }

    public synchronized void setWrittenRows(long v) {
        this.writtenRows = v;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeAtOnceFromCSVFile(Schema dataSchema, File dataFile) throws Exception {
        DatasetWriteSession datasetWriteSession = this;
        synchronized (datasetWriteSession) {
            this.enterState(State.STREAMING);
        }
        try (DatasetWriter writer = DatasetWriter.build(this.authCtx, this.getTargetDataset(), this.writeRequest.partitionSpec, this.warningsContext, this.writeRequest.writeMode, this.writeRequest.fixedId, this.columnFactory);){
            try (FileInputStream fileInputStream = new FileInputStream(dataFile);){
                this.appendFromCSVStream(writer, dataSchema, fileInputStream);
            }
            this.writtenRows = writer.getWrittenRows();
        }
        datasetWriteSession = this;
        synchronized (datasetWriteSession) {
            this.enterState(State.SUCCESS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeAtOnceFromCSVStream(Schema dataSchema, InputStream is) throws Exception {
        DatasetWriteSession datasetWriteSession = this;
        synchronized (datasetWriteSession) {
            this.enterState(State.STREAMING);
        }
        try (DatasetWriter writer = DatasetWriter.build(this.authCtx, this.getTargetDataset(), this.writeRequest.partitionSpec, this.warningsContext, this.writeRequest.writeMode, this.writeRequest.fixedId, this.columnFactory);){
            this.appendFromCSVStream(writer, this.writeRequest.dataSchema, is);
            this.writtenRows = writer.getWrittenRows();
        }
        DatasetWriteSession datasetWriteSession2 = this;
        synchronized (datasetWriteSession2) {
            this.enterState(State.SUCCESS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void appendContinuousChunkFromCSVStream(InputStream is) throws Exception {
        logger.info((Object)"Appending continuous chunk from CSV stream");
        assert (this.writeRequest != null);
        assert (this.writeRequest.dataSchema != null);
        ArrayList<Column> columns = new ArrayList<Column>();
        ArrayList<Boolean> needIntegerNormalization = new ArrayList<Boolean>();
        ArrayList<Boolean> needDateOnlyNormalization = new ArrayList<Boolean>();
        ArrayList<Boolean> needDatetimeNoTzNormalization = new ArrayList<Boolean>();
        switch (this.writeRequest.targetType) {
            case DATASET: {
                for (SchemaColumn sc : this.writeRequest.dataSchema.getColumns()) {
                    columns.add(this.datasetStreamWriter.getColumnFactory().column(sc.getName()));
                    SchemaColumn datasetSC = this.targetDataset.getSchema().getColumn(sc.getName());
                    if (datasetSC != null && datasetSC.getType().isInteger()) {
                        needIntegerNormalization.add(true);
                    } else {
                        needIntegerNormalization.add(false);
                    }
                    if (datasetSC != null && datasetSC.getType() == Type.DATEONLY) {
                        needDateOnlyNormalization.add(true);
                    } else {
                        needDateOnlyNormalization.add(false);
                    }
                    if (datasetSC != null && datasetSC.getType() == Type.DATETIMENOTZ) {
                        needDatetimeNoTzNormalization.add(true);
                        continue;
                    }
                    needDatetimeNoTzNormalization.add(false);
                }
                break;
            }
            case STREAMING_ENDPOINT: {
                for (SchemaColumn sc : this.writeRequest.dataSchema.getColumns()) {
                    columns.add(this.columnFactory.column(sc.getName()));
                    SchemaColumn streamingEndpointSC = this.targetSE.schema.getColumn(sc.getName());
                    if (streamingEndpointSC != null && streamingEndpointSC.getType().isInteger()) {
                        needIntegerNormalization.add(true);
                    } else {
                        needIntegerNormalization.add(false);
                    }
                    if (streamingEndpointSC != null && streamingEndpointSC.getType() == Type.DATEONLY) {
                        needDateOnlyNormalization.add(true);
                    } else {
                        needDateOnlyNormalization.add(false);
                    }
                    if (streamingEndpointSC != null && streamingEndpointSC.getType() == Type.DATETIMENOTZ) {
                        needDatetimeNoTzNormalization.add(true);
                        continue;
                    }
                    needDatetimeNoTzNormalization.add(false);
                }
                break;
            }
            case MANAGED_FOLDER: 
            case SAVED_MODEL: 
            case MODEL_EVALUATION_STORE: 
            case RETRIEVABLE_KNOWLEDGE: {
                throw new Error("unreachable");
            }
        }
        Iterator iterator = this;
        synchronized (iterator) {
            this.enterState(State.STREAMING);
        }
        BufferedInputStream bis = new BufferedInputStream(is);
        InputStreamLineReader islr = new InputStreamLineReader((InputStream)bis, StandardCharsets.UTF_8);
        RFC4180CSVParser csvParser = new RFC4180CSVParser((LineReader)islr, ',');
        ArrayList<String> rowBuffer = new ArrayList<String>();
        switch (this.writeRequest.targetType) {
            case DATASET: {
                Row row;
                assert (this.datasetStreamWriter != null);
                while (csvParser.next(rowBuffer)) {
                    row = this.rowFactory.row();
                    this.handleNormalizations(row, rowBuffer, needIntegerNormalization, needDateOnlyNormalization, needDatetimeNoTzNormalization, columns);
                    this.datasetStreamWriter.append(row);
                    if (++this.writtenRows % 10000L != 0L) continue;
                    logger.info((Object)("Emitted " + this.writtenRows + " rows"));
                }
                break;
            }
            case STREAMING_ENDPOINT: {
                Row row;
                while (csvParser.next(rowBuffer)) {
                    row = this.rowFactory.row();
                    this.handleNormalizations(row, rowBuffer, needIntegerNormalization, needDateOnlyNormalization, needDatetimeNoTzNormalization, columns);
                    this.streamWriteProcessor.processRow(row);
                    if (++this.writtenRows % 10000L != 0L) continue;
                    logger.info((Object)("Emitted " + this.writtenRows + " rows"));
                }
                break;
            }
            case MANAGED_FOLDER: 
            case SAVED_MODEL: 
            case MODEL_EVALUATION_STORE: 
            case RETRIEVABLE_KNOWLEDGE: {
                throw new Error("unreachable");
            }
        }
        DatasetWriteSession datasetWriteSession = this;
        synchronized (datasetWriteSession) {
            this.enterState(State.WAITING_FOR_MORE_DATA);
        }
    }

    public void checkpointContinuous(String newState) throws Exception {
        this.datasetStreamWriter.checkpoint(newState);
    }

    public String getContinuousState() throws Exception {
        return this.datasetStreamWriter.getRecordedState();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeContinuous(boolean failed) throws Exception {
        if (this.closed) {
            return;
        }
        this.closed = true;
        switch (this.writeRequest.targetType) {
            case DATASET: {
                if (failed) {
                    this.datasetStreamWriter.cancel();
                } else {
                    this.datasetStreamWriter.close();
                }
                this.datasetHandler.close();
                break;
            }
            case STREAMING_ENDPOINT: {
                if (failed) {
                    this.streamWriteProcessor.cancel();
                    break;
                }
                this.streamWriteProcessor.postProcess();
                break;
            }
            case MANAGED_FOLDER: 
            case SAVED_MODEL: 
            case MODEL_EVALUATION_STORE: 
            case RETRIEVABLE_KNOWLEDGE: {
                throw new Error("unreachable");
            }
        }
        DatasetWriteSession datasetWriteSession = this;
        synchronized (datasetWriteSession) {
            this.enterState(State.SUCCESS);
        }
    }

    private void appendFromCSVStream(DatasetWriter writer, Schema dataSchema, InputStream is) throws IOException, Exception {
        ArrayList<Column> columns = new ArrayList<Column>();
        ArrayList<Boolean> needIntegerNormalization = new ArrayList<Boolean>();
        ArrayList<Boolean> needDateOnlyNormalization = new ArrayList<Boolean>();
        ArrayList<Boolean> needDatetimeNoTzNormalization = new ArrayList<Boolean>();
        for (SchemaColumn sc : dataSchema.getColumns()) {
            columns.add(writer.columnFactory.column(sc.getName()));
            SchemaColumn datasetSC = writer.dataset.getSchema().getColumn(sc.getName());
            if (datasetSC != null && datasetSC.getType().isInteger()) {
                needIntegerNormalization.add(true);
            } else {
                needIntegerNormalization.add(false);
            }
            if (datasetSC != null && datasetSC.getType() == Type.DATEONLY) {
                needDateOnlyNormalization.add(true);
            } else {
                needDateOnlyNormalization.add(false);
            }
            if (datasetSC != null && datasetSC.getType() == Type.DATETIMENOTZ) {
                needDatetimeNoTzNormalization.add(true);
                continue;
            }
            needDatetimeNoTzNormalization.add(false);
        }
        BufferedInputStream bis = new BufferedInputStream(is);
        InputStreamLineReader islr = new InputStreamLineReader((InputStream)bis, StandardCharsets.UTF_8);
        RFC4180CSVParser csvParser = new RFC4180CSVParser((LineReader)islr, ',');
        ArrayList<String> rowBuffer = new ArrayList<String>();
        while (csvParser.next(rowBuffer)) {
            Row row = writer.rowFactory.row();
            this.handleNormalizations(row, rowBuffer, needIntegerNormalization, needDateOnlyNormalization, needDatetimeNoTzNormalization, columns);
            writer.appendRow(row);
            if (++this.writtenRows % 10000L != 0L) continue;
            logger.info((Object)("Emitted " + this.writtenRows + " rows"));
        }
    }

    private void handleNormalizations(Row row, List<String> rowBuffer, List<Boolean> needIntegerNormalization, List<Boolean> needLocalDateNormalization, List<Boolean> needLocalDatetimeNormalization, List<Column> columns) {
        for (int i = 0; i < columns.size() && i < rowBuffer.size(); ++i) {
            Matcher m;
            Object v = rowBuffer.get(i);
            if (needIntegerNormalization.get(i).booleanValue() && ((String)v).length() >= 3 && StringUtils.contains((String)v, (char)'.') && StringUtils.endsWith((String)v, (String)".0")) {
                v = ((String)v).substring(0, ((String)v).length() - 2);
            }
            if (needLocalDateNormalization.get(i).booleanValue() && ((String)v).length() > 10) {
                v = ((String)v).substring(0, 10);
            }
            if (needLocalDatetimeNormalization.get(i).booleanValue() && ((String)v).length() >= 19 && ((String)v).charAt(10) == 'T' && (m = DATETIMENOTZ_EXTRACTOR.matcher((CharSequence)v)).matches()) {
                v = m.group(1) + " " + m.group(2) + StringUtils.defaultIfBlank((String)m.group(3), (String)"");
            }
            row.put(columns.get(i), (String)v);
        }
    }

    public void attemptSetLogContext() {
        if (this.caKernelSession == null && StringUtils.isNotBlank((String)this.writeRequest.activityId)) {
            RecipeRunnableSubgraph recipeRunnableSubgraph;
            RunnableSubgraph runnableSubgraph;
            ActivityRunner arunner = this.jekKernelSession.getJobRunner().getActivityRunner(this.writeRequest.activityId);
            JobContext.setJob(this.jekKernelSession.jobProjectKey, this.jekKernelSession.jobId, this.jekKernelSession.job);
            JobActivity activity = arunner.getActivity();
            JobContext.setCurrentActivityInThread(activity);
            if (activity != null && (runnableSubgraph = activity.getSubgraph()) instanceof RecipeRunnableSubgraph && (recipeRunnableSubgraph = (RecipeRunnableSubgraph)runnableSubgraph).getRecipe() != null) {
                SerializedRecipe recipe = recipeRunnableSubgraph.getRecipe().getModel();
                for (AbstractSQLConnection.CustomDatabaseProperty prop : recipe.dkuProperties) {
                    if (!HEARTBEAT_FREQUENCY_PROP.equals(prop.name)) continue;
                    try {
                        this.heartbeatFrequency = Integer.parseInt(prop.value);
                        logger.info((Object)("Write session fine-tuned heartbeat frequency to " + this.heartbeatFrequency + " seconds"));
                    }
                    catch (Exception e) {
                        logger.warn((Object)"Unable to parse heartbeat frequency property", (Throwable)e);
                    }
                }
            }
        }
    }

    private List<String> getColNames(Schema schema) {
        ArrayList<String> colNames = new ArrayList<String>(schema.getColumns().size());
        for (SchemaColumn col : schema.getColumns()) {
            colNames.add(col.getName());
        }
        return colNames;
    }

    private void sanityChecks() {
        try {
            Schema dataSchema = this.writeRequest.dataSchema;
            Schema targetSchema = this.targetDataset.getSchema();
            Schema dataSchemaCopy = (Schema)JSON.deepCopy((Object)dataSchema);
            Schema targetSchemaCopy = (Schema)JSON.deepCopy((Object)targetSchema);
            if (this.targetDataset.getPartitioningSchema().isPartitioned()) {
                for (String dimName : this.targetDataset.getPartitioningSchema().getDimensionNames()) {
                    dataSchemaCopy.removeColumn(dimName);
                    targetSchemaCopy.removeColumn(dimName);
                }
            }
            SchemaUtils.fixSchemaForComparison(this.targetDataset.getType(), targetSchemaCopy, dataSchemaCopy);
            if (dataSchemaCopy.getColumns().size() != targetSchemaCopy.getColumns().size()) {
                logger.warn((Object)("Columns in data:" + JSON.prettyLog(this.getColNames(dataSchemaCopy))));
                logger.warn((Object)("Columns in target:" + JSON.prettyLog(this.getColNames(targetSchemaCopy))));
                throw new RuntimeException("Schema incompatibility: " + dataSchemaCopy.getColumns().size() + " columns in data, " + targetSchemaCopy.getColumns().size() + " columns in target dataset.");
            }
            if (this.writeRequest.method == DatasetWriteRequest.Method.FILE) {
                if (StringUtils.isBlank((String)this.writeRequest.dataFilePath)) {
                    throw new RuntimeException("The dataFilePath parameter is required in FILE mode");
                }
                if (!new File(this.writeRequest.dataFilePath).isFile()) {
                    throw new RuntimeException("The file " + this.writeRequest.dataFilePath + " doesn't exist");
                }
            }
            if (this.jekKernelSession != null && (this.writeRequest.activityId == null || this.jekKernelSession.getActivityById(this.writeRequest.activityId) == null)) {
                throw new RuntimeException("The activity " + this.writeRequest.activityId + " doesn't exist.");
            }
        }
        catch (Throwable t) {
            logger.info((Object)"Error in session init", t);
            this.setError(t);
            this.enterState(State.ERROR);
        }
    }

    public String getSessionId() {
        return this.id;
    }

    public int getHeartbeatFrequency() {
        return this.heartbeatFrequency;
    }

    public DatasetWriteRequest getWriteRequest() {
        return this.writeRequest;
    }

    public synchronized void enterState(State newState) {
        if (!newState.isSuccessorOf(this.state)) {
            throw new RuntimeException("Forbidden state transition : " + String.valueOf((Object)this.state) + " -> " + String.valueOf((Object)newState));
        }
        this.state = newState;
        this.notifyAll();
    }

    public synchronized void blockUntilStateIsOneOf(State ... states) throws InterruptedException {
        while (!this.isInState(states)) {
            this.wait(1000L);
        }
    }

    public synchronized boolean isInState(State ... states) {
        return Arrays.asList(states).contains((Object)this.state);
    }

    public synchronized boolean isFinished() {
        return this.isInState(State.ERROR, State.SUCCESS);
    }

    public synchronized Throwable getError() {
        return this.error;
    }

    public synchronized void setError(Throwable t) {
        this.error = t;
    }

    public synchronized void setErrorIfNoneYet(Throwable t) {
        if (this.error == null) {
            this.error = t;
        }
    }

    public synchronized Dataset getTargetDataset() {
        return this.targetDataset;
    }

    public synchronized State getState() {
        return this.state;
    }

    public static enum State {
        INITIALIZED(new State[0]),
        STREAMING(new State[0]),
        WAITING_FOR_MORE_DATA(STREAMING),
        SUCCESS(STREAMING, WAITING_FOR_MORE_DATA),
        ERROR(STREAMING, INITIALIZED, WAITING_FOR_MORE_DATA);

        private State[] predecessors;

        private State(State ... predecessors) {
            this.predecessors = predecessors;
        }

        public boolean isSuccessorOf(State previous) {
            for (State state : this.predecessors) {
                if (state != previous) continue;
                return true;
            }
            return false;
        }

        static {
            State.STREAMING.predecessors = new State[]{INITIALIZED, WAITING_FOR_MORE_DATA};
        }
    }
}

