/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.datasets;

import com.dataiku.dip.connections.DSSConnection;
import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.SerializedDataset;
import com.dataiku.dip.custom.IPluginifiedHolderMeta;
import com.dataiku.dip.dataflow.ComputableHashComputer;
import com.dataiku.dip.dataquality.DataQualityRule;
import com.dataiku.dip.dataquality.DataQualityRuleSet;
import com.dataiku.dip.datasets.DatasetReadiness;
import com.dataiku.dip.datasets.DatasetRecordCount;
import com.dataiku.dip.datasets.PartitionableHandler;
import com.dataiku.dip.datasets.consistency.BasicDatasetConsistencyChecker;
import com.dataiku.dip.datasets.consistency.DatasetConsistencyChecker;
import com.dataiku.dip.exceptions.CodedException;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.input.DatasetTestHandler;
import com.dataiku.dip.input.InputSplit;
import com.dataiku.dip.input.filter.FilterResultWithSplits;
import com.dataiku.dip.input.filter.InputFilter;
import com.dataiku.dip.input.formats.ExtractionLimit;
import com.dataiku.dip.managedfolder.ManagedFolder;
import com.dataiku.dip.metrics.checks.CustomPythonCheck;
import com.dataiku.dip.metrics.probes.Probe;
import com.dataiku.dip.output.Output;
import com.dataiku.dip.partitioning.Partition;
import com.dataiku.dip.recipes.ManagedDatasetsCreationService;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.warnings.WarningsContext;
import com.dataiku.j2ts.annotations.UIType;
import com.google.common.collect.Lists;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;

public interface DatasetHandler
extends PartitionableHandler {
    @Override
    public void close() throws IOException;

    public Dataset getDataset();

    public boolean isManaged();

    public DatasetMeta<?, ?> getMeta();

    public void checkConfiguration() throws IllegalArgumentException, IOException, CodedException, DKUSecurityException;

    public String suggestName() throws CodedException, DKUSecurityException;

    @Override
    public List<Partition> listPartitions() throws Exception;

    public long getRecords() throws Exception;

    default public DatasetRecordCount getRecordsFast() throws Exception {
        return null;
    }

    public long getPartitionRecords(Partition var1) throws Exception;

    public DatasetReadiness getReadiness(Partition var1, @Nullable ComputableHashComputer.ReadinessComputationSession var2);

    @Override
    public boolean partitionExists(Partition var1) throws Exception;

    default public boolean isParallelReadable() throws Exception {
        return this.getMeta().isFSLike();
    }

    public boolean isParallelWritable() throws Exception;

    public boolean executeFastPostCreateOperations() throws Exception;

    public boolean executeSlowPostCreateOperations_NT() throws Exception;

    public void executePreRenameOperations() throws IOException;

    public void createManaged() throws Exception;

    public void clearAllData() throws Exception;

    @Override
    public void clearPartitions(List<Partition> var1) throws Exception;

    public void clearAllDataAndStructure() throws Exception;

    public DatasetTestHandler buildTestHandler() throws IOException, DKUSecurityException, CodedException;

    public InputSplit getPartitionSplit(Partition var1) throws Exception;

    public FilterResultWithSplits getFilterSplits(InputFilter var1) throws Exception;

    public Output buildOutput(Partition var1, int var2, int var3, WarningsContext var4) throws Exception;

    public boolean outputHandlesClear();

    default public boolean handlesSamplingMethodDuringPush(ExtractionLimit limit) throws DKUSecurityException {
        return false;
    }

    public static abstract class DatasetMeta<TDataset extends DatasetHandler, TDatasetParams extends DatasetParams>
    implements IPluginifiedHolderMeta {
        public abstract String getType();

        public abstract Class<? extends DatasetParams> paramsClass();

        public abstract DatasetHandler build(AuthCtx var1, Dataset var2);

        public abstract boolean isFSLike();

        public abstract boolean isFS();

        public abstract boolean isReadable();

        public abstract boolean isWritable();

        public abstract boolean isParallelWritable();

        public boolean handlesClearForOverwriteMode() {
            return this.isFSLike();
        }

        public boolean supportsReadOrdering() {
            return false;
        }

        public boolean supportsOrderPreservation() {
            return this.isFSLike();
        }

        public boolean isParallelWritable(SerializedDataset.ReadWriteOptions rwOptions) {
            if (!this.isParallelWritable()) {
                return false;
            }
            if (rwOptions.forceSingleOutputFile) {
                return false;
            }
            return !rwOptions.preserveOrder || !this.supportsOrderPreservation();
        }

        public abstract void fillManagedDatasetParams(Dataset var1, DSSConnection var2, ManagedDatasetsCreationService.ManagedDatasetCreationSpecificSettings var3, boolean var4) throws CodedException;

        public void fillManagedDatasetParams(Dataset dataset, DSSConnection targetConnection, ManagedDatasetsCreationService.ManagedDatasetCreationSpecificSettings specificSettings) throws CodedException {
            this.fillManagedDatasetParams(dataset, targetConnection, specificSettings, false);
        }

        public abstract void fillManagedFolderParams(ManagedFolder var1, DSSConnection var2, boolean var3) throws CodedException;

        public DatasetConsistencyChecker buildConsistencyChecker(Dataset dataset) {
            return new BasicDatasetConsistencyChecker(dataset);
        }

        protected void selfReport(TDatasetParams param, JsonObject ret) throws Exception {
        }

        public final JsonObject selfReport(Dataset dataset) throws Exception {
            JsonObject report = new JsonObject();
            report.addProperty("type", dataset.getType());
            report.addProperty("part", Boolean.valueOf(dataset.getPartitioningSchema().isPartitioned()));
            if (dataset.getFormatType() != null) {
                report.addProperty("fmt", dataset.getFormatType());
            }
            if (dataset.getFlowOptions() != null && dataset.getFlowOptions().rebuildBehavior != SerializedDataset.RebuildBehavior.NORMAL) {
                report.addProperty("flow.rebuild", String.valueOf((Object)dataset.getFlowOptions().rebuildBehavior));
            }
            try {
                DataQualityRuleSet ruleSet = dataset.getModel().getDataQualityRuleSet();
                report.addProperty("numberOfRules", (Number)ruleSet.getRules().size());
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.selfReport(dataset.getParams(), report);
            return report;
        }

        @Override
        public List<IPluginifiedHolderMeta.Pluginifiable> getPluginifiables(Object object, String payload) {
            ArrayList components = Lists.newArrayList();
            if (object instanceof SerializedDataset) {
                SerializedDataset dataset = (SerializedDataset)object;
                for (Probe probe : dataset.getMetrics().getProbes()) {
                    components.add(new IPluginifiedHolderMeta.Pluginifiable("probe", probe.getType(), probe));
                }
                for (DataQualityRule check : dataset.getDataQualityRuleSet().getRules()) {
                    if (!(check instanceof CustomPythonCheck)) continue;
                    components.add(new IPluginifiedHolderMeta.Pluginifiable("check", check.getType(), check));
                }
            }
            return components;
        }
    }

    public static abstract class NonFSMeta<TDataset extends DatasetHandler, TDatasetParams extends DatasetParams>
    extends DatasetMeta<TDataset, TDatasetParams> {
        @Override
        public void fillManagedFolderParams(ManagedFolder folder, DSSConnection targetConnection, boolean useExistingParams) {
            throw new RuntimeException("Unreachable");
        }
    }

    public static interface SoftLinkGeneratingDatasetParams {
        public boolean linksChanged(SerializedDataset var1);
    }

    @UIType(value="any")
    public static interface DatasetParams
    extends Serializable {
        public String getConnection();

        public boolean isNotReadyIfEmpty();

        default public void setDefaultForUninitializedAttributes(SerializedDataset dataset) {
        }
    }
}

