/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.datasets.cassandra;

import com.dataiku.dip.connections.CassandraUtil;
import com.dataiku.dip.connections.ConnectionsDAO;
import com.dataiku.dip.connections.DSSConnection;
import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.SchemaColumn;
import com.dataiku.dip.dataflow.ComputableHashComputer;
import com.dataiku.dip.datalayer.ColumnFactory;
import com.dataiku.dip.datalayer.ProcessorOutput;
import com.dataiku.dip.datalayer.Row;
import com.dataiku.dip.datalayer.RowFactory;
import com.dataiku.dip.datalayer.memimpl.MemTableAppendingOutput;
import com.dataiku.dip.datasets.DatasetHandler;
import com.dataiku.dip.datasets.DatasetReadiness;
import com.dataiku.dip.datasets.cassandra.CassandraDatasetTestHandler;
import com.dataiku.dip.datasets.cassandra.CassandraOutput;
import com.dataiku.dip.datasets.cassandra.PartitionedCassandraDatasetHandler;
import com.dataiku.dip.datasets.cassandra.UnpartitionedCassandraDatasetHandler;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.exceptions.DataStoreIOException;
import com.dataiku.dip.input.DatasetTestHandler;
import com.dataiku.dip.input.InputSplitProgressListener;
import com.dataiku.dip.input.formats.ExtractionLimit;
import com.dataiku.dip.input.row.RowOrientedDatasetHandler;
import com.dataiku.dip.input.row.RowsInputSplit;
import com.dataiku.dip.output.Output;
import com.dataiku.dip.partitioning.Partition;
import com.dataiku.dip.recipes.ManagedDatasetsCreationService;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.util.CassandraV1Query;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.ErrorContext;
import com.dataiku.dip.warnings.WarningsContext;
import com.datastax.driver.core.BoundStatement;
import com.datastax.driver.core.ColumnDefinitions;
import com.datastax.driver.core.ProtocolVersion;
import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.SimpleStatement;
import com.datastax.driver.core.Statement;
import java.io.IOException;
import java.util.HashSet;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;

public abstract class AbstractCassandraDatasetHandler
implements RowOrientedDatasetHandler {
    public static final CassandraDatasetMeta META = new CassandraDatasetMeta();
    protected final Config config;
    protected final AuthCtx authCtx;
    protected final Dataset dataset;
    protected static DKULogger logger = DKULogger.getLogger((String)"dku.cassandra");

    public AbstractCassandraDatasetHandler(AuthCtx authCtx, Dataset dataset) {
        this.authCtx = authCtx;
        this.dataset = dataset;
        this.config = dataset.getParamsAs(Config.class);
    }

    @Override
    public Dataset getDataset() {
        return this.dataset;
    }

    @Override
    public boolean isManaged() {
        return this.dataset.isManaged();
    }

    @Override
    public boolean isParallelWritable() {
        return this.getMeta().isParallelWritable(this.dataset.getModel().readWriteOptions);
    }

    @Override
    public DatasetHandler.DatasetMeta<?, ?> getMeta() {
        return META;
    }

    @Override
    public void close() {
    }

    @Override
    public void checkConfiguration() throws IllegalArgumentException, IOException {
        if (StringUtils.isBlank((String)this.config.connection)) {
            throw ErrorContext.icef((String)"Missing connection for dataset %s : %d", (Object)this.dataset.getName(), (Object[])new Object[0]);
        }
        if (StringUtils.isBlank((String)this.config.table)) {
            throw ErrorContext.icef((String)"Missing table for dataset %s : %d", (Object)this.dataset.getName(), (Object[])new Object[0]);
        }
        if (this.config.fetchSize < 0) {
            throw ErrorContext.icef((String)"Invalid fetch size value for dataset %s : %d", (Object)this.dataset.getName(), (Object[])new Object[]{this.config.fetchSize});
        }
        if (this.dataset.getPartitioningSchema().isPartitioned()) {
            if (StringUtils.isBlank((String)this.config.partitioningColumn)) {
                throw ErrorContext.icef((String)"Dataset %s is partitioned, need a partitioning column", (Object)this.dataset.getName(), (Object[])new Object[0]);
            }
            if (this.dataset.isManaged() && this.config.partitionSpread < 1) {
                throw ErrorContext.icef((String)"Managed dataset %s is partitioned, needs a non-zero partition spread factor", (Object)this.dataset.getName(), (Object[])new Object[0]);
            }
        }
    }

    @Override
    public String suggestName() {
        return this.config.table;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public DatasetReadiness getReadiness(Partition p, @Nullable ComputableHashComputer.ReadinessComputationSession session) {
        DatasetReadiness datasetReadiness;
        CassandraUtil.ClusterConnection dbConn;
        block9: {
            DatasetReadiness datasetReadiness2;
            block8: {
                logger.info((Object)("Connecting to cluster, connection=" + this.config.connection));
                dbConn = null;
                try {
                    if (this.dataset.getParams().isNotReadyIfEmpty()) {
                        logger.info((Object)("Checking whether partition " + p.id() + " is empty"));
                        datasetReadiness2 = RowOrientedDatasetHandler.Utils.getReadinessNotEmpty((RowsInputSplit)this.getPartitionSplit(p));
                        if (dbConn == null) return datasetReadiness2;
                        break block8;
                    }
                    dbConn = CassandraUtil.acquireConnection(this.authCtx, this.config.connection);
                    String cql = "SELECT * FROM " + CassandraUtil.quote(this.config.table) + " LIMIT 1";
                    logger.debug((Object)("Preparing cql: " + cql));
                    dbConn.prepare(cql).getVariables();
                    datasetReadiness = DatasetReadiness.ready(null);
                    if (dbConn == null) return datasetReadiness;
                    break block9;
                }
                catch (Exception e) {
                    DatasetReadiness datasetReadiness3 = DatasetReadiness.error(e);
                    return datasetReadiness3;
                }
            }
            CassandraUtil.releaseConnection(dbConn);
            return datasetReadiness2;
        }
        CassandraUtil.releaseConnection(dbConn);
        return datasetReadiness;
        finally {
            if (dbConn != null) {
                CassandraUtil.releaseConnection(dbConn);
            }
        }
    }

    @Override
    public DatasetTestHandler buildTestHandler() throws IOException {
        return new CassandraDatasetTestHandler(this.authCtx, this.getDataset(), this);
    }

    @Override
    public Output buildOutput(Partition targetPartition, int targetSplit, int resplitFactor, WarningsContext warningsContext) throws Exception {
        this.checkConfiguration();
        return new CassandraOutput(this, this.dataset, targetPartition, ConnectionsDAO.get());
    }

    @Override
    public void createManaged() throws DataStoreIOException {
        logger.info((Object)("Connecting to cluster, connection=" + this.config.connection));
        try {
            CassandraUtil.ClusterConnection dbConn = CassandraUtil.acquireConnection(this.authCtx, this.config.connection);
            try {
                logger.info((Object)("Creating table " + this.config.table));
                String cql = this.createTableCommand(false);
                logger.debug((Object)("Sending cql: " + cql));
                dbConn.getSession().execute(cql);
            }
            finally {
                CassandraUtil.releaseConnection(dbConn);
            }
        }
        catch (DKUSecurityException | IOException e) {
            throw new DataStoreIOException("Failed to create Cassandra table", e);
        }
    }

    @Override
    public void clearAllData() throws DataStoreIOException {
        assert (this.dataset.isManaged());
        logger.info((Object)("Connecting to cluster, connection=" + this.config.connection));
        try {
            CassandraUtil.ClusterConnection dbConn = CassandraUtil.acquireConnection(this.authCtx, this.config.connection);
            logger.info((Object)("Dropping dataset table: " + this.config.table));
            try {
                dbConn.getSession().execute("DROP TABLE " + CassandraUtil.quote(this.config.table));
            }
            finally {
                CassandraUtil.releaseConnection(dbConn);
            }
        }
        catch (DKUSecurityException | IOException e) {
            throw new DataStoreIOException("Failed to clear Cassandra table", e);
        }
    }

    @Override
    public void clearAllDataAndStructure() throws Exception {
        this.clearAllData();
    }

    protected String createTableCommand(boolean ifNotExists) {
        assert (this.dataset.isManaged());
        if (this.dataset.getSchema() == null || this.dataset.getSchema().getColumns().size() == 0) {
            throw ErrorContext.iaef((String)"Dataset %s has no schema, can't create table", (Object)this.dataset.getName(), (Object[])new Object[0]);
        }
        StringBuilder fields = new StringBuilder(CassandraUtil.quote("_dssId") + " timeuuid");
        if (this.config.partitioningColumn != null) {
            fields.append(", " + CassandraUtil.quote("_dssSpread") + " int");
        }
        for (SchemaColumn sc : this.dataset.getSchema().getColumns()) {
            fields.append(", " + CassandraUtil.quote(sc.getName()) + " " + String.valueOf(CassandraUtil.getCassandraType(sc)));
        }
        fields.append(", PRIMARY KEY (");
        if (this.config.partitioningColumn != null) {
            fields.append("(" + CassandraUtil.quote(this.config.partitioningColumn) + ", " + CassandraUtil.quote("_dssSpread") + "), ");
        }
        fields.append(CassandraUtil.quote("_dssId") + ")");
        return "CREATE TABLE " + (ifNotExists ? "IF NOT EXISTS " : "") + CassandraUtil.quote(this.config.table) + "(" + String.valueOf(fields) + ")";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected long executePush(ProcessorOutput out, ColumnFactory cf, RowFactory rf, @Nullable ExtractionLimit limit, InputSplitProgressListener listener, WarningsContext warningsContext, String filterTerm, String filterValue) throws Exception {
        logger.info((Object)("Connecting to cluster, connection=" + this.config.connection));
        try {
            CassandraUtil.ClusterConnection dbConn = CassandraUtil.acquireConnection(this.authCtx, this.config.connection);
            try {
                ResultSet res;
                if (dbConn.getProtocolVersion() == ProtocolVersion.V1) {
                    long l = this.pushV1(dbConn, out, cf, rf, limit, listener, warningsContext, filterValue);
                    return l;
                }
                long maxRecords = limit != null && limit.maxRecords > 0L ? limit.maxRecords : 0L;
                logger.info((Object)("Enumerating table: " + this.config.table + (String)(maxRecords > 0L ? " with limit " + maxRecords : "") + (String)(this.config.fetchSize > 0 ? " with fetchSize " + this.config.fetchSize : "")));
                StringBuilder fields = new StringBuilder();
                if (this.dataset.getSchema() != null && this.dataset.getSchema().getColumns().size() > 0) {
                    for (SchemaColumn sc : this.dataset.getSchema().getColumns()) {
                        if (fields.length() > 0) {
                            fields.append(", ");
                        }
                        fields.append(CassandraUtil.quote(sc.getName()));
                    }
                } else {
                    fields.append("*");
                }
                if (filterTerm == null) {
                    cql = "SELECT " + String.valueOf(fields) + " FROM " + CassandraUtil.quote(this.config.table) + (String)(maxRecords > 0L ? " LIMIT " + maxRecords : "");
                    logger.debug((Object)("sending cql: " + cql));
                    res = dbConn.getSession().execute(new SimpleStatement(cql).setFetchSize(this.config.fetchSize));
                } else {
                    cql = "SELECT " + String.valueOf(fields) + " FROM " + CassandraUtil.quote(this.config.table) + " WHERE " + filterTerm + (String)(maxRecords > 0L ? " LIMIT " + maxRecords : "") + " ALLOW FILTERING";
                    logger.debug((Object)("preparing cql: " + cql));
                    BoundStatement st2 = dbConn.prepare(cql).bind();
                    CassandraUtil.setCassandraValue(st2, 0, filterValue);
                    res = dbConn.getSession().execute(st2.setFetchSize(this.config.fetchSize));
                }
                ColumnDefinitions dbCols = res.getColumnDefinitions();
                long rowsPushed = 0L;
                long rowsBefore = listener == null ? 0L : listener.getReadRecords();
                for (com.datastax.driver.core.Row dbRow : res) {
                    if (maxRecords > 0L && rowsPushed >= maxRecords) {
                        logger.info((Object)"push limit would be exceeded, stopping");
                        break;
                    }
                    Row r = rf.row();
                    for (int i = 0; i < dbCols.size(); ++i) {
                        String val;
                        if (dbRow.isNull(i) || dbCols.getName(i).startsWith("_dss") || (val = CassandraUtil.getCassandraValue(dbRow, i)) == null) continue;
                        r.put(cf.column(dbCols.getName(i)), val);
                    }
                    if (listener != null && ++rowsPushed % 50L == 0L) {
                        listener.setData(0L, 0L, rowsBefore + rowsPushed);
                    }
                    out.emitRow(r);
                    if (rowsPushed % 100000L != 0L) continue;
                    logger.debug((Object)("Got " + rowsPushed + " rows"));
                }
                logger.debug((Object)("Done pushing, got " + rowsPushed + " rows"));
                long l = rowsPushed;
                return l;
            }
            finally {
                CassandraUtil.releaseConnection(dbConn);
            }
        }
        catch (MemTableAppendingOutput.MemTableSizeLimitReachedException e) {
            throw e;
        }
        catch (IOException e) {
            throw new DataStoreIOException("Failed to read Cassandra data", (Throwable)e);
        }
    }

    protected long pushV1(CassandraUtil.ClusterConnection dbConn, ProcessorOutput out, ColumnFactory cf, RowFactory rf, @Nullable ExtractionLimit limit, InputSplitProgressListener listener, WarningsContext warningsContext, String filterValue) throws Exception {
        long rowsBefore;
        assert (filterValue == null);
        long maxRecords = limit != null && limit.maxRecords > 0L ? limit.maxRecords : 0L;
        logger.info((Object)("Enumerating v1 table: " + this.config.table + (String)(maxRecords > 0L ? " with limit " + maxRecords : "")));
        HashSet<String> fields = null;
        if (this.dataset.getSchema() != null && this.dataset.getSchema().getColumns().size() > 0) {
            fields = new HashSet<String>();
            for (SchemaColumn sc : this.dataset.getSchema().getColumns()) {
                fields.add(sc.getName());
            }
        }
        CassandraV1Query query = new CassandraV1Query(dbConn, this.config.table, this.config.fetchSize, fields, null, null, -1, maxRecords);
        long rowsPushed = 0L;
        long l = rowsBefore = listener == null ? 0L : listener.getReadRecords();
        while (query.hasNext()) {
            com.datastax.driver.core.Row dbRow = query.next();
            ColumnDefinitions dbCols = dbRow.getColumnDefinitions();
            Row r = rf.row();
            for (int i = 0; i < dbCols.size(); ++i) {
                String val;
                if (dbRow.isNull(i) || dbCols.getName(i).startsWith("_dss") || (val = CassandraUtil.getCassandraValue(dbRow, i)) == null) continue;
                r.put(cf.column(dbCols.getName(i)), val);
            }
            if (listener != null && ++rowsPushed % 50L == 0L) {
                listener.setData(0L, 0L, rowsBefore + rowsPushed);
            }
            out.emitRow(r);
            if (rowsPushed % 100000L != 0L) continue;
            logger.debug((Object)("Got " + rowsPushed + " rows"));
        }
        logger.debug((Object)("Done pushing, got " + rowsPushed + " rows"));
        return rowsPushed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected long countRecords(String filterTerm, String filterValue) throws IOException {
        logger.info((Object)("Connecting to cluster, connection=" + this.config.connection));
        try {
            CassandraUtil.ClusterConnection dbConn = CassandraUtil.acquireConnection(this.authCtx, this.config.connection);
            try {
                logger.info((Object)("Counting table: " + this.config.table));
                if (filterTerm == null) {
                    String cql = "SELECT count(1) FROM " + CassandraUtil.quote(this.config.table);
                    logger.debug((Object)("Sending cql: " + cql));
                    long l = dbConn.getSession().execute(cql).one().getLong(0);
                    return l;
                }
                String cql = "SELECT count(1) FROM " + CassandraUtil.quote(this.config.table) + " WHERE " + filterTerm + " ALLOW FILTERING";
                logger.debug((Object)("Preparing cql: " + cql));
                BoundStatement st2 = dbConn.prepare(cql).bind();
                CassandraUtil.setCassandraValue(st2, 0, filterValue);
                long l = dbConn.getSession().execute((Statement)st2).one().getLong(0);
                return l;
            }
            finally {
                CassandraUtil.releaseConnection(dbConn);
            }
        }
        catch (DKUSecurityException e) {
            throw new DataStoreIOException("Failed to count", (Throwable)e);
        }
    }

    @Override
    public boolean executeFastPostCreateOperations() {
        return false;
    }

    @Override
    public boolean executeSlowPostCreateOperations_NT() {
        return false;
    }

    @Override
    public void executePreRenameOperations() {
    }

    public static class Config
    implements DatasetHandler.DatasetParams {
        private static final long serialVersionUID = -1L;
        public String connection;
        public boolean notReadyIfEmpty;
        public String table;
        public boolean partitioned;
        public String partitioningColumn;
        public int partitionSpread;
        public boolean deleteBeforeWrite;
        public String explicitPartitionsList;
        public int fetchSize = 0;

        @Override
        public String getConnection() {
            return this.connection;
        }

        @Override
        public boolean isNotReadyIfEmpty() {
            return this.notReadyIfEmpty;
        }
    }

    public static class CassandraDatasetMeta
    extends DatasetHandler.NonFSMeta<AbstractCassandraDatasetHandler, Config> {
        @Override
        public String getType() {
            return "Cassandra";
        }

        @Override
        public Class<? extends DatasetHandler.DatasetParams> paramsClass() {
            return Config.class;
        }

        @Override
        public DatasetHandler build(AuthCtx authCtx, Dataset dataset) {
            if (dataset.getPartitioningSchema().isPartitioned()) {
                return new PartitionedCassandraDatasetHandler(authCtx, dataset);
            }
            return new UnpartitionedCassandraDatasetHandler(authCtx, dataset);
        }

        @Override
        public boolean isFSLike() {
            return false;
        }

        @Override
        public boolean isFS() {
            return false;
        }

        @Override
        public boolean isReadable() {
            return true;
        }

        @Override
        public boolean isWritable() {
            return true;
        }

        @Override
        public boolean isParallelWritable() {
            return false;
        }

        @Override
        public void fillManagedDatasetParams(Dataset dataset, DSSConnection targetConnection, ManagedDatasetsCreationService.ManagedDatasetCreationSpecificSettings unused, boolean useExistingParams) {
            dataset.setType(this.getType());
            dataset.setManaged(true);
            Config config = new Config();
            config.connection = targetConnection.name;
            config.table = dataset.getName();
            config.partitionSpread = 4;
            dataset.setParams(config);
        }
    }

    class CassandraTableGlobalSplit
    extends RowsInputSplit {
        CassandraTableGlobalSplit() {
        }

        @Override
        public long push(ProcessorOutput out, ColumnFactory cf, RowFactory rf, @Nullable ExtractionLimit limit, InputSplitProgressListener listener, WarningsContext warningsContext) throws Exception {
            return AbstractCassandraDatasetHandler.this.executePush(out, cf, rf, limit, listener, warningsContext, null, null);
        }

        public String getDesc() {
            return "Cassandra";
        }
    }
}

