/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.datasets.consistency;

import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.coremodel.SerializedDataset;
import com.dataiku.dip.datasets.DatasetCodes;
import com.dataiku.dip.datasets.consistency.DatasetConsistencyChecker;
import com.dataiku.dip.input.DatasetHandlerFactory;
import com.dataiku.dip.input.DatasetTestHandler;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.ErrorContext;
import com.dataiku.dip.utils.JSON;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;

public class SchemaToDataConsistencyChecker
implements DatasetConsistencyChecker {
    @Autowired
    private TransactionService transactionService;
    protected final Dataset dataset;
    protected final SerializedDataset sds;
    protected final AuthCtx authCtx;
    private static DKULogger logger = DKULogger.getLogger((String)"dku.datasets.consistency");

    public SchemaToDataConsistencyChecker(AuthCtx authCtx, Dataset dataset) {
        SpringUtils.getInstance().autowire((Object)this);
        this.authCtx = authCtx;
        this.dataset = dataset;
        this.sds = dataset.serialize();
    }

    @Override
    public void cheapCheck(DatasetConsistencyChecker.DatasetConsistencyCheckRequest request, DatasetConsistencyChecker.DatasetConsistencyCheckResult result) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void expensiveCheck(DatasetConsistencyChecker.DatasetConsistencyCheckRequest request, DatasetConsistencyChecker.DatasetConsistencyCheckResult result) throws Exception {
        DatasetTestHandler.SchemaConsistencyResult res;
        DatasetTestHandler handler = null;
        logger.info((Object)("Check with " + JSON.log((Object)request)));
        if (!request.consistencyWithData) {
            return;
        }
        try (Transaction t = this.transactionService.beginRead();){
            handler = DatasetHandlerFactory.buildTestHandlerAs(this.authCtx, this.dataset, DatasetTestHandler.class);
        }
        try {
            res = handler.testSchemaConsistency();
        }
        finally {
            handler.close();
        }
        logger.infoV("Consistency check on %s : %s", new Object[]{this.dataset.getFullName(), JSON.log((Object)res)});
        if (!res.empty) {
            if (res.result != null) {
                if (res.result.warningLevel != null) {
                    switch (res.result.warningLevel) {
                        case FATAL: {
                            result.withFatal((InfoMessage.MessageCode)DatasetCodes.ERR_DATASET_SCHEMA_TO_DATA_MISMATCH, StringUtils.join(res.result.textReasons, (String)"\n"));
                            break;
                        }
                        case INFO: 
                        case WARN: {
                            result.withWarning((InfoMessage.MessageCode)DatasetCodes.ERR_DATASET_SCHEMA_TO_DATA_MISMATCH, StringUtils.join(res.result.textReasons, (String)"\n"));
                            break;
                        }
                        default: {
                            break;
                        }
                    }
                }
            } else {
                throw ErrorContext.iae((String)"Schema-to-data consistency checked did not return anything");
            }
        }
    }
}

