/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.datasets.fs;

import com.dataiku.dip.DKUApp;
import com.dataiku.dip.utils.DKULogger;
import java.io.IOException;
import java.io.InputStream;
import java.net.SocketException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class RetryingWrappedInputStream
extends InputStream {
    private static final Logger log = LoggerFactory.getLogger(RetryingWrappedInputStream.class);
    private InputStream current = this.streamFrom(null);
    private long pos = 0L;
    private int retriesLeft = 3;
    private final long sleepAt = DKUApp.getParams().getLongParam("testHarness.sleep.in.retriable.at", -1L);
    private boolean slept = false;
    private static DKULogger logger = DKULogger.getLogger((String)"dip.retriable.stream");

    protected abstract InputStream streamFrom(Long var1) throws IOException;

    protected boolean retry(IOException caught) {
        for (Throwable e = caught; e != null; e = e.getCause()) {
            if (!(e instanceof SocketException)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void close() throws IOException {
        logger.info((Object)("close " + String.valueOf(this.current)));
        this.current.close();
    }

    private int retriableRead(ReadAction action) throws IOException {
        if (this.sleepAt >= 0L && !this.slept && this.pos > this.sleepAt) {
            this.slept = true;
            try {
                long sleep = DKUApp.getParams().getLongParam("testHarness.sleep.in.retriable.amount", 60000L);
                if (sleep > 0L) {
                    logger.info((Object)("Start sleeping for " + sleep));
                    Thread.sleep(sleep);
                }
            }
            catch (Exception e) {
                logger.info((Object)"I was sleeping", (Throwable)e);
            }
        }
        while (this.retriesLeft > 0) {
            try {
                return action.read();
            }
            catch (IOException e) {
                if (this.retry(e)) {
                    logger.info((Object)("Retrying after exception, at position " + this.pos), (Throwable)e);
                    --this.retriesLeft;
                    try {
                        this.current.close();
                    }
                    catch (Exception e2) {
                        logger.warn((Object)"Failed to close broken stream", (Throwable)e2);
                    }
                    this.current = this.streamFrom(this.pos);
                    continue;
                }
                throw e;
            }
        }
        throw new IOException("No retry left for this read");
    }

    @Override
    public int read() throws IOException {
        return this.retriableRead(() -> {
            int data = this.current.read();
            if (data >= 0) {
                ++this.pos;
            }
            return data;
        });
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.retriableRead(() -> {
            int n = this.current.read(b);
            if (n > 0) {
                this.pos += (long)n;
            }
            return n;
        });
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        return this.retriableRead(() -> {
            int n = this.current.read(b, off, len);
            if (n > 0) {
                this.pos += (long)n;
            }
            return n;
        });
    }

    static interface ReadAction {
        public int read() throws IOException;
    }
}

