/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.datasets.iceberg;

import com.dataiku.common.server.SerializedError;
import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.dao.DatasetsDAO;
import com.dataiku.dip.datalayer.ProcessorOutput;
import com.dataiku.dip.datalayer.memimpl.MemTable;
import com.dataiku.dip.datalayer.memimpl.MemTableAppendingOutput;
import com.dataiku.dip.datasets.DatasetHandler;
import com.dataiku.dip.datasets.DatasetInspector;
import com.dataiku.dip.datasets.SchemaDetection;
import com.dataiku.dip.datasets.iceberg.IcebergDatasetHandler;
import com.dataiku.dip.datasets.iceberg.IcebergDatasetMeta;
import com.dataiku.dip.datasets.iceberg.IcebergDatasetParams;
import com.dataiku.dip.datasets.iceberg.IcebergSchemaConverter;
import com.dataiku.dip.datasets.iceberg.IcebergUtils;
import com.dataiku.dip.input.DatasetHandlerFactory;
import com.dataiku.dip.input.DatasetTestHandler;
import com.dataiku.dip.input.formats.ExtractionLimit;
import com.dataiku.dip.input.row.RowsInputSplit;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.shaker.server.SerializedMemTableSimple;
import com.dataiku.dip.shaker.services.TypeInferrer2;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.ExceptionUtils;
import com.dataiku.dss.shadelib.org.apache.iceberg.Schema;
import com.dataiku.dss.shadelib.org.apache.iceberg.Table;
import com.dataiku.dss.shadelib.org.apache.iceberg.catalog.Catalog;
import com.dataiku.dss.shadelib.org.apache.iceberg.catalog.TableIdentifier;
import java.io.Closeable;
import java.io.IOException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;

public class IcebergDatasetTestHandler
implements DatasetTestHandler {
    @Autowired
    private DatasetsDAO dao;
    @Autowired
    private TransactionService transactionService;
    protected final Dataset dataset;
    protected final AuthCtx authCtx;
    protected IcebergDatasetHandler handler;
    private final TypeInferrer2 inferrer = new TypeInferrer2();
    private static DKULogger logger = DKULogger.getLogger((String)"dku.iceberg");

    public IcebergDatasetTestHandler(AuthCtx authCtx, Dataset dataset, IcebergDatasetHandler handler) {
        this.authCtx = authCtx;
        this.dataset = dataset;
        this.handler = handler;
    }

    @Override
    public void close() throws IOException {
        if (this.handler != null) {
            try {
                this.handler.close();
            }
            finally {
                this.handler = null;
            }
        }
    }

    public TestResult test(boolean testTable, boolean listTables, int maxSamples) throws Exception {
        assert (this.dataset.getType().equals(IcebergDatasetMeta.INSTANCE.getType()));
        IcebergDatasetParams config = this.handler.getResolvedConfig();
        logger.info((Object)("Testing, dataset = " + this.dataset.getName() + " testTable = " + testTable + " listTables=" + listTables + " maxSamples=" + maxSamples));
        TestResult result = new TestResult();
        result.testedConnectionOnly = !testTable;
        try (DatasetHandler dhForName = DatasetHandlerFactory.build(this.authCtx, this.dataset);){
            result.suggestedName = DatasetInspector.slufigyAndUnicize(this.dataset.getProjectKey(), dhForName.suggestName(), this.dao, this.transactionService);
        }
        if (StringUtils.isBlank((String)config.connection)) {
            result.connectionOk = false;
            result.connectionErrorMsg = String.format("Missing connection for dataset %s", this.dataset.getName());
            return result;
        }
        try {
            PrivilegedExceptionAction<Void> action = () -> {
                Catalog icebergCatalog = this.handler.getOrCreateIcebergCatalog();
                try {
                    result.connectionOk = true;
                    if (testTable) {
                        try {
                            TableIdentifier tableId = this.handler.resolveTableIdentifier();
                            result.tableExists = icebergCatalog.tableExists(tableId);
                            Table table = icebergCatalog.loadTable(tableId);
                            Schema schema = table.schema();
                            logger.info((Object)("Iceberg schema is " + String.valueOf(schema)));
                            IcebergSchemaConverter converter = new IcebergSchemaConverter();
                            result.tableSchema = converter.convert(schema);
                            result.tableOk = true;
                            IcebergSchemaConverter.SchemaCompatibility schemaCompatibility = converter.isCompatible(this.dataset.getSchema(), schema);
                            result.schemaMatchesTable = schemaCompatibility.ok;
                            result.schemaMismatchMsg = schemaCompatibility.reason;
                            if (this.dataset.getPartitioningSchema().isPartitioned()) {
                                this.handler.checkIcebergPartitioningIsFinerThanDSSPartitioning(table.spec(), this.dataset.getPartitioningSchema());
                            }
                        }
                        catch (Exception e) {
                            result.tableOk = false;
                            result.tableErrorMsg = e.getMessage();
                            result.tableError = new SerializedError((Throwable)e, true);
                        }
                        if (result.tableOk && maxSamples > 0) {
                            try {
                                RowsInputSplit split = this.handler.getSampleSplit();
                                MemTable mt = new MemTable();
                                split.push((ProcessorOutput)new MemTableAppendingOutput(mt), mt, mt, new ExtractionLimit((long)maxSamples), null, null);
                                this.inferrer.processFullAuto(null, mt);
                                SerializedMemTableSimple smt = new SerializedMemTableSimple();
                                smt.fromMemTable(mt, 0, mt.nrows());
                                result.preview = smt;
                                result.previewOk = true;
                            }
                            catch (Exception e) {
                                logger.error((Object)"Failed to get preview", (Throwable)e);
                                result.previewOk = false;
                                result.previewError = new SerializedError((Throwable)e, true);
                                result.previewErrorMsg = ExceptionUtils.getMessageWithCauses((Throwable)e);
                            }
                        }
                    }
                    if (listTables) {
                        result.tablesList = new ArrayList<String>();
                        for (Table table : icebergCatalog.listTables(this.handler.resolveNamespace())) {
                            result.tablesList.add(table.name());
                        }
                        Collections.sort(result.tablesList);
                    }
                }
                finally {
                    if (icebergCatalog instanceof Closeable) {
                        ((Closeable)icebergCatalog).close();
                    }
                }
                return null;
            };
            new IcebergUtils().getUgi(this.handler.getConnection(), this.authCtx, this.dataset.getProjectKey()).doAs(action);
        }
        catch (Exception e) {
            result.connectionOk = false;
            result.connectionErrorMsg = e.getMessage();
            result.connectionError = new SerializedError((Throwable)e, true);
        }
        return result;
    }

    @Override
    public DatasetTestHandler.SchemaConsistencyResult testSchemaConsistency() throws Exception {
        DatasetTestHandler.SchemaConsistencyResult ret = new DatasetTestHandler.SchemaConsistencyResult();
        TestResult result = this.test(true, false, 0);
        ret.empty = !result.tableExists;
        ret.result = new SchemaDetection.SchemaDetectionResult();
        ret.result.type = SchemaDetection.SchemaHandlingType.FIXED_TYPE_AND_SCHEMA;
        return ret;
    }

    @Override
    public InfoMessage.InfoMessages checkManagedDatasetNameSafety(String newDatasetName) {
        return new InfoMessage.InfoMessages();
    }

    public static class TestResult {
        public boolean testedConnectionOnly;
        public String suggestedName;
        public boolean connectionOk;
        public String connectionErrorMsg;
        public SerializedError connectionError;
        public List<String> tablesList;
        public boolean tableExists;
        public com.dataiku.dip.coremodel.Schema tableSchema;
        public boolean tableOk;
        public String tableErrorMsg;
        public SerializedError tableError;
        public boolean schemaMatchesTable;
        public String schemaMismatchMsg;
        public SerializedMemTableSimple preview;
        public boolean previewOk;
        public String previewErrorMsg;
        public SerializedError previewError;
    }
}

