/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.deployer.apideployer.datamodel.actual.azureml.comparator;

import com.dataiku.dip.deployer.apideployer.datamodel.actual.azureml.comparator.AzureMLResourceComparator;
import com.dataiku.dip.deployer.common.datamodel.actual.DeploymentResourceComparator;
import com.dataiku.dip.externalinfras.azureml.datamodel.AzureMLOnlineDeployment;
import com.dataiku.dip.externalinfras.azureml.datamodel.AzureMLResource;
import com.dataiku.dip.utils.ErrorContext;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;

public class AzureMLOnlineDeploymentComparator
extends AzureMLResourceComparator<AzureMLOnlineDeployment> {
    public AzureMLOnlineDeploymentComparator(@Nonnull AzureMLOnlineDeployment onlineDeployment) {
        super(onlineDeployment);
    }

    public boolean requiresRecreation(@Nonnull AzureMLOnlineDeployment deployedOnlineDeployment) {
        return !StringUtils.equals((CharSequence)deployedOnlineDeployment.instanceType, (CharSequence)((AzureMLOnlineDeployment)this.getResource()).instanceType);
    }

    private Set<String> reportOutOfSyncProbeSettings(@Nonnull AzureMLOnlineDeployment.ProbeSettings probeSettings, @Nonnull AzureMLOnlineDeployment.ProbeSettings deployedProbeSettings, String type) {
        HashSet<String> outOfSyncFields = new HashSet<String>();
        if (probeSettings.overrideProbeSettings && !probeSettings.equals(deployedProbeSettings)) {
            if (deployedProbeSettings.initialDelay != probeSettings.initialDelay) {
                outOfSyncFields.add(DeploymentResourceComparator.outOfSyncFieldMessage(type + " initial delay", deployedProbeSettings.initialDelay, probeSettings.initialDelay));
            }
            if (deployedProbeSettings.period != probeSettings.period) {
                outOfSyncFields.add(DeploymentResourceComparator.outOfSyncFieldMessage(type + " period", deployedProbeSettings.period, probeSettings.period));
            }
            if (deployedProbeSettings.timeout != probeSettings.timeout) {
                outOfSyncFields.add(DeploymentResourceComparator.outOfSyncFieldMessage(type + " timeout", deployedProbeSettings.timeout, probeSettings.timeout));
            }
            if (deployedProbeSettings.successThreshold != probeSettings.successThreshold) {
                outOfSyncFields.add(DeploymentResourceComparator.outOfSyncFieldMessage(type + " success threshold", deployedProbeSettings.successThreshold, probeSettings.successThreshold));
            }
            if (deployedProbeSettings.failureThreshold != probeSettings.failureThreshold) {
                outOfSyncFields.add(DeploymentResourceComparator.outOfSyncFieldMessage(type + " failure threshold", deployedProbeSettings.failureThreshold, probeSettings.failureThreshold));
            }
        }
        return outOfSyncFields;
    }

    @Override
    public Set<String> reportOutOfSyncFields(@Nonnull AzureMLResource deployedResource) {
        Map<String, String> storedEnvVars;
        Map deployedEnvVars;
        String deployedEnvironmentReference;
        Set<String> outOfSyncFields = super.reportOutOfSyncFields(deployedResource);
        if (!(deployedResource instanceof AzureMLOnlineDeployment)) {
            throw ErrorContext.iae((String)"Incompatible resource types to compare.");
        }
        AzureMLOnlineDeployment deployedOnlineDeployment = (AzureMLOnlineDeployment)deployedResource;
        String deployedModelReference = String.format("azureml:%s:%s", deployedOnlineDeployment.getModelName(), deployedOnlineDeployment.getModelVersion());
        if (!StringUtils.equals((CharSequence)deployedModelReference, (CharSequence)((AzureMLOnlineDeployment)this.getResource()).modelURI)) {
            outOfSyncFields.add(DeploymentResourceComparator.outOfSyncFieldMessage("Associated model to the deployment", deployedModelReference, ((AzureMLOnlineDeployment)this.getResource()).modelURI));
        }
        if (!StringUtils.equals((CharSequence)(deployedEnvironmentReference = String.format("azureml:%s:%s", deployedOnlineDeployment.getEnvironmentName(), deployedOnlineDeployment.getEnvironmentVersion())), (CharSequence)((AzureMLOnlineDeployment)this.getResource()).environment)) {
            outOfSyncFields.add(DeploymentResourceComparator.outOfSyncFieldMessage("Associated environment to the deployment", deployedEnvironmentReference, ((AzureMLOnlineDeployment)this.getResource()).environment));
        }
        if (!StringUtils.equals((CharSequence)deployedOnlineDeployment.endpointName, (CharSequence)((AzureMLOnlineDeployment)this.getResource()).endpointName)) {
            outOfSyncFields.add(DeploymentResourceComparator.outOfSyncFieldMessage("Endpoint name", deployedOnlineDeployment.endpointName, ((AzureMLOnlineDeployment)this.getResource()).endpointName));
        }
        if (!StringUtils.equals((CharSequence)deployedOnlineDeployment.instanceType, (CharSequence)((AzureMLOnlineDeployment)this.getResource()).instanceType)) {
            outOfSyncFields.add(DeploymentResourceComparator.outOfSyncFieldMessage("Instance type", deployedOnlineDeployment.instanceType, ((AzureMLOnlineDeployment)this.getResource()).instanceType));
        }
        if (deployedOnlineDeployment.instanceCount != ((AzureMLOnlineDeployment)this.getResource()).instanceCount) {
            outOfSyncFields.add(DeploymentResourceComparator.outOfSyncFieldMessage("Instance count", deployedOnlineDeployment.instanceCount, ((AzureMLOnlineDeployment)this.getResource()).instanceCount));
        }
        if (deployedOnlineDeployment.appInsightsEnabled != ((AzureMLOnlineDeployment)this.getResource()).appInsightsEnabled) {
            outOfSyncFields.add(DeploymentResourceComparator.outOfSyncFieldMessage("Enable App Insights integration", deployedOnlineDeployment.appInsightsEnabled, ((AzureMLOnlineDeployment)this.getResource()).appInsightsEnabled));
        }
        if (!StringUtils.equalsIgnoreCase((CharSequence)deployedOnlineDeployment.egressPublicNetworkAccess, (CharSequence)((AzureMLOnlineDeployment)this.getResource()).egressPublicNetworkAccess)) {
            outOfSyncFields.add(DeploymentResourceComparator.outOfSyncFieldMessage("Public outbound network access", deployedOnlineDeployment.egressPublicNetworkAccess, ((AzureMLOnlineDeployment)this.getResource()).egressPublicNetworkAccess));
        }
        if (!Objects.equals(deployedEnvVars = (Map)ObjectUtils.defaultIfNull(deployedOnlineDeployment.environmentVariables, new HashMap()), storedEnvVars = ((AzureMLOnlineDeployment)this.getResource()).environmentVariables)) {
            outOfSyncFields.add(DeploymentResourceComparator.outOfSyncFieldMessage("Environment variables", DeploymentResourceComparator.censorValues(deployedEnvVars), DeploymentResourceComparator.censorValues(storedEnvVars)));
        }
        outOfSyncFields.addAll(this.reportOutOfSyncProbeSettings(((AzureMLOnlineDeployment)this.getResource()).livenessProbe, deployedOnlineDeployment.livenessProbe, "Liveness"));
        outOfSyncFields.addAll(this.reportOutOfSyncProbeSettings(((AzureMLOnlineDeployment)this.getResource()).readinessProbe, deployedOnlineDeployment.readinessProbe, "Readiness"));
        return outOfSyncFields;
    }
}

