/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.deployer.apideployer.datamodel.config;

import com.dataiku.dip.containers.exec.ContainerExecUtils;
import com.dataiku.dip.deployer.apideployer.datamodel.config.AbstractFullyManagedAPIDeploymentInfra;
import com.dataiku.dip.deployer.apideployer.deployments.APIServiceDeploymentsService;
import com.dataiku.dip.deployer.apideployer.infra.ApiNodeInfraManager;
import com.dataiku.dip.deployer.apideployer.infra.VertexAIInfraManager;
import com.dataiku.dip.deployer.common.datamodel.config.AbstractDeploymentInfra;
import com.dataiku.dip.externalinfras.vertexai.VertexAIInputValidator;
import com.dataiku.dip.externalinfras.vertexai.VertexAIUtils;
import com.dataiku.dip.externalinfras.vertexai.datamodel.VertexAIMachineConfig;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.ErrorContext;
import java.io.IOException;
import javax.annotation.Nonnull;
import org.apache.commons.lang.StringUtils;

public class VertexAIAPIDeploymentInfra
extends AbstractFullyManagedAPIDeploymentInfra {
    private static final String NETWORK_FORMAT = "^[a-z0-9-\\/]*$";
    public String gcpRegion;
    public String gcpProjectId;
    @Nonnull
    public VertexAIMachineConfig machineConfig = new VertexAIMachineConfig();
    public String networkFullName;
    public boolean allowOverrideEndpointId = false;

    @Override
    public AbstractDeploymentInfra.InfraType getInfraType() {
        return AbstractDeploymentInfra.InfraType.VERTEX_AI;
    }

    private VertexAIAPIDeploymentInfra() {
        this.prePushMode = ContainerExecUtils.ContainerBaseConfig.DockerPrepushHookMode.GCR;
    }

    VertexAIAPIDeploymentInfra(String id, String stage, String userIdentifier, AbstractDeploymentInfra.GovernCheckPolicy governCheckPolicy) {
        super(id, stage, userIdentifier, governCheckPolicy);
        this.prePushMode = ContainerExecUtils.ContainerBaseConfig.DockerPrepushHookMode.GCR;
    }

    @Override
    public void trySetDefaultValues_NT() {
        try {
            this.gcpRegion = VertexAIUtils.getDefaultConfiguredRegion_NT();
        }
        catch (Exception e) {
            logger.info((Object)"No default region in GCP.");
        }
        try {
            this.gcpProjectId = VertexAIUtils.getDefaultConfiguredProject_NT();
        }
        catch (Exception e) {
            logger.info((Object)"No default project in GCP.");
        }
    }

    @Override
    public ApiNodeInfraManager getInfraManager(DKULogger logger) {
        return new VertexAIInfraManager(this);
    }

    @Override
    public String getRegistryHost() {
        String defaultRegistryHost = super.getRegistryHost();
        if (StringUtils.isNotBlank((String)defaultRegistryHost)) {
            return defaultRegistryHost;
        }
        if (StringUtils.isBlank((String)this.gcpProjectId)) {
            return defaultRegistryHost;
        }
        return "gcr.io/" + this.gcpProjectId;
    }

    @Override
    public AbstractFullyManagedAPIDeploymentInfra.EndpointType getEndpointType() {
        return AbstractFullyManagedAPIDeploymentInfra.EndpointType.REAL_TIME;
    }

    @Override
    public void verifyFields(AuthCtx authCtx, AbstractDeploymentInfra oldInfra) throws IOException {
        super.verifyFields(authCtx, oldInfra);
        APIServiceDeploymentsService apiServiceDeploymentsService = (APIServiceDeploymentsService)SpringUtils.getBean(APIServiceDeploymentsService.class);
        if (oldInfra instanceof VertexAIAPIDeploymentInfra) {
            if (apiServiceDeploymentsService.hasDeploymentForInfra(this.id)) {
                VertexAIAPIDeploymentInfra oldVertexInfra = (VertexAIAPIDeploymentInfra)oldInfra;
                this.verifyFieldExistingDeployments(oldVertexInfra.gcpRegion, this.gcpRegion, "GCP Region");
                this.verifyFieldExistingDeployments(oldVertexInfra.gcpProjectId, this.gcpProjectId, "GCP Project");
            }
        } else {
            throw ErrorContext.iaef((String)"Old infra with id %s is not a Vertex AI infra.", (Object)oldInfra.id, (Object[])new Object[0]);
        }
        VertexAIInputValidator.validateRegionName(this.gcpRegion);
        VertexAIInputValidator.validateProjectId(this.gcpProjectId);
        this.verifyNetworkFormat();
    }

    private void verifyNetworkFormat() {
        if (StringUtils.isBlank((String)this.networkFullName)) {
            return;
        }
        if (!this.networkFullName.matches(NETWORK_FORMAT)) {
            throw ErrorContext.iaef((String)"Network name format is invalid: %s", (Object)this.networkFullName, (Object[])new Object[0]);
        }
    }
}

