/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.deployer.apideployer.deployments;

import com.dataiku.dip.connections.AzureConnection;
import com.dataiku.dip.connections.DSSConnection;
import com.dataiku.dip.connections.EC2Connection;
import com.dataiku.dip.connections.FsConnection;
import com.dataiku.dip.connections.GCSConnection;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.coremodel.VersionTag;
import com.dataiku.dip.datasets.fs.ChrootUtils;
import com.dataiku.dip.deployer.apideployer.datamodel.actual.APIServiceDeploymentHeavyStatus;
import com.dataiku.dip.deployer.apideployer.datamodel.config.AbstractAPIDeploymentInfra;
import com.dataiku.dip.deployer.apideployer.datamodel.config.AbstractAPIServiceDeployment;
import com.dataiku.dip.deployer.apideployer.datamodel.config.AzureMLAPIDeployment;
import com.dataiku.dip.deployer.apideployer.datamodel.config.AzureMLAPIDeploymentInfra;
import com.dataiku.dip.deployer.apideployer.datamodel.config.DatabricksAPIDeployment;
import com.dataiku.dip.deployer.apideployer.datamodel.config.DatabricksAPIDeploymentInfra;
import com.dataiku.dip.deployer.apideployer.datamodel.config.K8SAPIDeploymentInfra;
import com.dataiku.dip.deployer.apideployer.datamodel.config.K8SAPIServiceDeployment;
import com.dataiku.dip.deployer.apideployer.datamodel.config.SageMakerAPIDeployment;
import com.dataiku.dip.deployer.apideployer.datamodel.config.SageMakerAPIDeploymentInfra;
import com.dataiku.dip.deployer.apideployer.datamodel.config.SnowparkAPIDeployment;
import com.dataiku.dip.deployer.apideployer.datamodel.config.SnowparkAPIDeploymentInfra;
import com.dataiku.dip.deployer.apideployer.datamodel.config.StaticAPIDeploymentInfra;
import com.dataiku.dip.deployer.apideployer.datamodel.config.StaticDeployment;
import com.dataiku.dip.deployer.apideployer.datamodel.config.VertexAIAPIDeployment;
import com.dataiku.dip.deployer.apideployer.datamodel.config.VertexAIAPIDeploymentInfra;
import com.dataiku.dip.deployer.apideployer.deployments.APIServiceDeploymentsService;
import com.dataiku.dip.deployer.apideployer.deployments.ApiServiceDeployerKeysCRUDService;
import com.dataiku.dip.deployer.apideployer.deployments.AzureMLDeploymentManager;
import com.dataiku.dip.deployer.apideployer.deployments.DatabricksDeploymentManager;
import com.dataiku.dip.deployer.apideployer.deployments.SageMakerDeploymentManager;
import com.dataiku.dip.deployer.apideployer.deployments.SingleK8SDeploymentManager;
import com.dataiku.dip.deployer.apideployer.deployments.SingleStaticDeploymentManager;
import com.dataiku.dip.deployer.apideployer.deployments.SnowparkDeploymentManager;
import com.dataiku.dip.deployer.apideployer.deployments.VertexAIDeploymentManager;
import com.dataiku.dip.deployer.apideployer.published.PublishedAPIServicesService;
import com.dataiku.dip.deployer.common.DeployerCodes;
import com.dataiku.dip.deployer.common.datamodel.actual.AbstractDeploymentLightStatus;
import com.dataiku.dip.deployer.common.datamodel.actual.AbstractPublishedItemBasicInfo;
import com.dataiku.dip.deployer.common.deployments.AbstractDeploymentManager;
import com.dataiku.dip.deployer.common.deployments.AbstractDeploymentsService;
import com.dataiku.dip.deployer.common.engine.DeploymentHooksRunner;
import com.dataiku.dip.deployer.common.engine.DeploymentReport;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.externalinfras.azureml.AzureMLUtils;
import com.dataiku.dip.futures.FutureResponse;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.PasswordEncryptionService;
import com.dataiku.dip.server.notifications.DSSEvent;
import com.dataiku.dip.server.notifications.backend.APIDeployerDeploymentUpdatedWithoutErrorsEvent;
import com.dataiku.dip.server.services.PubSubService;
import com.dataiku.dip.transactions.ifaces.RWTransaction;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.utils.PathUtils;
import com.dataiku.lambda.client.BaseLambdaAPIClient;
import com.dataiku.lambda.model.serverconfig.GenerationsMapping;
import com.dataiku.lambda.model.studioconfig.ApiEndpointQuery;
import com.google.common.collect.Lists;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.net.URISyntaxException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class AbstractAPIServiceDeploymentManager<R extends APIDeploymentReport>
extends AbstractDeploymentManager<AbstractAPIServiceDeployment, AbstractPublishedItemBasicInfo.PublishedAPIServiceBasicInfo, AbstractAPIDeploymentInfra, R> {
    @Autowired
    protected PublishedAPIServicesService publishedAPIServicesService;
    @Autowired
    protected PasswordEncryptionService passwordEncryptionService;
    @Autowired
    protected APIServiceDeploymentsService apiServiceDeploymentsService;
    @Autowired
    protected PubSubService pubSub;
    @Autowired
    protected ApiServiceDeployerKeysCRUDService apiServiceDeployerKeysCRUDService;
    protected int connectTimeout;
    protected int socketTimeout;
    public static final Set<String> neverEverDeployed = Collections.synchronizedSet(new HashSet());

    protected AbstractAPIServiceDeploymentManager(AuthCtx authCtx, int connectTimeout, int socketTimeout) {
        super(authCtx);
        this.connectTimeout = connectTimeout;
        this.socketTimeout = socketTimeout;
    }

    @Override
    protected AbstractDeploymentsService<AbstractAPIServiceDeployment, AbstractPublishedItemBasicInfo.PublishedAPIServiceBasicInfo, AbstractAPIDeploymentInfra> getDeploymentsService() {
        return this.apiServiceDeploymentsService;
    }

    @Override
    @Nonnull
    protected String getDeploymentPrettyName() {
        return "deployment of API service version";
    }

    @Override
    protected void postDeploymentActions(@Nonnull R report) throws InterruptedException {
        if (!InfoMessage.Severity.ERROR.equals((Object)((APIDeploymentReport)((Object)report)).maxSeverity)) {
            this.pubSub.publish((DSSEvent)new APIDeployerDeploymentUpdatedWithoutErrorsEvent(((AbstractAPIServiceDeployment)this.getDeployment()).id, ((AbstractAPIServiceDeployment)this.getDeployment()).infraId));
        }
    }

    @Override
    @Nonnull
    protected DeploymentHooksRunner.DeploymentHookMetadata getDeploymentHookMetadata() {
        return new DeploymentHooksRunner.ApiDeploymentHookMetadata((AbstractAPIServiceDeployment)this.getDeployment());
    }

    @Override
    protected VersionTag updateDeploymentTag() throws IOException {
        VersionTag updatedDeploymentTag;
        try (RWTransaction tr = this.transactionService.beginWriteAsLoggedInUser(this.authCtx);){
            String identifier = this.authCtx.getIdentifier();
            AbstractAPIServiceDeployment deployment = (AbstractAPIServiceDeployment)this.apiServiceDeploymentsService.getDeploymentDAO().getMandatory(((AbstractAPIServiceDeployment)this.getDeployment()).id);
            deployment.deploymentTag = updatedDeploymentTag = VersionTag.increment(deployment.deploymentTag, identifier);
            this.apiServiceDeploymentsService.getDeploymentDAO().save(deployment);
            tr.commit("Updated deploymentTag");
        }
        return updatedDeploymentTag;
    }

    public static GenerationsMapping enrichedGenerationsMapping(AbstractAPIServiceDeployment deployment) {
        GenerationsMapping enriched = (GenerationsMapping)JSON.deepCopy((Object)deployment.generationsMapping);
        JsonObject apiDeployerDeployment = new JsonObject();
        apiDeployerDeployment.addProperty("deploymentId", deployment.id);
        apiDeployerDeployment.addProperty("publishedServiceId", deployment.publishedServiceId);
        apiDeployerDeployment.addProperty("infraId", deployment.infraId);
        if (enriched != null) {
            enriched.auditMetadata.add("apiDeployerDeployment", (JsonElement)apiDeployerDeployment);
            String generation = deployment.getOpenAPISettingsGenerationIfIsUsedOrNull();
            if (generation != null) {
                enriched.openAPIGeneration = generation;
            }
        }
        return enriched;
    }

    public static AbstractAPIServiceDeploymentManager getManagerForInfraAndDeployment(AuthCtx authCtx, @Nonnull AbstractAPIDeploymentInfra infra, @Nonnull AbstractAPIServiceDeployment deployment, int connectTimeout, int socketTimeout) {
        if (infra instanceof K8SAPIDeploymentInfra && deployment instanceof K8SAPIServiceDeployment) {
            return new SingleK8SDeploymentManager(authCtx, (K8SAPIServiceDeployment)deployment, (K8SAPIDeploymentInfra)infra, connectTimeout, socketTimeout);
        }
        if (infra instanceof StaticAPIDeploymentInfra && deployment instanceof StaticDeployment) {
            return new SingleStaticDeploymentManager(authCtx, (StaticDeployment)deployment, (StaticAPIDeploymentInfra)infra, connectTimeout, socketTimeout);
        }
        if (infra instanceof SageMakerAPIDeploymentInfra && deployment instanceof SageMakerAPIDeployment) {
            return new SageMakerDeploymentManager(authCtx, (SageMakerAPIDeployment)deployment, (SageMakerAPIDeploymentInfra)infra, connectTimeout, socketTimeout);
        }
        if (infra instanceof AzureMLAPIDeploymentInfra && deployment instanceof AzureMLAPIDeployment) {
            return new AzureMLDeploymentManager(authCtx, (AzureMLAPIDeployment)deployment, (AzureMLAPIDeploymentInfra)infra, connectTimeout, socketTimeout);
        }
        if (infra instanceof DatabricksAPIDeploymentInfra && deployment instanceof DatabricksAPIDeployment) {
            return new DatabricksDeploymentManager(authCtx, (DatabricksAPIDeployment)deployment, (DatabricksAPIDeploymentInfra)infra, connectTimeout, socketTimeout);
        }
        if (infra instanceof SnowparkAPIDeploymentInfra && deployment instanceof SnowparkAPIDeployment) {
            return new SnowparkDeploymentManager(authCtx, (SnowparkAPIDeployment)deployment, (SnowparkAPIDeploymentInfra)infra, connectTimeout, socketTimeout);
        }
        if (infra instanceof VertexAIAPIDeploymentInfra && deployment instanceof VertexAIAPIDeployment) {
            return new VertexAIDeploymentManager(authCtx, (VertexAIAPIDeployment)deployment, (VertexAIAPIDeploymentInfra)infra, connectTimeout, socketTimeout);
        }
        throw new IllegalArgumentException("Unsupported type combination: " + infra.getClass().getCanonicalName() + " and " + deployment.getClass().getCanonicalName());
    }

    public abstract APIServiceDeploymentHeavyStatus getStatus_Unsafe_NT(boolean var1, @Nullable String var2) throws IOException, InterruptedException, DKUSecurityException, URISyntaxException, AzureMLUtils.AzureAuthenticationException, SQLException;

    abstract FutureResponse<String> startDiagnosis() throws Exception;

    abstract void getDiagnosis(HttpServletResponse var1, String var2) throws Exception;

    public abstract BaseLambdaAPIClient.ApiEndpointResponses runQueries_NT(String var1, APIServiceDeploymentHeavyStatus.EndpointSummary var2, AbstractDeploymentLightStatus.APIServiceDeploymentLightStatus var3, APIServiceDeploymentHeavyStatus var4, List<ApiEndpointQuery> var5, boolean var6) throws IOException, DKUSecurityException, URISyntaxException, InterruptedException, AzureMLUtils.AzureAuthenticationException, SQLException;

    public BaseLambdaAPIClient.ApiEndpointResponses runQueries_NT(String deployedServiceId, String endpointId, AbstractDeploymentLightStatus.APIServiceDeploymentLightStatus lightStatus, APIServiceDeploymentHeavyStatus heavyStatus, List<ApiEndpointQuery> queries, Map<String, ApiEndpointQuery> additionalQueries, boolean forTest) throws IOException, DKUSecurityException, URISyntaxException, InterruptedException, AzureMLUtils.AzureAuthenticationException, SQLException {
        String deploymentId = ((AbstractAPIServiceDeployment)this.getDeployment()).id;
        this.getLogger().debugV("Running queries for deployment %s and endpointId %s.", new Object[]{deploymentId, endpointId});
        APIServiceDeploymentHeavyStatus.EndpointSummary endpoint = heavyStatus.endpoints.stream().filter(e -> e.id.equals(endpointId)).findFirst().orElseThrow(() -> new IllegalArgumentException("Endpoint " + endpointId + " not found in deployment " + deploymentId));
        List<ApiEndpointQuery> allQueries = AbstractAPIServiceDeploymentManager.getAllQueries(endpointId, queries, additionalQueries);
        return this.runQueries_NT(deployedServiceId, endpoint, lightStatus, heavyStatus, allQueries, forTest);
    }

    private static List<ApiEndpointQuery> getAllQueries(String endpointId, List<ApiEndpointQuery> testQueries, Map<String, ApiEndpointQuery> additionalTestQueries) {
        ApiEndpointQuery additionalQuery;
        ArrayList allQueries = Lists.newArrayList(testQueries);
        if (additionalTestQueries != null && (additionalQuery = additionalTestQueries.get(endpointId)) != null) {
            allQueries.add(additionalQuery);
        }
        return allQueries;
    }

    @Nullable
    public static String computeUrlForStorageInfo(@Nonnull Map<String, DSSConnection> remappedConnections, @Nullable String connectionName, @Nullable String pathWithinConnection, @Nullable String bucket) {
        String nonNullBucket;
        DSSConnection connection = remappedConnections.get(connectionName);
        if (connection == null) {
            return null;
        }
        String nonNullPath = StringUtils.isBlank((String)pathWithinConnection) ? "" : pathWithinConnection;
        String string = nonNullBucket = StringUtils.isBlank((String)bucket) ? "" : bucket;
        if (connection instanceof FsConnection) {
            FsConnection.Params fsParams = ((FsConnection)connection).params;
            String root = StringUtils.isBlank((String)fsParams.root) ? "/" : fsParams.root;
            return PathUtils.slashes((String)(root + "/" + nonNullPath), null, (Boolean)true, (boolean)true, (String)"/");
        }
        if (connection instanceof EC2Connection) {
            EC2Connection.Params s3Params = ((EC2Connection)connection).params;
            String chbucket = StringUtils.isNotBlank((String)s3Params.chbucket) ? s3Params.chbucket : nonNullBucket;
            String fullPath = PathUtils.makeTrailingNoLeading((String)PathUtils.canonical((String)ChrootUtils.getChrootedPath(s3Params.chroot, nonNullPath, false)));
            String regionOrEndpoint = s3Params.regionOrEndpoint;
            if (regionOrEndpoint == null || regionOrEndpoint.contains("://")) {
                return null;
            }
            return String.format("https://%s.console.aws.amazon.com/s3/buckets/%s?region=%s&prefix=%s", regionOrEndpoint, chbucket, regionOrEndpoint, fullPath);
        }
        if (connection instanceof AzureConnection) {
            return null;
        }
        if (connection instanceof GCSConnection) {
            GCSConnection.Params gcsParams = ((GCSConnection)connection).params;
            String chbucket = StringUtils.isNotBlank((String)gcsParams.chbucket) ? gcsParams.chbucket : nonNullBucket;
            String fullPath = PathUtils.makeNotLeadingNoTrailing((String)PathUtils.canonical((String)ChrootUtils.getChrootedPath(gcsParams.chroot, nonNullPath, false)));
            return String.format("https://console.cloud.google.com/storage/browser/%s/%s?project=%s", chbucket, fullPath, gcsParams.projectId);
        }
        return null;
    }

    public void createDeployerKeyIfAuthorizationToQueryThroughDeployer(AbstractAPIServiceDeployment deployment, InfoMessage.InfoMessages ret) {
        boolean hasAPermissionToQueryThroughDeployer = deployment.auth.permissions.stream().anyMatch(permission -> permission.queryThroughDeployer);
        try {
            if (hasAPermissionToQueryThroughDeployer) {
                this.apiServiceDeployerKeysCRUDService.createIfNeeded(deployment.id);
            } else {
                this.apiServiceDeployerKeysCRUDService.save(deployment.id, null);
            }
        }
        catch (Exception e) {
            this.getLogger().warn((Object)"Could not retrieve or create the deployer key set the query through deployer authorization.", (Throwable)e);
            ret.withWarning((InfoMessage.MessageCode)DeployerCodes.WARN_API_DEPLOYER_STATIC_SYNC_DEPLOYER_KEY, "Could not retrieve or create the deployer key set the query through deployer authorization.");
        }
    }

    public static abstract class APIDeploymentReport
    extends DeploymentReport {
        @Override
        public void preHookFailure() {
            logger.error((Object)"Error during execution of pre deployment hooks. Deployment of API service version not performed.");
            this.deploymentHookExecutionStatus.preHookFailed = true;
        }
    }
}

